/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database.actions;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.data.conversion.DefaultDataTransformer;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.discovery.windows.WindowsAttributes;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.json.JSONObject;

public class DataBaseReqestProcessor {
    private static final Logger LOGGER = Logger.getLogger(DataBaseReqestProcessor.class.getName());

    public static void initializeWindowsAttributes(String categryName, JSONObject domainDetails, DiscoveryParameters parameters) throws DataAccessException {
        ArrayList<String> attributeList = parameters.getAttriubuteList();
        ArrayList<WindowsAttributes> attributeDetails = parameters.getAttriubuteDetails();
        ArrayList<String> columnOrder = new ArrayList<String>();
        Table categ = Table.getTable((String)"ELAWindowsDiscoveryCategories");
        Table attrmapping = Table.getTable((String)"ELAWindowsAttributeMapping");
        Table attrdetails = Table.getTable((String)"ELAWindowsAttributeDetails");
        SelectQueryImpl query = new SelectQueryImpl(categ);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        query.addJoin(new Join(categ, attrmapping, new String[]{"CATEGORY_ID"}, new String[]{"CATEGORY_ID"}, 2));
        query.addJoin(new Join(attrmapping, attrdetails, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"ELAWindowsAttributeMapping", (String)"PRIORITY"), true));
        Criteria crit = new Criteria(Column.getColumn((String)"ELAWindowsDiscoveryCategories", (String)"CATEGORY_NAME"), (Object)categryName, 0, false);
        query.setCriteria(crit);
        DataObject dobj = PersistenceDBUtil.getPersistenceLite().get((SelectQuery)query);
        Iterator itr = dobj.getRows("ELAWindowsAttributeDetails");
        while (itr.hasNext()) {
            WindowsAttributes attr = new WindowsAttributes();
            Row row = (Row)itr.next();
            String attrName = (String)row.get("ATTRIB_LDAP_NAME");
            attr.setAttributeName((String)row.get("ATTRIB_DISP_NAME"));
            attr.setFieldName(attrName);
            if (row.get("ATTRIB_SOURCE_FIELD") != null) {
                attr.setSourceAttribute((String)row.get("ATTRIB_SOURCE_FIELD"));
            } else {
                attr.setSourceAttribute(attrName);
            }
            if (row.get("DEFAULTVALUE_CONVERSION_ID") != null) {
                HashMap<String, JSONObject> args = new HashMap<String, JSONObject>();
                args.put("discoverydomaindetails", domainDetails);
                Long transFormer = (Long)row.get("DEFAULTVALUE_CONVERSION_ID");
                if (transFormer != null) {
                    Object afterConversion = null;
                    try {
                        afterConversion = DefaultDataTransformer.getTransformer(transFormer).transform(null, args, null);
                    }
                    catch (BaseStatusCode code) {
                        LOGGER.fine("Got Exception while converting Field " + attr.getFieldName() + " ,  Details " + code.getMessage());
                    }
                    if (afterConversion != null) {
                        attr.setFieldDefaultValue(afterConversion.toString());
                    }
                }
            }
            if (row.get("TRANSFORMER_ID") != null) {
                attr.setTransFormerID((Long)row.get("TRANSFORMER_ID"));
            }
            attributeList.add(attrName);
            attributeDetails.add(attr);
            columnOrder.add((String)row.get("ATTRIB_COLUMN_NAME"));
        }
        parameters.setColumnOrder(StringUtil.listToString(columnOrder));
    }

    public static void executeUpdateQuery(String tableName, String column, Object value, Criteria criteria, boolean ... flag) throws DataAccessException {
        UpdateQueryImpl updateQuery = new UpdateQueryImpl(tableName);
        updateQuery.setCriteria(criteria);
        updateQuery.setUpdateColumn(column, value);
        PersistenceDBUtil.getPersistence((boolean[])flag).update((UpdateQuery)updateQuery);
    }

    public static void executeUpdateQuery(String tableName, List<String> column, List<Object> value, Criteria criteria, boolean ... flag) throws DataAccessException {
        UpdateQueryImpl updateQuery = new UpdateQueryImpl(tableName);
        updateQuery.setCriteria(criteria);
        for (int index = 0; index < column.size(); ++index) {
            updateQuery.setUpdateColumn(column.get(index), value.get(index));
        }
        PersistenceDBUtil.getPersistence((boolean[])flag).update((UpdateQuery)updateQuery);
    }

    public static void executeUpdateQuery(String tableName, Map<String, Object> data, Criteria criteria, boolean ... flag) throws Exception {
        UpdateQueryImpl updateQuery = new UpdateQueryImpl(tableName);
        updateQuery.setCriteria(criteria);
        Set<String> keySet = data.keySet();
        for (String key : keySet) {
            updateQuery.setUpdateColumn(key.toString(), data.get(key));
        }
        PersistenceDBUtil.getPersistence((boolean[])flag).update((UpdateQuery)updateQuery);
    }
}

