/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database.backup;

import com.adventnet.db.adapter.BackupDBParams;
import com.adventnet.db.adapter.BackupRestoreConfigurations;
import com.adventnet.db.adapter.BackupRestoreException;
import com.adventnet.db.adapter.BackupResult;
import com.manageengine.ads.fw.db.backup.ADSPostgresBackupHandler;
import com.zoho.framework.utils.archive.SevenZipUtils;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ELAPostgresBackupHandler
extends ADSPostgresBackupHandler {
    Logger logger = Logger.getLogger("ADSLogger");

    public BackupResult doBackup(BackupDBParams backupdbparams) throws BackupRestoreException {
        BackupResult backupResult = null;
        try {
            backupResult = super.doBackup(backupdbparams);
            if (backupResult.getBackupStatus() == BackupRestoreConfigurations.BACKUP_STATUS.BACKUP_SUCCESSFULLY_COMPLETED) {
                String zipFile = Paths.get(backupdbparams.backupFolder.getAbsolutePath(), backupdbparams.zipFileName).toString();
                String home = System.getProperty("server.home");
                String keyFile = Paths.get(home, "conf", "ela_key.key").toString();
                ArrayList<String> fileList = new ArrayList<String>();
                fileList.add(keyFile);
                SevenZipUtils.appendInZip((String)zipFile, fileList);
            }
        }
        catch (Exception ioe) {
            this.logger.log(Level.INFO, " ", ioe);
        }
        return backupResult;
    }
}

