/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database.backup;

import com.adventnet.db.adapter.BackupRestoreConfigurations;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.mfw.RestoreDB;
import com.adventnet.mfw.ServerInterface;
import com.adventnet.mfw.Starter;
import com.adventnet.mfw.logging.LoggerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ELAPostgresRestoreHandler {
    private static final Logger LOGGER = Logger.getLogger(RestoreDB.class.getName());

    public static void main(String[] args) {
        try {
            LoggerUtil.initLog((String)"restore");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (args.length == 0) {
            ConsoleOut.println((String)"File to be restored is not specified");
            System.exit(1);
        }
        String src = args[0];
        ELAPostgresRestoreHandler.restoreDB(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreDB(String srcFile) {
        if (srcFile == null || srcFile.equals("")) {
            ConsoleOut.println((String)"File to be restored is not specified");
            System.exit(1);
        }
        String src = srcFile;
        boolean exitStatus = true;
        try {
            if (!new File(src).exists()) {
                ConsoleOut.println((String)("Please enter a valid File Name [" + src + "]."));
                throw new FileNotFoundException("Please enter a valid File Name [" + src + "].");
            }
            if (!Starter.checkShutdownListenerPort()) {
                ConsoleOut.println((String)"\nServer seems to be running. Please shutdown server.\n");
                throw new RuntimeException("Server seems to be running. Please shutdown server.");
            }
            LOGGER.log(Level.INFO, "Restore DB Started");
            Starter.loadSystemProperties();
            ServerInterface server = Starter.getNewServerClassInstance();
            Starter.initializeDiskSpaceMonitor();
            int status = server.restoreDB(src);
            if (status == BackupRestoreConfigurations.RESTORE_STATUS.RESTORE_SUCCESSFULLY_COMPLETED.getValue()) {
                String keyName = "ela_key.key";
                String home = System.getProperty("server.home");
                String keyFile = Paths.get(home, "conf", keyName).toString();
                ELAPostgresRestoreHandler.restoreELAKey(src, keyName, keyFile);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Problem while Restoring DB. ", e);
            e.printStackTrace();
            exitStatus = false;
        }
        finally {
            Starter.shutDownDiskSpaceMonitor();
            if (exitStatus) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
    }

    private static void restoreELAKey(String zipName, String keyFileName, String keypath) throws IOException {
        block41: {
            try (ZipFile zip = new ZipFile(zipName);){
                ZipEntry entry = zip.getEntry(keyFileName);
                if (entry != null) {
                    Files.move(Paths.get(keypath, new String[0]), Paths.get(keypath + "_old", new String[0]), StandardCopyOption.ATOMIC_MOVE);
                    try (InputStream in = zip.getInputStream(entry);
                         BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(keypath));){
                        ELAPostgresRestoreHandler.copyInputStream(in, out);
                        ConsoleOut.println((String)"Key file restored");
                        LOGGER.log(Level.INFO, "Key file restored");
                        break block41;
                    }
                    catch (Exception e) {
                        ConsoleOut.println((String)("key file not restored : " + e));
                        LOGGER.log(Level.INFO, "key file not restored : " + e);
                        e.printStackTrace();
                    }
                    break block41;
                }
                ConsoleOut.println((String)"Key file not found in backup");
                LOGGER.log(Level.INFO, "Key file not found in backup");
            }
            catch (Exception e) {
                ConsoleOut.println((String)("key file not restored : " + e));
                LOGGER.log(Level.INFO, "key file not restored : " + e);
            }
        }
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.flush();
    }
}

