/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database.constants;

public enum SearchType {
    EQUALS(0),
    EQUALS_IGNORE_CASE(1),
    NOT_EQUALS(2),
    CONTAINS(3),
    CONTAINS_IGNORE_CASE(4);

    private Integer value = null;

    public int getValue() {
        return this.value;
    }

    private SearchType(Integer value) {
        this.value = value;
    }

    public boolean applyCondition(String one, String two) {
        switch (this) {
            case EQUALS: {
                return one.equals(two);
            }
            case EQUALS_IGNORE_CASE: {
                return one.equalsIgnoreCase(two);
            }
            case NOT_EQUALS: {
                return !one.equals(two);
            }
            case CONTAINS: {
                return one.contains(two);
            }
        }
        return one.toLowerCase().contains(two.toLowerCase());
    }
}

