/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database.generator;

import com.adventnet.db.adapter.mysql.MysqlSQLGenerator;
import com.adventnet.db.persistence.metadata.DataTypeManager;
import com.adventnet.ds.query.Column;
import com.manageengine.ela.server.common.security.ELAEncryptionAPI;
import java.util.logging.Logger;

public class ELAMysqlSQLGenerator
extends MysqlSQLGenerator {
    private static final Logger LOG = Logger.getLogger(ELAMysqlSQLGenerator.class.getName());
    private static boolean isKeyGenerated = false;

    public String getDBSpecificEncryptionString(Column column, String value) {
        if (DataTypeManager.isDataTypeSupported((String)column.getDataType()) && DataTypeManager.getDataType((String)column.getDataType()).getBaseType() == null) {
            return DataTypeManager.getDataType((String)column.getDataType()).getDTSQLGenerator(this.dbType).getDTSpecificEncryptionString(column, value);
        }
        if (column.isEncrypted()) {
            if (!isKeyGenerated) {
                String encryptKey = ELAEncryptionAPI.getSecureKey(value, 3);
                if (encryptKey == null || "".equals(encryptKey)) {
                    return "AES_ENCRYPT(" + value + ", 'null')";
                }
                isKeyGenerated = true;
                return ELAEncryptionAPI.getSecureKey(value, 1);
            }
            return ELAEncryptionAPI.getSecureKey(value, 1);
        }
        return value;
    }

    public String getDBSpecificDecryptionString(Column column, String value) {
        if (DataTypeManager.isDataTypeSupported((String)column.getDataType()) && DataTypeManager.getDataType((String)column.getDataType()).getBaseType() == null) {
            return DataTypeManager.getDataType((String)column.getDataType()).getDTSQLGenerator(this.dbType).getDTSpecificDecryptionString(column, value);
        }
        if (ELAEncryptionAPI.useNullDecryption) {
            return column.isEncrypted() ? "CONVERT(AES_DECRYPT(" + value + ", 'null') USING " + this.defaultCharacterSet + ")" : value;
        }
        if (ELAEncryptionAPI.useOldDecryption) {
            return column.isEncrypted() ? "CONVERT(AES_DECRYPT(" + value + ", '" + super.getKey() + "') USING " + this.defaultCharacterSet + ")" : value;
        }
        if (column.isEncrypted()) {
            if (!isKeyGenerated) {
                String encryptKey = ELAEncryptionAPI.getSecureKey(value, 3);
                if (encryptKey == null || "".equals(encryptKey)) {
                    return "CONVERT(AES_DECRYPT(" + value + ", 'null') USING " + this.defaultCharacterSet + ")";
                }
                isKeyGenerated = true;
                return ELAEncryptionAPI.getSecureKey(value, 2);
            }
            return ELAEncryptionAPI.getSecureKey(value, 2);
        }
        return value;
    }
}

