/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database.generator;

import com.adventnet.db.adapter.postgres.PostgresSQLGenerator;
import com.adventnet.db.persistence.metadata.DataTypeManager;
import com.adventnet.ds.query.Column;
import com.manageengine.ela.server.common.database.PGSQLServerFunctions;
import com.manageengine.ela.server.common.security.ELAEncryptionAPI;
import java.util.logging.Logger;

public class ELAPGSQLGenerator
extends PostgresSQLGenerator {
    private static final Logger LOG = Logger.getLogger(ELAPGSQLGenerator.class.getName());
    private static boolean isKeyGenerated = false;
    private static boolean isFunctionCreated = false;

    public String getDBSpecificEncryptionString(Column column, String value) {
        if (!isFunctionCreated) {
            try {
                PGSQLServerFunctions.createSQLFunctions();
                isFunctionCreated = true;
            }
            catch (Exception e) {
                LOG.warning("Exception while creating PGSQLServerFunctions : " + e.toString());
                e.printStackTrace();
            }
        }
        if (column.isEncrypted()) {
            String encryptFunctionName;
            String dataType = column.getDefinition().getDataType();
            if (DataTypeManager.isDataTypeSupported((String)column.getDataType()) && DataTypeManager.getDataType((String)column.getDataType()).getBaseType() == null) {
                return DataTypeManager.getDataType((String)column.getDataType()).getDTSQLGenerator(this.dbType).getDTSpecificEncryptionString(column, value);
            }
            if (DataTypeManager.isDataTypeSupported((String)column.getDataType()) && DataTypeManager.getDataType((String)column.getDataType()).getBaseType() != null) {
                dataType = DataTypeManager.getDataType((String)dataType).getBaseType();
            }
            String string = encryptFunctionName = dataType.equals("SBLOB") ? "pgp_sym_encrypt_bytea" : "pgp_sym_encrypt";
            if (!isKeyGenerated) {
                String encryptKey = ELAEncryptionAPI.getSecureKey(value, 3);
                if (encryptKey == null || "".equals(encryptKey)) {
                    return encryptFunctionName + "(" + value + ",'null','s2k-mode=1,cipher-algo=" + "aes256" + "')";
                }
                isKeyGenerated = true;
                return encryptFunctionName + "(" + value + ",'" + encryptKey + "','s2k-mode=1,cipher-algo=" + "aes256" + "')";
            }
            return encryptFunctionName + "(" + value + ",'" + ELAEncryptionAPI.getSecureKey(value, 3) + "','s2k-mode=1,cipher-algo=" + "aes256" + "')";
        }
        return value;
    }

    public String getDBSpecificDecryptionString(Column column, String value) {
        if (!isFunctionCreated) {
            try {
                PGSQLServerFunctions.createSQLFunctions();
                isFunctionCreated = true;
            }
            catch (Exception e) {
                LOG.warning("Exception while creating PGSQLServerFunctions : " + e.toString());
                e.printStackTrace();
            }
        }
        if (ELAEncryptionAPI.useOldDecryption) {
            if (column.isEncrypted()) {
                String dataType = column.getDefinition().getDataType();
                String encryptFunctionName = dataType.equals("SBLOB") ? "pgp_sym_decrypt_bytea" : "pgp_sym_decrypt";
                return encryptFunctionName + "(" + value + ",'" + super.getKey() + "','cipher-algo=" + "aes256" + "')";
            }
        } else if (ELAEncryptionAPI.useNullDecryption) {
            if (column.isEncrypted()) {
                String dataType = column.getDefinition().getDataType();
                String encryptFunctionName = dataType.equals("SBLOB") ? "pgp_sym_decrypt_bytea" : "pgp_sym_decrypt";
                return encryptFunctionName + "(" + value + ",'null','cipher-algo=" + "aes256" + "')";
            }
        } else if (column.isEncrypted()) {
            String encryptFunctionName;
            String dataType = column.getDefinition().getDataType();
            if (DataTypeManager.isDataTypeSupported((String)column.getDataType()) && DataTypeManager.getDataType((String)column.getDataType()).getBaseType() == null) {
                return DataTypeManager.getDataType((String)column.getDataType()).getDTSQLGenerator(this.dbType).getDTSpecificDecryptionString(column, value);
            }
            if (DataTypeManager.isDataTypeSupported((String)column.getDataType()) && DataTypeManager.getDataType((String)column.getDataType()).getBaseType() != null) {
                dataType = DataTypeManager.getDataType((String)dataType).getBaseType();
            }
            String string = encryptFunctionName = dataType.equals("SBLOB") ? "decryptsblob" : "decryptschar";
            if (!isKeyGenerated) {
                String encryptKey = ELAEncryptionAPI.getSecureKey(value, 3);
                if (encryptKey == null || "".equals(encryptKey)) {
                    return encryptFunctionName + "(" + value + ",'null')";
                }
                isKeyGenerated = true;
                return encryptFunctionName + "(" + value + ",'" + encryptKey + "')";
            }
            return encryptFunctionName + "(" + value + ",'" + ELAEncryptionAPI.getSecureKey(value, 3) + "')";
        }
        return value;
    }

    public String getSQLWithHiddenEncryptionKey(String query) {
        String key;
        if (query.contains("pgp_sym_encrypt")) {
            String key2 = ELAEncryptionAPI.getSecureKey(null, 3);
            if (key2 != null && query.contains('\'' + key2 + '\'')) {
                query = query.replace('\'' + key2 + '\'', "'****'");
            }
        } else if ((query.contains("pgp_sym_decrypt") || query.contains("decryptschar") || query.contains("decryptsblob")) && ELAEncryptionAPI.useOldDecryption) {
            String key3 = super.getKey();
            if (key3 != null && query.contains('\'' + key3 + '\'')) {
                query = query.replace('\'' + key3 + '\'', "'****'");
            }
        } else if ((query.contains("pgp_sym_decrypt") || query.contains("decryptschar") || query.contains("decryptsblob")) && (key = ELAEncryptionAPI.getSecureKey(null, 3)) != null && query.contains('\'' + key + '\'')) {
            query = query.replace('\'' + key + '\'', "'****'");
        }
        return query;
    }
}

