/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database.handlers.mssql;

import com.adventnet.la.util.QueryUtil;
import com.adventnet.persistence.PersistenceInitializer;
import com.manageengine.ela.server.common.database.BulkUploadDetailsBean;
import com.manageengine.ela.server.common.database.DataBaseSpecificActions;
import com.manageengine.ela.server.common.database.DefaultDatabaseHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.IOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Logger;

public class MSSQLDataBaseHandler
extends DefaultDatabaseHandler {
    private String delimiter = "|**|";
    private boolean isNtlmSso = false;
    private static final Logger LOGGER = Logger.getLogger(MSSQLDataBaseHandler.class.getName());

    @Override
    public DataBaseSpecificActions init() {
        Properties dbProp;
        block8: {
            dbProp = PersistenceInitializer.getDefaultDBProps();
            this.connectionURL = dbProp.getProperty("url");
            this.connectionURL = this.connectionURL.replaceAll(" ", "");
            try {
                URI uri = new URI(this.connectionURL);
                if (uri.getHost() == null || uri.getPort() == -1) {
                    throw new Exception("URI parsing fails.going to parse manually");
                }
                this.dbServer = uri.getHost();
                this.dbPort = Integer.toString(uri.getPort());
                this.dbName = uri.getPath().substring(1);
                if (this.dbName.contains("instance=")) {
                    this.instanceName = this.dbName.substring(this.dbName.indexOf("instance=") + 9);
                }
                if (!this.dbName.contains(";")) break block8;
                this.dbName = this.dbName.substring(0, this.dbName.indexOf(";"));
            }
            catch (Exception e) {
                String[] url = this.connectionURL.split(":");
                this.dbServer = url[3].substring(2);
                url = url[4].split(";");
                this.dbPort = url[0];
                for (int i = 1; i < url.length; ++i) {
                    String[] params = url[i].split("=");
                    if ("DatabaseName".equalsIgnoreCase(params[0])) {
                        this.dbName = params[1];
                        continue;
                    }
                    if ("Domain".equalsIgnoreCase(params[0])) {
                        this.domain = params[1];
                        this.isNtlmSso = true;
                        continue;
                    }
                    if (!"instance".equalsIgnoreCase(params[0])) continue;
                    this.instanceName = params[1];
                }
            }
        }
        this.userName = dbProp.getProperty("username");
        if (this.domain != null) {
            this.userName = this.domain + "\\" + this.userName;
        }
        this.password = dbProp.getProperty("password");
        return this;
    }

    @Override
    public String getFieldDelimiter() {
        return this.delimiter;
    }

    @Override
    public String getNullValue() {
        return "";
    }

    @Override
    public String getEscapedString(String value) {
        return super.getEscapedString(value);
    }

    @Override
    public boolean dumpData(String command) throws IllegalArgumentException {
        boolean result = false;
        this.lock.lock();
        try {
            LOGGER.fine("DumpData called with command : " + QueryUtil.formatMSSQLQuery((String)command));
            result = this.executeBCPCommand(command);
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeBCPCommand(String command) {
        boolean status = true;
        BufferedReader in = null;
        FileOutputStream fos = null;
        File home = new File(System.getProperty("server.dir") + File.separator + "bin");
        try {
            fos = new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "dbDump.log", true);
        }
        catch (Exception exp) {
            LOGGER.info(BaseStatusCode.getBaseStatusCode(6657).toString());
        }
        try {
            MSSQLDataBaseHandler exp = this;
            synchronized (exp) {
                this.checkAndWrite(fos, "Dumping command - " + QueryUtil.formatMSSQLQuery((String)command));
                String[] commands = new String[]{"CMD", "/C", command};
                ProcessBuilder builder = new ProcessBuilder(commands);
                builder.redirectErrorStream(true);
                if (home.exists()) {
                    builder.directory(home);
                }
                Process process = builder.start();
                in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String temp = null;
                while ((temp = in.readLine()) != null) {
                    if (temp.contains("BCP copy in failed") || temp.contains("Error")) {
                        status = false;
                    }
                    this.checkAndWrite(fos, temp);
                }
                process.destroy();
                this.checkAndWrite(fos, "--------------------------------------------------------------------\n");
            }
        }
        catch (Exception ex) {
            try {
                status = false;
                this.checkAndWrite(fos, "\nError while executing query to import sql file into database");
            }
            catch (Throwable throwable) {
                IOUtil.closeIOStream(null, fos);
                IOUtil.closeReaderWriter(in, null);
                throw throwable;
            }
            IOUtil.closeIOStream(null, fos);
            IOUtil.closeReaderWriter(in, null);
        }
        IOUtil.closeIOStream(null, fos);
        IOUtil.closeReaderWriter(in, null);
        return status;
    }

    private void checkAndWrite(FileOutputStream fos, String data) {
        if (fos != null) {
            try {
                fos.write((data + "\n").getBytes());
            }
            catch (IOException e) {
                LOGGER.info(data + " \n Exception details : " + e.getMessage());
            }
        }
    }

    public String getDataBaseInstance() {
        return this.instanceName;
    }

    @Override
    public String getFileEncoding() {
        return "UTF-16LE";
    }

    @Override
    public String loadDumpDataQuery(BulkUploadDetailsBean bean, String filePath) throws IllegalArgumentException {
        StringBuilder command = new StringBuilder();
        try {
            command.append("bcp.exe \"[" + this.dbName + "].dbo." + bean.getTableName() + "\" IN \"" + filePath + "\" -S " + this.dbServer);
            if (this.instanceName != null && !this.instanceName.equals("")) {
                command.append("\\" + this.instanceName);
            }
            if (this.dbPort != null && !this.dbPort.equals("")) {
                command.append("," + this.dbPort);
            }
            if (bean.getLineTerminator() != null && !System.getProperty("line.separator").equalsIgnoreCase(bean.getLineTerminator())) {
                command.append(" -r \"" + bean.getLineTerminator() + "\"");
            }
            command.append(" -t \"" + this.delimiter + "\" -e .." + File.separator + "logs" + File.separator + "datainerr.txt");
            if (bean.isCharacterFormat()) {
                command.append(" -c ");
            } else {
                command.append(" -w ");
            }
            if (this.userName == null || this.isNtlmSso) {
                command.append(" -T ");
            } else {
                command.append(" -U " + this.userName + " -P \"" + this.password + "\" ");
            }
            if (bean.isNullValueForEmptyColumn()) {
                command.append(" -k ");
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception while data dump : " + e.getMessage());
        }
        return command.toString();
    }

    @Override
    public String getEncloseChar() {
        return "";
    }

    @Override
    public int getBulkUploadLimit() {
        return 1000;
    }
}

