/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database.handlers.mysql;

import com.manageengine.ela.server.common.database.BulkUploadDetailsBean;
import com.manageengine.ela.server.common.database.DefaultDatabaseHandler;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class MySQLDataBaseHandler
extends DefaultDatabaseHandler {
    private static final Logger LOGGER = Logger.getLogger(MySQLDataBaseHandler.class.getName());

    @Override
    public boolean dumpData(String query) throws IllegalArgumentException {
        boolean status = true;
        LOGGER.fine("DumpData called with query  : " + query);
        this.lock.lock();
        try {
            status = super.executeQuery(query);
        }
        finally {
            this.lock.unlock();
        }
        LOGGER.fine("Dump to specified Table completed");
        return status;
    }

    @Override
    public String loadDumpDataQuery(BulkUploadDetailsBean bean, String filePath) {
        StringBuilder loadDataBuffer = new StringBuilder();
        loadDataBuffer.append("LOAD DATA LOCAL INFILE ");
        loadDataBuffer.append("'");
        loadDataBuffer.append(filePath.replace("\\", "/"));
        loadDataBuffer.append("'");
        loadDataBuffer.append(" INTO TABLE ");
        loadDataBuffer.append(bean.getTableName());
        if (bean.getFieldTerminator() != null) {
            loadDataBuffer.append(" FIELDS TERMINATED BY ");
            loadDataBuffer.append("'");
            loadDataBuffer.append(bean.getFieldTerminator());
            loadDataBuffer.append("'");
        }
        if (bean.getEscapeChar() != null) {
            loadDataBuffer.append(" ESCAPED BY ");
            loadDataBuffer.append("'");
            loadDataBuffer.append(bean.getEscapeChar());
            loadDataBuffer.append("'");
        }
        if (bean.getEncloseChar() != null) {
            loadDataBuffer.append(" ENCLOSED BY ");
            loadDataBuffer.append("'");
            loadDataBuffer.append(bean.getEncloseChar());
            loadDataBuffer.append("'");
        }
        if (bean.getLineTerminator() != null || bean.getStartingString() != null) {
            loadDataBuffer.append(" LINES");
        }
        if (bean.getLineTerminator() != null) {
            loadDataBuffer.append(" TERMINATED BY ");
            loadDataBuffer.append("'");
            loadDataBuffer.append(bean.getLineTerminator());
            loadDataBuffer.append("'");
        }
        if (bean.getStartingString() != null) {
            loadDataBuffer.append(" STARTING BY ");
            loadDataBuffer.append("'");
            loadDataBuffer.append(bean.getStartingString());
            loadDataBuffer.append("'");
        }
        if (bean.getColumnOrder() != null) {
            loadDataBuffer.append(" (");
            StringTokenizer columns = new StringTokenizer(bean.getColumnOrder(), ",");
            loadDataBuffer.append(bean.getTableName()).append(".").append(columns.nextToken());
            while (columns.hasMoreTokens()) {
                loadDataBuffer.append(",").append(bean.getTableName()).append(".").append(columns.nextToken());
            }
            loadDataBuffer.append(")");
        }
        return loadDataBuffer.toString();
    }

    @Override
    public String getEscapedString(String value) {
        return new StringBuffer(this.getEncloseChar()).append(super.getEscapedString(value)).append(this.getEncloseChar()).toString();
    }

    @Override
    public String getEncloseChar() {
        return "\"";
    }

    @Override
    public int getBulkUploadLimit() {
        return 1000;
    }
}

