/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.database.handlers.pgsql;

import com.manageengine.ela.server.common.database.BulkUploadDetailsBean;
import com.manageengine.ela.server.common.database.DefaultDatabaseHandler;
import java.util.logging.Logger;

public class PostGreSQLDataBaseHandler
extends DefaultDatabaseHandler {
    private static final Logger LOGGER = Logger.getLogger(PostGreSQLDataBaseHandler.class.getName());

    @Override
    public String loadDumpDataQuery(BulkUploadDetailsBean bean, String filePath) {
        StringBuilder loadDataBuffer = new StringBuilder();
        loadDataBuffer.append("COPY ");
        loadDataBuffer.append(bean.getTableName());
        if (bean.getColumnOrder() != null) {
            loadDataBuffer.append(" (").append(bean.getColumnOrder()).append(")");
        }
        loadDataBuffer.append(" FROM ");
        loadDataBuffer.append("'");
        loadDataBuffer.append(filePath);
        loadDataBuffer.append("'");
        if (bean.getFieldTerminator() != null) {
            loadDataBuffer.append(" WITH CSV DELIMITER '");
            loadDataBuffer.append(bean.getFieldTerminator());
            loadDataBuffer.append("'");
            if (bean.getEscapeChar() != null) {
                loadDataBuffer.append(" ESCAPE ");
                loadDataBuffer.append("'");
                loadDataBuffer.append(bean.getEscapeChar());
                loadDataBuffer.append("'");
            } else {
                loadDataBuffer.append(" ESCAPE ");
                loadDataBuffer.append("'\\'");
            }
            loadDataBuffer.append(" NULL '\\N' ");
        }
        return loadDataBuffer.toString();
    }

    @Override
    public boolean dumpData(String query) throws IllegalArgumentException {
        boolean status = true;
        LOGGER.fine("DumpData called with query  : " + query);
        this.lock.lock();
        try {
            status = super.executeQuery(query);
        }
        finally {
            this.lock.unlock();
        }
        LOGGER.fine("Dump to specified Table completed");
        return status;
    }

    @Override
    public String getEscapedString(String value) {
        return new StringBuffer(this.getEncloseChar()).append(super.getEscapedString(value)).append(this.getEncloseChar()).toString();
    }

    @Override
    public String getEncloseChar() {
        return "\"";
    }

    @Override
    public int getBulkUploadLimit() {
        return 1000;
    }
}

