/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.delegation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.group.util.DeviceGroupUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class DelegationUtil {
    private static final Logger LOGGER = Logger.getLogger(DelegationUtil.class.getName());

    public static long getGroupID(LogSourceCategoryContainer.DeviceCategory deviceCategory, UserAccessResource resource) {
        if (resource.checkItHasFullDataAccess()) {
            return deviceCategory.getDefaultGrouID();
        }
        Set<Long> groupIDCollection = resource.getAllAllowedGroups();
        if (groupIDCollection != null && groupIDCollection.size() > 0) {
            if (groupIDCollection.contains(deviceCategory.getDefaultGrouID())) {
                return deviceCategory.getDefaultGrouID();
            }
            return groupIDCollection.iterator().next();
        }
        LOGGER.info("Returning Default groupID for user : " + resource.getUserID() + "  view : " + resource.getViewID() + "  Category : " + deviceCategory.getCategoryName() + "");
        return DeviceGroupUtil.getDefaultGroupID();
    }

    private static Long[] getAllAdminUserDevices() throws DataAccessException {
        ArrayList<Long> resList = new ArrayList<Long>();
        SelectQueryImpl getAllDeviceID = new SelectQueryImpl(Table.getTable((String)"HostDetails"));
        getAllDeviceID.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID"));
        DataObject devicesDO = PersistenceDBUtil.getPersistence().get((SelectQuery)getAllDeviceID);
        if (!devicesDO.isEmpty()) {
            Iterator deviceItr = devicesDO.getRows("HostDetails");
            while (deviceItr.hasNext()) {
                Row rRow = (Row)deviceItr.next();
                resList.add((Long)rRow.get("HOST_ID"));
            }
        }
        return resList.toArray(new Long[resList.size()]);
    }
}

