/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.delegation.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.delegation.config.DynamicResourceDetails;
import com.manageengine.ela.server.common.delegation.info.RoleInfoUtil;
import java.util.Iterator;
import java.util.List;

public class ELADynamicResourceHandler {
    public static void includeViewConfigurations(DataObject dobj, DynamicResourceDetails viewConfig, Object userID) throws DataAccessException {
        Row row = new Row("ELATechnicianViewConfig");
        row.set("USER_ID", userID);
        row.set("VIEW_NAME", (Object)viewConfig.getViewName());
        row.set("VIEW_DESCRIPTION", (Object)viewConfig.getViewDescription());
        row.set("IS_EDITABLE", (Object)viewConfig.isEditable());
        row.set("IS_SYSTEMGENERATED", (Object)viewConfig.isSystemGenerated());
        row.set("IS_DEFAULT", (Object)viewConfig.isDefault());
        row.set("IS_FULLACCESS", (Object)viewConfig.isFullAccess());
        row.set("CREATION_TIME", (Object)System.currentTimeMillis());
        row.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
        dobj.addRow(row);
        if (viewConfig.getGroupIds() != null) {
            for (Long groupId : viewConfig.getGroupIds()) {
                Row viewMapping = new Row("ELAViewGroupMapping");
                viewMapping.set("VIEW_ID", row.get("VIEW_ID"));
                viewMapping.set("GROUP_ID", (Object)groupId);
                dobj.addRow(viewMapping);
            }
        }
    }

    public static void createNewViewConfiguration(DynamicResourceDetails viewConfig, Object userID) throws DataAccessException {
        DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
        ELADynamicResourceHandler.includeViewConfigurations(dobj, viewConfig, userID);
        PersistenceDBUtil.getPersistence().add(dobj);
    }

    public static void handleViewUpdate(DynamicResourceDetails viewConfig, Long userID) throws DataAccessException {
        if (viewConfig.getGroupIds() != null && viewConfig.getViewName() != null) {
            DataObject dobj = RoleInfoUtil.getViewInformation(userID, viewConfig.getViewName());
            List<Long> groupIds = viewConfig.getGroupIds();
            if (dobj.containsTable("ELATechnicianViewConfig")) {
                Row viewConfigRow = dobj.getRow("ELATechnicianViewConfig");
                viewConfigRow.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
                dobj.updateRow(viewConfigRow);
                Long viewID = (Long)viewConfigRow.get("VIEW_ID");
                Iterator itr = dobj.getRows("ELAViewGroupMapping");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    Long groupID = (Long)row.get("GROUP_ID");
                    if (groupIds.contains(groupID)) {
                        groupIds.remove(groupID);
                        continue;
                    }
                    itr.remove();
                }
                for (Long id : groupIds) {
                    Row row = new Row("ELAViewGroupMapping");
                    row.set("VIEW_ID", (Object)viewID);
                    row.set("GROUP_ID", (Object)id);
                    dobj.addRow(row);
                }
            }
            PersistenceDBUtil.getPersistence().update(dobj);
        }
    }

    public static void deleteView(Long userId, String viewName) {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"USER_ID"), (Object)userId, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"VIEW_NAME"), (Object)viewName, 0));
        DBUtil.deleteExistingRows("ELATechnicianViewConfig", criteria, new boolean[0]);
    }

    public static DataObject handleAddorDeleteGroupID(DataObject dobj, Long[] newID, Long[] removedID) throws DataAccessException {
        if (newID != null && newID.length > 0) {
            Row viewConfig = RoleInfoUtil.getTechnicianSelectedViewConfigRow(dobj, RoleInfoUtil.DEFAULT_VIEW_ID);
            viewConfig.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            dobj.updateRow(viewConfig);
            Long viewID = (Long)viewConfig.get("VIEW_ID");
            for (Long id : newID) {
                Row row = new Row("ELAViewGroupMapping");
                row.set("VIEW_ID", (Object)viewID);
                row.set("GROUP_ID", (Object)id);
                dobj.addRow(row);
            }
        }
        if (removedID != null && removedID.length > 0) {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELAViewGroupMapping", (String)"GROUP_ID"), (Object)removedID, 8);
            Iterator itr = dobj.getRows("ELAViewGroupMapping", criteria);
            while (itr.hasNext()) {
                dobj.deleteRow((Row)itr.next());
            }
        }
        return PersistenceDBUtil.getPersistence().update(dobj);
    }

    public static DataObject changeDynamicResourceToOperatorAccess(DataObject dobj, Long[] newID) throws DataAccessException {
        Row viewConfig = RoleInfoUtil.getTechnicianSelectedViewConfigRow(dobj, RoleInfoUtil.DEFAULT_VIEW_ID);
        viewConfig.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
        viewConfig.set("IS_FULLACCESS", (Object)Boolean.FALSE);
        Long defaultViewID = (Long)dobj.getFirstValue("ELATechnicianViewConfig", "VIEW_ID");
        for (Long id : newID) {
            Row row = new Row("ELAViewGroupMapping");
            row.set("VIEW_ID", (Object)defaultViewID);
            row.set("GROUP_ID", (Object)id);
            dobj.addRow(row);
        }
        dobj.updateRow(viewConfig);
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAViewGroupMapping", (String)"GROUP_ID"), (Object)newID, 9);
        Iterator itr = dobj.getRows("ELAViewGroupMapping", criteria);
        while (itr.hasNext()) {
            dobj.deleteRow((Row)itr.next());
        }
        return PersistenceDBUtil.getPersistence().update(dobj);
    }

    public static void changeDynamicResourceToAdminAccess(Long userID) throws DataAccessException {
        DataObject dobj = RoleInfoUtil.getSystemGeneratedViewInformation(userID);
        if (dobj.containsTable("ELATechnicianViewConfig")) {
            Row row = dobj.getRow("ELATechnicianViewConfig");
            row.set("IS_FULLACCESS", (Object)Boolean.TRUE);
            row.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            dobj.updateRow(row);
            dobj.deleteRows("ELAViewGroupMapping", (Criteria)null);
        }
        PersistenceDBUtil.getPersistence().update(dobj);
    }
}

