/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.delegation.config;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.delegation.config.StaticResourceDetails;
import com.manageengine.ela.server.common.delegation.info.RoleInfoUtil;
import java.util.Set;

public class ELAStaticResourceHandler {
    private static Long superadmin_role = null;

    public static void createSuperAdminRolemapping(Object userId) throws DataAccessException {
        Row roleMapping = new Row("ELATechnicianRoleMapping");
        roleMapping.set("USER_ID", userId);
        roleMapping.set("ROLE_ID", (Object)superadmin_role);
        DBUtil.createNewRow(roleMapping, new boolean[0]);
    }

    public static void includeSuperAdminRoleConfigurtion(DataObject dobj, Object userId) throws DataAccessException {
        Row roleMapping = new Row("ELATechnicianRoleMapping");
        roleMapping.set("USER_ID", userId);
        roleMapping.set("ROLE_ID", (Object)superadmin_role);
        dobj.addRow(roleMapping);
    }

    public static void delegateRoleToUser(Set<Long> roleIds, Long userId) throws DataAccessException {
        DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
        for (Long roleId : roleIds) {
            Row roleMapping = new Row("ELATechnicianRoleMapping");
            roleMapping.set("USER_ID", (Object)userId);
            roleMapping.set("ROLE_ID", (Object)roleId);
            dobj.addRow(roleMapping);
        }
        PersistenceDBUtil.getPersistence().add(dobj);
    }

    public static void createNewStaticRole(StaticResourceDetails roleProp) throws DataAccessException {
        DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
        Row roleDetails = new Row("ELATechnicianRoles");
        roleDetails.set("ROLE_NAME", (Object)roleProp.getRoleName());
        roleDetails.set("ROLE_DESCRIPTION", (Object)roleProp.getRoleDiscription());
        roleDetails.set("CREATION_TIME", (Object)System.currentTimeMillis());
        roleDetails.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
        roleDetails.set("IS_FULLACCESS", (Object)roleProp.isRoleFullAccess());
        dobj.addRow(roleDetails);
        Object roleID = dobj.getFirstValue("ELATechnicianRoles", "ROLE_ID");
        if (roleProp.getActionIds() != null) {
            for (Long actionID : roleProp.getActionIds()) {
                Row actionMapping = new Row("ELARolePermissions");
                actionMapping.set("ROLE_ID", roleID);
                actionMapping.set("ACTION_ID", (Object)actionID);
            }
        }
        PersistenceDBUtil.getPersistence().add(dobj);
    }

    static {
        try {
            superadmin_role = RoleInfoUtil.getSuperAdminRoleid();
        }
        catch (DataAccessException exp) {
            exp.printStackTrace();
        }
    }
}

