/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.delegation.info;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ELAStaticResourceInfo {
    private Set<Long> roleIds = null;
    private boolean isFullAccess = false;
    private Set<Long> actionDetails = null;

    private ELAStaticResourceInfo(DataObject dobj, boolean flag) throws DataAccessException {
        this.isFullAccess = flag;
        this.initRoleContainer(dobj);
    }

    static ELAStaticResourceInfo getRole(DataObject dobj) throws DataAccessException {
        if (dobj.containsTable("ELATechnicianRoles")) {
            Criteria fullAccessCriteria = new Criteria(Column.getColumn((String)"ELATechnicianRoles", (String)"IS_FULLACCESS"), (Object)Boolean.TRUE, 0);
            Row row = dobj.getRow("ELATechnicianRoles", fullAccessCriteria);
            if (row != null) {
                return new ELAStaticResourceInfo(dobj, true);
            }
            return new ELAStaticResourceInfo(dobj, false);
        }
        return null;
    }

    public boolean isFullAccess() {
        return this.isFullAccess;
    }

    private void initRoleContainer(DataObject dobj) throws DataAccessException {
        HashSet<Long> tempSet = new HashSet<Long>();
        Iterator itr = dobj.getRows("ELATechnicianRoles");
        while (itr.hasNext()) {
            tempSet.add((Long)((Row)itr.next()).get("ROLE_ID"));
        }
        this.setRoleIds((Set<Long>)ImmutableSet.copyOf(tempSet));
        tempSet = new HashSet();
        itr = dobj.getRows("ELAActionDetails");
        while (itr.hasNext()) {
            tempSet.add((Long)((Row)itr.next()).get("ACTION_ID"));
        }
        this.setActionDetails((Set<Long>)ImmutableSet.copyOf(tempSet));
    }

    Set<Long> getRoleIds() {
        return this.roleIds;
    }

    private void setRoleIds(Set<Long> roleIds) {
        this.roleIds = roleIds;
    }

    Set<Long> getActionDetails() {
        return this.actionDetails;
    }

    private void setActionDetails(Set<Long> actionDetails) {
        this.actionDetails = actionDetails;
    }
}

