/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.delegation.info;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.google.common.collect.ImmutableSet;
import com.manageengine.ela.server.common.delegation.info.BaseRoleValidatorImpl;
import com.manageengine.ela.server.common.delegation.info.DeviceRoleInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public class GroupRoleInfo
extends BaseRoleValidatorImpl<Long> {
    private DeviceRoleInfo deviceInfo = null;

    private GroupRoleInfo(DataObject dobj) throws DataAccessException {
        this.initGroupContainer(dobj);
        this.initChildContainers(dobj);
    }

    static GroupRoleInfo get(DataObject dobj) throws DataAccessException {
        if (dobj.containsTable("ELAViewGroupMapping")) {
            return new GroupRoleInfo(dobj);
        }
        return null;
    }

    private void initChildContainers(DataObject dobj) throws DataAccessException {
        this.deviceInfo = DeviceRoleInfo.getFromGroupList(dobj);
    }

    private void initGroupContainer(DataObject dobj) throws DataAccessException {
        HashSet<Long> tempSet = new HashSet<Long>();
        Iterator itr = dobj.getRows("ELAViewGroupMapping");
        while (itr.hasNext()) {
            tempSet.add((Long)((Row)itr.next()).get("GROUP_ID"));
        }
        this.setGroupID((Set<Long>)ImmutableSet.copyOf(tempSet));
    }

    public DeviceRoleInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public Set<Long> getGroupID() {
        return this.dataSet;
    }

    private void setGroupID(Set<Long> groupID) {
        this.dataSet = groupID;
    }

    @Override
    public boolean isValid(JSONArray data) throws JSONException {
        for (int index = 0; index < data.length(); ++index) {
            if (this.dataSet.contains(data.getLong(index))) continue;
            return false;
        }
        return true;
    }
}

