/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.delegation.info;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.delegation.info.ELADynamicResourceInfo;
import com.manageengine.ela.server.common.delegation.info.ELAStaticResourceInfo;
import com.manageengine.ela.server.common.delegation.info.RoleInfoUtil;
import java.util.HashMap;
import java.util.Map;

class RoleInfoCacheHandler {
    private static final Cache<Long, ELAStaticResourceInfo> STATIC_RESOURCE_CACHE = new Cache();
    private static final Cache<Long, Map<Long, ELADynamicResourceInfo>> DYNAMIC_RESOURCE_CACHE = new Cache();

    RoleInfoCacheHandler() {
    }

    static ELAStaticResourceInfo getStaticResource(Long userID) throws DataAccessException {
        ELAStaticResourceInfo userRoles = STATIC_RESOURCE_CACHE.get(userID);
        if (userRoles == null) {
            userRoles = RoleInfoCacheHandler.checkAndStaticResource(userID);
            STATIC_RESOURCE_CACHE.put(userID, userRoles);
        }
        return userRoles;
    }

    static ELADynamicResourceInfo getDynamicResource(Long userID, Long viewID) throws DataAccessException {
        ELADynamicResourceInfo roleInfo;
        Map<Long, ELADynamicResourceInfo> userRoles = DYNAMIC_RESOURCE_CACHE.get(userID);
        if (userRoles == null) {
            userRoles = new HashMap<Long, ELADynamicResourceInfo>();
            DYNAMIC_RESOURCE_CACHE.put(userID, userRoles);
        }
        if ((roleInfo = userRoles.get(viewID)) == null) {
            roleInfo = RoleInfoCacheHandler.checkAndGetDynamicResource(userID, viewID);
            userRoles.put(viewID, roleInfo);
        }
        return roleInfo;
    }

    private static ELADynamicResourceInfo checkAndGetDynamicResource(Long userID, Long viewID) throws DataAccessException {
        DataObject dobj = RoleInfoUtil.getTechnicianDynamicResource(userID, viewID);
        return ELADynamicResourceInfo.getRole(dobj);
    }

    private static ELAStaticResourceInfo checkAndStaticResource(Long userID) throws DataAccessException {
        DataObject dobj = RoleInfoUtil.getTechnicianStaticResource(userID);
        return ELAStaticResourceInfo.getRole(dobj);
    }

    static void removeStaticResource(Long userId) {
        STATIC_RESOURCE_CACHE.remove(userId);
    }

    public static void removeAllStaticResource() {
        STATIC_RESOURCE_CACHE.clear();
    }

    static void removeDynamicResource(Long userId, Long clientViewid) {
        Map<Long, ELADynamicResourceInfo> userRoles = DYNAMIC_RESOURCE_CACHE.get(userId);
        if (userRoles != null) {
            userRoles.remove(clientViewid);
        }
    }

    static void removeDynamicResource(Long userId) {
        DYNAMIC_RESOURCE_CACHE.remove(userId);
    }

    public static void removeAllDynamicResource() {
        DYNAMIC_RESOURCE_CACHE.clear();
    }
}

