/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.delegation.info;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.Iterator;

public class RoleInfoUtil {
    public static final Long DEFAULT_VIEW_ID = -1L;
    @Deprecated
    public static final String SYSTEM_GENERATED_VIEWNAME = "All Devices";
    @Deprecated
    public static final String FULL_ACCESS_IDENTITY = "1=1";

    public static Long getSuperAdminRoleid() throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATechnicianRoles", (String)"IS_FULLACCESS"), (Object)Boolean.TRUE, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"ELATechnicianRoles", (String)"IS_SYSTEMGENERATED"), (Object)Boolean.TRUE, 0));
        DataObject dobj = PersistenceDBUtil.getPersistence().get("ELATechnicianRoles", criteria);
        return (Long)dobj.getFirstValue("ELATechnicianRoles", "ROLE_ID");
    }

    public static DataObject getTechnicianDynamicResource(Long userID, Long viewID) throws DataAccessException {
        SelectQueryImpl query = RoleInfoUtil.geDynamicResourceQueryForTechnician();
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"USER_ID"), (Object)userID, 0);
        criteria = criteria.and(RoleInfoUtil.getViewIDCriteria(viewID));
        query.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    public static DataObject getTechnicianStaticResource(Long userID) throws DataAccessException {
        SelectQueryImpl query = RoleInfoUtil.getStaticResourceQueryForTechnician();
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATechnicianRoleMapping", (String)"USER_ID"), (Object)userID, 0);
        query.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    public static DataObject getSystemGeneratedViewInformation(Long userID) throws DataAccessException {
        SelectQueryImpl query = RoleInfoUtil.geDynamicResourceQueryForTechnician();
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"USER_ID"), (Object)userID, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"IS_SYSTEMGENERATED"), (Object)Boolean.TRUE, 0));
        query.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    public static DataObject getViewInformation(Long userID, String viewName) throws DataAccessException {
        SelectQueryImpl query = RoleInfoUtil.geDynamicResourceQueryForTechnician();
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"USER_ID"), (Object)userID, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"VIEW_NAME"), (Object)viewName, 0));
        query.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    private static SelectQueryImpl getStaticResourceQueryForTechnician() {
        SelectQueryImpl squeryImpl = new SelectQueryImpl(Table.getTable((String)"ELATechnicianRoles"));
        squeryImpl.addJoin(new Join("ELATechnicianRoles", "ELATechnicianRoleMapping", new String[]{"ROLE_ID"}, new String[]{"ROLE_ID"}, 2));
        squeryImpl.addJoin(new Join("ELATechnicianRoles", "ELARolePermissions", new String[]{"ROLE_ID"}, new String[]{"ROLE_ID"}, 1));
        squeryImpl.addJoin(new Join("ELARolePermissions", "ELAActionDetails", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 1));
        squeryImpl.addSelectColumn(Column.getColumn(null, (String)"*"));
        return squeryImpl;
    }

    private static SelectQueryImpl geDynamicResourceQueryForTechnician() {
        SelectQueryImpl squeryImpl = new SelectQueryImpl(Table.getTable((String)"ELATechnicianViewConfig"));
        squeryImpl.addJoin(new Join("ELATechnicianViewConfig", "ELAViewGroupMapping", new String[]{"VIEW_ID"}, new String[]{"VIEW_ID"}, 1));
        squeryImpl.addJoin(new Join("ELATechnicianViewConfig", "ELAViewDeviceMapping", new String[]{"VIEW_ID"}, new String[]{"VIEW_ID"}, 1));
        squeryImpl.addJoin(new Join("ELAViewGroupMapping", "HostGroup", new String[]{"GROUP_ID"}, new String[]{"ID"}, 1));
        squeryImpl.addJoin(new Join("HostGroup", "HostGroupMapping", new String[]{"ID"}, new String[]{"GROUPID"}, 1));
        squeryImpl.addSelectColumn(Column.getColumn(null, (String)"*"));
        return squeryImpl;
    }

    public static Long getNewModelViewID(Long userID, String viewName) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"USER_ID"), (Object)userID, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"VIEW_NAME"), (Object)viewName, 0));
        DataObject dobj = PersistenceDBUtil.getPersistence().get("ELATechnicianViewConfig", criteria);
        return (Long)dobj.getFirstValue("ELATechnicianViewConfig", "VIEW_ID");
    }

    public static DataObject getTechnicianCustomAccessGroupMapping() throws DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ELATechnicianViewConfig"));
        query.addJoin(new Join("ELATechnicianViewConfig", "ELAViewGroupMapping", new String[]{"VIEW_ID"}, new String[]{"VIEW_ID"}, 1));
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"IS_FULLACCESS"), (Object)Boolean.FALSE, 0);
        query.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    public static DataObject getTechnicianGroupMapping(Long userID, Long viewID) throws DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ELATechnicianViewConfig"));
        query.addJoin(new Join("ELATechnicianViewConfig", "ELAViewGroupMapping", new String[]{"VIEW_ID"}, new String[]{"VIEW_ID"}, 1));
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        Criteria criteria = null;
        if (userID != null) {
            criteria = new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"USER_ID"), (Object)userID, 0);
        }
        if (viewID != null) {
            criteria = criteria == null ? RoleInfoUtil.getViewIDCriteria(viewID) : criteria.and(RoleInfoUtil.getViewIDCriteria(viewID));
        }
        query.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    public static Iterator<?> getTechnicianSelectedViewGroupMapping(DataObject dobj, Long viewID) throws DataAccessException {
        Join join = new Join("ELATechnicianViewConfig", "ELAViewGroupMapping", new String[]{"VIEW_ID"}, new String[]{"VIEW_ID"}, 1);
        return dobj.getRows("ELAViewGroupMapping", RoleInfoUtil.getViewIDCriteria(viewID), join);
    }

    public static Row getTechnicianSelectedViewConfigRow(DataObject dobj, Long viewID) throws DataAccessException {
        return dobj.getRow("ELATechnicianViewConfig", RoleInfoUtil.getViewIDCriteria(viewID));
    }

    private static Criteria getViewIDCriteria(Long viewID) {
        if (viewID == DEFAULT_VIEW_ID) {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"IS_SYSTEMGENERATED"), (Object)Boolean.TRUE, 0);
            return criteria.and(new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"VIEW_NAME"), (Object)SYSTEM_GENERATED_VIEWNAME, 0));
        }
        return new Criteria(Column.getColumn((String)"ELATechnicianViewConfig", (String)"VIEW_ID"), (Object)viewID, 0);
    }
}

