/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.delegation.info;

import com.adventnet.persistence.DataAccessException;
import com.manageengine.ela.server.common.delegation.info.DeviceRoleInfo;
import com.manageengine.ela.server.common.delegation.info.ELADynamicResourceInfo;
import com.manageengine.ela.server.common.delegation.info.ELAStaticResourceInfo;
import com.manageengine.ela.server.common.delegation.info.GroupRoleInfo;
import com.manageengine.ela.server.common.delegation.info.RoleInfoCacheHandler;
import com.manageengine.ela.server.common.delegation.info.RoleInfoUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.HashSet;
import java.util.Set;

public class UserAccessResource {
    private long userID = -1L;
    private long viewID = -1L;
    private ELAStaticResourceInfo staticRoleINfo = null;
    private ELADynamicResourceInfo dynamicRoleINfo = null;

    private UserAccessResource(long userid, long viewid) throws DataAccessException, BaseStatusCode {
        this.userID = userid;
        this.viewID = viewid;
        this.staticRoleINfo = RoleInfoCacheHandler.getStaticResource(this.userID);
        this.dynamicRoleINfo = RoleInfoCacheHandler.getDynamicResource(this.userID, this.viewID);
        if (this.staticRoleINfo == null || this.dynamicRoleINfo == null) {
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
    }

    public static UserAccessResource getUserAccessResource(Long userId) throws DataAccessException, BaseStatusCode {
        return UserAccessResource.getUserAccessResource(userId, RoleInfoUtil.DEFAULT_VIEW_ID);
    }

    public static UserAccessResource getUserAccessResource(Long userId, Long clientViewid) throws DataAccessException, BaseStatusCode {
        if (clientViewid != null) {
            return new UserAccessResource(userId, clientViewid);
        }
        return new UserAccessResource(userId, RoleInfoUtil.DEFAULT_VIEW_ID);
    }

    public static void removeCache(Long userId, Long clientViewid) {
        RoleInfoCacheHandler.removeDynamicResource(userId, clientViewid);
    }

    public static void removeUserCache(Long userId) {
        RoleInfoCacheHandler.removeDynamicResource(userId);
    }

    public static void removeDefaultViewCache(Long userId) {
        RoleInfoCacheHandler.removeDynamicResource(userId, RoleInfoUtil.DEFAULT_VIEW_ID);
    }

    public static void removeAllCache() {
        RoleInfoCacheHandler.removeAllDynamicResource();
    }

    public static void removeUserStaticCache(Long userId) {
        RoleInfoCacheHandler.removeStaticResource(userId);
    }

    public static void removeAllStaticCache() {
        RoleInfoCacheHandler.removeAllStaticResource();
    }

    public long getUserID() {
        return this.userID;
    }

    public long getViewID() {
        return this.viewID;
    }

    public GroupRoleInfo getGroupRoleInfo() {
        return this.dynamicRoleINfo.getGroupInfo();
    }

    public DeviceRoleInfo getDeviceRoleInfo() {
        return this.dynamicRoleINfo.getDeviceRoleInfo();
    }

    public boolean checkItHasAllActionAccess() {
        return this.staticRoleINfo.isFullAccess();
    }

    public boolean checkItHasFullDataAccess() {
        return this.dynamicRoleINfo.isFullAccess();
    }

    public Set<Long> getAllAllowedDevices() {
        HashSet<Long> requested = new HashSet<Long>();
        DeviceRoleInfo info = this.getGroupRoleInfo().getDeviceInfo();
        if (info != null) {
            requested.addAll(info.getDeviceID());
        }
        if ((info = this.getDeviceRoleInfo()) != null) {
            requested.addAll(info.getDeviceID());
        }
        return requested;
    }

    public Set<Long> getAllAllowedGroups() {
        return this.getGroupRoleInfo().getGroupID();
    }
}

