/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device;

import com.manageengine.ela.server.common.device.LogSourceCategory;
import com.manageengine.ela.server.common.device.group.util.DeviceGroupUtil;

public class LogSourceCategoryContainer {

    public static enum ApplicationCategory implements LogSourceCategory
    {
        WINDOWSMSSQL,
        WINDOWSPRINTSERVER,
        WINDOWSTERMINALSERVER,
        WINDOWSORACLE,
        WINDOWSPMP,
        WINDOWSOPM,
        LINUXORACLE,
        LINUXPMP,
        LINUXOPM,
        UNKNOWN;


        @Override
        public long getDefaultGrouID() {
            switch (this) {
                case WINDOWSMSSQL: 
                case WINDOWSPRINTSERVER: 
                case WINDOWSTERMINALSERVER: 
                case WINDOWSORACLE: 
                case WINDOWSPMP: 
                case WINDOWSOPM: {
                    return DeviceCategory.WINDOWS.getDefaultGrouID();
                }
                case LINUXORACLE: 
                case LINUXPMP: 
                case LINUXOPM: {
                    return DeviceCategory.UNIX.getDefaultGrouID();
                }
            }
            return DeviceGroupUtil.getDefaultGroupID();
        }

        @Override
        public String getImage() {
            switch (this) {
                case WINDOWSMSSQL: 
                case WINDOWSPRINTSERVER: 
                case WINDOWSTERMINALSERVER: 
                case WINDOWSORACLE: 
                case WINDOWSPMP: 
                case WINDOWSOPM: {
                    return "images/logo_winapp.gif";
                }
                case LINUXORACLE: 
                case LINUXPMP: 
                case LINUXOPM: {
                    return "images/logo_linuxapp.gif";
                }
            }
            return "images/logo_unknown.gif";
        }

        @Override
        public String getCategoryName() {
            switch (this) {
                case WINDOWSMSSQL: {
                    return "WindowsMSSQLApplication";
                }
                case WINDOWSPRINTSERVER: {
                    return "WindowsPSApplication";
                }
                case WINDOWSTERMINALSERVER: {
                    return "WindowsTERMINALApplication";
                }
                case WINDOWSORACLE: {
                    return "WindowsORACLEApplication";
                }
                case LINUXORACLE: {
                    return "LinuxORACLEApplication";
                }
            }
            return "Unknown";
        }

        public static ApplicationCategory getCategory(String osName) {
            switch (osName) {
                case "WindowsMSSQLApplication": {
                    return WINDOWSMSSQL;
                }
                case "WindowsPSApplication": {
                    return WINDOWSPRINTSERVER;
                }
                case "WindowsTERMINALApplication": {
                    return WINDOWSTERMINALSERVER;
                }
                case "WindowsORACLEApplication": {
                    return WINDOWSORACLE;
                }
                case "LinuxApplication": {
                    return LINUXORACLE;
                }
                case "Unknown": {
                    return UNKNOWN;
                }
            }
            return LINUXORACLE;
        }

        public String getFormatName() {
            switch (this) {
                case WINDOWSMSSQL: {
                    return "mssqlauditLogs";
                }
                case WINDOWSORACLE: 
                case LINUXORACLE: {
                    return "oracleLogs";
                }
                case WINDOWSPRINTSERVER: {
                    return "printerLogs";
                }
                case WINDOWSTERMINALSERVER: {
                    return "TerminalLogs";
                }
                case WINDOWSPMP: {
                    return "PMP";
                }
                case WINDOWSOPM: {
                    return "OPM";
                }
            }
            return null;
        }

        public String getFormatGroup() {
            switch (this) {
                case WINDOWSMSSQL: {
                    return "MSSQL";
                }
                case WINDOWSORACLE: 
                case LINUXORACLE: {
                    return "Oracle";
                }
                case WINDOWSPRINTSERVER: {
                    return "PrintServer";
                }
                case WINDOWSTERMINALSERVER: {
                    return "Terminal";
                }
                case WINDOWSPMP: {
                    return "PMP";
                }
                case WINDOWSOPM: {
                    return "OPM";
                }
            }
            return null;
        }
    }

    public static enum DeviceCategory implements LogSourceCategory
    {
        WINDOWS,
        UNIX,
        CISCO,
        SONICWALL,
        JUNIPER,
        PALOALTO,
        FORTINET,
        CHECKPOINT,
        NETSCREEN,
        WATCHGUARD,
        SOPHOS,
        BARRACUDA,
        HUAWEI,
        MERAKI,
        AS400,
        SYSLOG,
        ESXI,
        UNKNOWN,
        UNKNOWNCATEGORY;


        @Override
        public String getImage() {
            switch (this) {
                case WINDOWS: {
                    return "icons/windows.gif";
                }
                case UNIX: {
                    return "icons/linux.gif";
                }
                case CISCO: {
                    return "icons/cisco.gif";
                }
                case SONICWALL: {
                    return "icons/sonicwall.gif";
                }
                case JUNIPER: {
                    return "icons/juniper.gif";
                }
                case PALOALTO: {
                    return "icons/paloalto.gif";
                }
                case FORTINET: {
                    return "icons/fortinet.gif";
                }
                case CHECKPOINT: {
                    return "icons/checkpoint.gif";
                }
                case NETSCREEN: {
                    return "icons/juniper.gif";
                }
                case WATCHGUARD: {
                    return "icons/watchguard.gif";
                }
                case SOPHOS: {
                    return "icons/sophos.gif";
                }
                case BARRACUDA: {
                    return "icons/barracuda.gif";
                }
                case HUAWEI: {
                    return "icons/huawei.gif";
                }
                case MERAKI: {
                    return "icons/meraki.png";
                }
                case AS400: {
                    return "icons/as400.gif";
                }
                case ESXI: {
                    return "icons/esxi.gif";
                }
                case UNKNOWN: 
                case UNKNOWNCATEGORY: {
                    return "icons/unknown.gif";
                }
            }
            return "icons/linux.gif";
        }

        @Override
        public long getDefaultGrouID() {
            switch (this) {
                case WINDOWS: {
                    return DeviceGroupUtil.getWindowsGroupID();
                }
                case UNIX: 
                case CISCO: 
                case SONICWALL: 
                case JUNIPER: 
                case PALOALTO: 
                case FORTINET: 
                case CHECKPOINT: 
                case NETSCREEN: 
                case WATCHGUARD: 
                case SOPHOS: 
                case BARRACUDA: 
                case HUAWEI: 
                case MERAKI: 
                case AS400: 
                case ESXI: {
                    return DeviceGroupUtil.getUnixGroupID();
                }
            }
            return DeviceGroupUtil.getDefaultGroupID();
        }

        @Override
        public String getCategoryName() {
            switch (this) {
                case WINDOWS: {
                    return "Windows";
                }
                case UNIX: {
                    return "Unix";
                }
                case CISCO: {
                    return "Cisco Device";
                }
                case SONICWALL: {
                    return "SonicWall Device";
                }
                case JUNIPER: {
                    return "Juniper Device";
                }
                case PALOALTO: {
                    return "PaloAlto Device";
                }
                case FORTINET: {
                    return "Fortinet Device";
                }
                case CHECKPOINT: {
                    return "CheckPoint Device";
                }
                case NETSCREEN: {
                    return "NetScreen Device";
                }
                case WATCHGUARD: {
                    return "WatchGuard Device";
                }
                case SOPHOS: {
                    return "Sophos Device";
                }
                case BARRACUDA: {
                    return "Barracuda Device";
                }
                case HUAWEI: {
                    return "Huawei Device";
                }
                case MERAKI: {
                    return "Meraki Device";
                }
                case AS400: {
                    return "IBM AS/400";
                }
                case ESXI: {
                    return "Hypervisor";
                }
                case UNKNOWN: {
                    return "Application";
                }
                case UNKNOWNCATEGORY: {
                    return "Unknown";
                }
            }
            return "Syslog Device";
        }

        public static DeviceCategory getCategory(String osName) {
            switch (osName) {
                case "Windows": {
                    return WINDOWS;
                }
                case "Unix": {
                    return UNIX;
                }
                case "Cisco Device": {
                    return CISCO;
                }
                case "SonicWall Device": {
                    return SONICWALL;
                }
                case "Juniper Device": {
                    return JUNIPER;
                }
                case "PaloAlto Device": {
                    return PALOALTO;
                }
                case "Fortinet Device": {
                    return FORTINET;
                }
                case "CheckPoint Device": {
                    return CHECKPOINT;
                }
                case "NetScreen Device": {
                    return NETSCREEN;
                }
                case "WatchGuard Device": {
                    return WATCHGUARD;
                }
                case "Sophos Device": {
                    return SOPHOS;
                }
                case "Barracuda Device": {
                    return BARRACUDA;
                }
                case "Huawei Device": {
                    return HUAWEI;
                }
                case "Meraki Device": {
                    return MERAKI;
                }
                case "IBM AS/400": {
                    return AS400;
                }
                case "Hypervisor": {
                    return ESXI;
                }
                case "Application": {
                    return UNKNOWN;
                }
                case "Unknown": {
                    return UNKNOWNCATEGORY;
                }
            }
            return SYSLOG;
        }
    }
}

