/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.autoconfig;

import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.callback.CallBackArguments;
import com.manageengine.ela.server.common.callback.CommonCallBack;
import com.manageengine.ela.server.common.device.management.AddWindowsDeviceListner;
import com.manageengine.ela.server.common.discovery.DiscoveryHandler;
import com.manageengine.ela.server.common.handlers.workgroup.WorkgroupHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class DiscoverySequenceExecutor
implements CommonCallBack {
    private int maxInitialServerCount = 5;
    private int currentDevices = 0;
    private static final Logger LOGGER = Logger.getLogger(DiscoverySequenceExecutor.class.getName());

    @Override
    public void callBack(CallBackArguments args) {
        int discoveryType = 1;
        this.currentDevices = this.getExistingDeviceCount();
        if (args != null && args.get("windowsdiscoverytype") != null) {
            try {
                discoveryType = Integer.valueOf(args.get("windowsdiscoverytype").toString());
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            LOGGER.info("discoveryType collected from callbackArguments  : " + discoveryType);
        }
        if (discoveryType == 1) {
            LOGGER.info("Callback recived from domain discovery, type  : " + discoveryType);
            if (args != null) {
                String domaiName = (String)args.get("domain_name");
                LOGGER.info("DomainDeviceConfigurations started with domain reference  : " + domaiName);
                this.handleDomainDeviceConfigurationS(domaiName);
            } else {
                LOGGER.info("DomainDeviceConfigurations started with null reference  : " + discoveryType);
                this.handleDomainDeviceConfigurationS(null);
            }
            LOGGER.info("DomainDeviceConfigurations completed successfully  : " + discoveryType);
        } else if (discoveryType == 2) {
            LOGGER.info("Callback recived from workgroup discovery, type  : " + discoveryType);
        } else {
            LOGGER.info("Invalid discoveryType called  : " + discoveryType);
        }
    }

    private void handleWorkGroupDeviceConfigurationS() throws BaseStatusCode {
        JSONArray workGroups = WorkgroupHandler.getAllWorkGroup();
        if (workGroups != null && workGroups.length() > 0) {
            for (int index = 0; index < workGroups.length(); ++index) {
                try {
                    JSONObject workgroupDetails = workGroups.getJSONObject(index);
                    DiscoveryHandler.startWindowsObjectDiscovery(workgroupDetails, false, true, 8, 2);
                    continue;
                }
                catch (Exception exp) {
                    LOGGER.info("Exception while adding discovered domain, all workgroups :" + workGroups + "   index : " + index + ",  exception details :" + exp.getMessage());
                }
            }
        } else {
            LOGGER.info("No valid workgroups are discovered");
        }
    }

    private void handleDomainDeviceConfigurationS(String domaiName) {
        AtomicInteger count = new AtomicInteger();
        if (this.maxInitialServerCount > this.currentDevices) {
            count.set(this.maxInitialServerCount - this.currentDevices);
        }
        JSONArray alldomains = null;
        alldomains = domaiName == null ? ADSDomainHandler.getDomainDetails() : new JSONArray().put((Object)ADSDomainHandler.getDomainDetails((String)domaiName));
        if (alldomains != null && alldomains.length() > 0) {
            JSONObject domainDetails;
            int index;
            for (index = 0; index < alldomains.length() && count.get() > 0; ++index) {
                try {
                    domainDetails = alldomains.getJSONObject(index);
                    AddWindowsDeviceListner.addDiscoveredDomainControllers(domainDetails, count);
                    continue;
                }
                catch (Exception exp) {
                    LOGGER.info("Exception while adding discovered domain, all domains :" + alldomains + "   index : " + index + ",  exception details :" + exp.getMessage());
                }
            }
            for (index = 0; index < alldomains.length(); ++index) {
                try {
                    domainDetails = alldomains.getJSONObject(index);
                    if (count.get() > 0) {
                        DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, false, true, 1, 1);
                        AddWindowsDeviceListner.checkAndaddDiscoveredServers(domainDetails, count);
                        DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, false, false, 2, 1);
                    } else {
                        DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, false, true, 3, 1);
                    }
                    DiscoveryHandler.startWindowsObjectDiscovery(domainDetails, false, true, 7, 1);
                    continue;
                }
                catch (Exception exp) {
                    LOGGER.info("Exception while adding discovered domain, all domains :" + alldomains + "  index : " + index + ",  exception details :" + exp.getMessage());
                }
            }
        } else {
            LOGGER.info("Domains are not discovered");
        }
    }

    private int getExistingDeviceCount() {
        int count = 0;
        try {
            count = DBUtil.getCountInt("Hosts", null);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return count;
    }
}

