/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.autoconfig;

import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.callback.CallBackArguments;
import com.manageengine.ela.server.common.device.autoconfig.DiscoverySequenceExecutor;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import com.manageengine.ela.server.common.discovery.DiscoveryHandler;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import java.util.logging.Logger;

public class InitialDeviceConfiguration {
    private static final Logger LOGGER = Logger.getLogger(InitialDeviceConfiguration.class.getName());

    public static boolean startConfiguration() {
        if (CommonUtil.getSysConfiguration("DOAMIN_DISCOVERY_STARTUP") != null) {
            LOGGER.fine("Domain discovery skiped, since alreay discovery completed");
            return false;
        }
        CommonUtil.updateSysConfiguration("DOAMIN_DISCOVERY_STARTUP", Boolean.TRUE, true);
        long time = System.currentTimeMillis();
        LOGGER.info("InitialDeviceConfiguration started At : " + time);
        if (!ServerDetailsBean.getInstance().isWindows()) {
            LOGGER.info("Configuration implemented only for windows machines");
            return false;
        }
        if (Boolean.valueOf((String)CommonUtil.getSysConfiguration("CHECK_AND_ADD_LOCAL_WINDOWS_DEVICE")).booleanValue() && !ServerDetailsBean.getInstance().isUpgraded().booleanValue()) {
            CommonUtil.updateSysConfiguration("CHECK_AND_ADD_LOCAL_WINDOWS_DEVICE", Boolean.FALSE, true);
            AddOrUpdateEventlogDevice.checkAndADDLocalHost();
        }
        try {
            InitialDeviceConfiguration.startDomainDiscoveryForInitialConfig(true);
        }
        catch (Exception exp) {
            LOGGER.info("Problem occurred in doamin discovery, details " + exp.getMessage());
        }
        if (!ServerDetailsBean.getInstance().isAdminServer()) {
            try {
                InitialDeviceConfiguration.startWorkGroupDiscoveryForInitialConfig(true);
            }
            catch (Exception exp) {
                LOGGER.info("Problem occurred in workgroup discovery, details " + exp.getMessage());
            }
        }
        LOGGER.info("Time Taken for InitialDeviceConfiguration : " + (System.currentTimeMillis() - time));
        return true;
    }

    public static void startDomainDiscoveryForInitialConfig(boolean isThreaded) throws Exception {
        DiscoveryParameters parameters = new DiscoveryParameters();
        CallBackArguments arguments = new CallBackArguments();
        arguments.put("windowsdiscoverytype", 1);
        parameters.setCallBackArgs(arguments);
        if (!ServerDetailsBean.getInstance().isAdminServer()) {
            parameters.setCallBackInstance(new DiscoverySequenceExecutor());
        }
        DiscoveryHandler.startDomainDiscovery(parameters, isThreaded);
    }

    public static void startWorkGroupDiscoveryForInitialConfig(boolean isThreaded) throws Exception {
        DiscoveryParameters parameters = new DiscoveryParameters();
        CallBackArguments arguments = new CallBackArguments();
        arguments.put("windowsdiscoverytype", 2);
        parameters.setCallBackArgs(arguments);
        parameters.setCallBackInstance(new DiscoverySequenceExecutor());
        DiscoveryHandler.startWorkGroupDiscovery(parameters, isThreaded);
    }
}

