/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.group;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DeleteQuery;
import com.adventnet.ds.query.DeleteQueryImpl;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.CustomAlertProfile;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.delegation.info.RoleInfoUtil;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.device.group.DeviceGroupProperties;
import com.manageengine.ela.server.common.device.group.ExtendedGroupAction;
import com.manageengine.ela.server.common.device.group.util.DeviceGroupUtil;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilterhandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AddOrUpdateDeviceGroup {
    public static boolean checkAvailability(String groupName) {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostGroup", (String)"NAME"), (Object)groupName, 0, false);
        return DBUtil.getCountInt("HostGroup", criteria) > 0;
    }

    public static boolean checkAvailability(String groupName, JSONArray skipList) throws JSONException {
        Long[] list = AddOrUpdateDeviceGroup.jsonArrayToLongarray(skipList);
        Criteria criteria = new Criteria(Column.getColumn((String)"HostGroup", (String)"NAME"), (Object)groupName, 0, false);
        return DBUtil.getCountInt("HostGroup", criteria = criteria.and(new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)list, 9))) > 0;
    }

    public static boolean addNewGroup(UserAccessResource userResource, JSONObject reqJsonObject) throws Exception {
        DeviceGroupProperties deviceGroup = DeviceGroupProperties.getDeviceDetails(reqJsonObject);
        if (!AddOrUpdateDeviceGroup.checkAvailability(deviceGroup.getGroupName())) {
            return AddOrUpdateDeviceGroup.addNewGroup(userResource, deviceGroup, new boolean[0]);
        }
        throw BaseStatusCode.getBaseStatusCode(7432);
    }

    public static boolean addNewGroup(UserAccessResource userResource, DeviceGroupProperties deviceGroup, boolean ... flag) throws Exception {
        DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
        Row groupRow = new Row("HostGroup");
        groupRow.set("NAME", (Object)deviceGroup.getGroupName());
        groupRow.set("DESCRIPTION", (Object)deviceGroup.getGroupDescription());
        dobj.addRow(groupRow);
        dobj = PersistenceDBUtil.getPersistence().update(dobj);
        deviceGroup.setGroupID((Long)dobj.getFirstValue("HostGroup", "ID"));
        JSONArray deviceID = deviceGroup.getSelectedDeviceIds();
        if (deviceID == null) {
            return true;
        }
        Long[] deviceList = AddOrUpdateDeviceGroup.jsonArrayToLongarray(deviceID);
        DataObject existingMapping = DeviceGroupUtil.getGroupMappingDO(deviceGroup.getGroupID(), deviceList);
        return AddOrUpdateDeviceGroup.handleAddPostActions(existingMapping, deviceGroup, "Add", AddOrUpdateDeviceGroup.moveFromOtherGroups(existingMapping, deviceGroup), userResource);
    }

    public static boolean updateGroup(long groupID, JSONObject reqJsonObject) throws Exception {
        DeviceGroupProperties deviceGroup = DeviceGroupProperties.getDeviceDetails(groupID, reqJsonObject);
        boolean status = false;
        if (!DeviceGroupUtil.checkIsAllowedUpdateAction(groupID)) {
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
        status = !DeviceGroupUtil.checkIsAllowedNameChangeAction(groupID) ? AddOrUpdateDeviceGroup.updateGroupDetails(deviceGroup, false) : AddOrUpdateDeviceGroup.updateGroupDetails(deviceGroup, true);
        JSONArray deviceID = deviceGroup.getSelectedDeviceIds();
        if (deviceID == null) {
            return true;
        }
        Long[] deviceList = AddOrUpdateDeviceGroup.jsonArrayToLongarray(deviceID);
        DataObject existingMapping = DeviceGroupUtil.getGroupMappingDO(deviceGroup.getGroupID(), deviceList);
        status &= AddOrUpdateDeviceGroup.moveFromOtherGroups(existingMapping, deviceGroup);
        return AddOrUpdateDeviceGroup.handleUpdatePostActions(existingMapping, deviceGroup, "Edit", status &= AddOrUpdateDeviceGroup.removeFromExistingGroups(existingMapping, deviceList, null, deviceGroup.getGroupID()), new Long[0]);
    }

    public static boolean deleteGroup(UserAccessResource userResource, JSONObject reqJsonObject, ResponseBuilder responseBuilder, Locale locale) throws Exception {
        DeviceGroupProperties deviceGroup = DeviceGroupProperties.getDeviceDetails(reqJsonObject);
        DataObject existingMapping = null;
        boolean status = false;
        Long[] processedIDs = null;
        DataObject existingResource = RoleInfoUtil.getTechnicianCustomAccessGroupMapping();
        if (deviceGroup.getGroupIDs() != null) {
            Long[] deviceIDs;
            Long[] requestedGrp = deviceGroup.getGroupIDs();
            if (!DeviceGroupUtil.checkIsAllowedDeleteAction(userResource, requestedGrp)) {
                throw BaseStatusCode.getBaseStatusCode(7426);
            }
            Long[] allowedList = TechnicianUtil.checkOtherTechnicianAndgetValidgroups(existingResource, requestedGrp);
            if (allowedList.length == 0) {
                throw BaseStatusCode.getBaseStatusCode(7947);
            }
            if (allowedList.length < requestedGrp.length) {
                JSONObject json = new JSONObject();
                json.put("GROUPSELIMINATED", requestedGrp.length - allowedList.length);
                BaseStatusCode code = BaseStatusCode.getBaseStatusCode(7947).resolveDisplayText(locale);
                json.put("DISPLAYTEXT", (Object)code.getDisplayText());
                json.put("STATUS_CODE", (Object)code.getStatusCode());
                responseBuilder.setStatus(json);
            }
            if (status = AddOrUpdateDeviceGroup.removeFromExistingGroups(existingMapping = DeviceGroupUtil.getGroupMappingDO(requestedGrp), null, deviceIDs = DeviceGroupUtil.collectDeviceIDList(existingMapping), requestedGrp)) {
                Criteria group = new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)allowedList, 8);
                try {
                    DeleteQueryImpl deleteQuery = new DeleteQueryImpl("HostGroup");
                    deleteQuery.setCriteria(group);
                    PersistenceDBUtil.getPersistence().delete((DeleteQuery)deleteQuery);
                    status = true;
                }
                catch (Exception exp) {
                    status = false;
                    exp.printStackTrace();
                }
            }
            processedIDs = allowedList;
        } else if (deviceGroup.getGroupID() != null) {
            if (!DeviceGroupUtil.checkIsAllowedDeleteAction(userResource, deviceGroup.getGroupID())) {
                throw BaseStatusCode.getBaseStatusCode(7426);
            }
            Long[] allowedList = TechnicianUtil.checkOtherTechnicianAndgetValidgroups(existingResource, deviceGroup.getGroupID());
            if (allowedList.length == 0) {
                throw BaseStatusCode.getBaseStatusCode(7947);
            }
            existingMapping = DeviceGroupUtil.getGroupMappingDO(deviceGroup.getGroupID());
            Long[] deviceIDs = DeviceGroupUtil.collectDeviceIDList(existingMapping);
            status = AddOrUpdateDeviceGroup.removeFromExistingGroups(existingMapping, null, deviceIDs, deviceGroup.getGroupID());
            if (status) {
                Criteria group = new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)deviceGroup.getGroupID(), 0);
                try {
                    DeleteQueryImpl deleteQuery = new DeleteQueryImpl("HostGroup");
                    deleteQuery.setCriteria(group);
                    PersistenceDBUtil.getPersistence().delete((DeleteQuery)deleteQuery);
                    status = true;
                }
                catch (Exception exp) {
                    status = false;
                    exp.printStackTrace();
                }
            }
        } else {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return AddOrUpdateDeviceGroup.handleDeletePostActions(existingMapping, existingResource, deviceGroup, "Delete", status, userResource, processedIDs);
    }

    private static boolean handleAddPostActions(DataObject existingMapping, DeviceGroupProperties deviceGroup, String mode, boolean updateStatus, UserAccessResource userResource) {
        try {
            TechnicianUtil.handleNewGroupUpdateFromGrpMgmnt(userResource, deviceGroup.getGroupID());
            AddOrUpdateDeviceGroup.handleUpdatePostActions(existingMapping, deviceGroup, mode, updateStatus, new Long[0]);
            ExtendedGroupAction.handleCorrelationReports(deviceGroup, mode, new Long[0]);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return true;
    }

    private static boolean handleDeletePostActions(DataObject existingMapping, DataObject exRe, DeviceGroupProperties deviceGroup, String mode, boolean status, UserAccessResource userResource, Long ... customgroupID) {
        try {
            if (customgroupID != null) {
                TechnicianUtil.handleDeleteGroupFromGroupMgmnt(exRe, customgroupID);
            } else {
                TechnicianUtil.handleDeleteGroupFromGroupMgmnt(exRe, deviceGroup.getGroupID());
            }
            AddOrUpdateDeviceGroup.handleUpdatePostActions(existingMapping, deviceGroup, mode, status, customgroupID);
            ExtendedGroupAction.handleCorrelationReports(deviceGroup, mode, customgroupID);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return true;
    }

    private static boolean handleUpdatePostActions(DataObject existingMapping, DeviceGroupProperties deviceGroup, String mode, boolean updateStatus, Long ... customgroupID) {
        try {
            ExtendedGroupAction.handleDeviceIDDelegationHistory(deviceGroup);
            Long[] groupIDs = DeviceGroupUtil.collectGroupIDList(existingMapping);
            ExtendedGroupAction.reportGroupChangesToCorrelationThread(deviceGroup, groupIDs, mode, customgroupID);
            CustomAlertProfile.populateHostToGroupMap();
            LogForwarderFilterhandler.updateDevicetoGroupMapping();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return true;
    }

    private static boolean updateGroupDetails(DeviceGroupProperties deviceGroup, boolean nameChangeAllowed) throws DataAccessException {
        UpdateQueryImpl updateQuery = new UpdateQueryImpl("HostGroup");
        Long groupID = deviceGroup.getGroupID();
        Criteria criteria = new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)groupID, 0);
        updateQuery.setCriteria(criteria);
        if (nameChangeAllowed) {
            updateQuery.setUpdateColumn("NAME", (Object)deviceGroup.getGroupName());
        }
        updateQuery.setUpdateColumn("DESCRIPTION", (Object)deviceGroup.getGroupDescription());
        try {
            PersistenceDBUtil.getPersistence().update((UpdateQuery)updateQuery);
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    private static boolean moveFromOtherGroups(DataObject existingMapping, DeviceGroupProperties deviceGroup) throws Exception {
        Criteria findNewDevice = new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"GROUPID"), (Object)deviceGroup.getGroupID(), 1);
        Iterator newDevice = existingMapping.getRows("HostGroupMapping", findNewDevice);
        ArrayList<Long> deviceAddedList = new ArrayList<Long>();
        while (newDevice.hasNext()) {
            Row existingMappingRow = (Row)newDevice.next();
            deviceAddedList.add((Long)existingMappingRow.get("HOSTID"));
        }
        if (!deviceAddedList.isEmpty()) {
            Long[] idList = deviceAddedList.toArray(new Long[deviceAddedList.size()]);
            Criteria addedList = new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"HOSTID"), (Object)idList, 8);
            DataBaseReqestProcessor.executeUpdateQuery("HostGroupMapping", "GROUPID", deviceGroup.getGroupID(), addedList, new boolean[0]);
            ExtendedGroupAction.updateLogCollectionAlerts(deviceGroup.getGroupID(), idList);
        }
        return true;
    }

    private static boolean removeFromExistingGroups(DataObject existingMapping, Long[] removeIFNotin, Long[] removeIFin, Long ... groupID) throws Exception {
        Criteria findDeletedDevice = new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"GROUPID"), (Object)groupID, 8);
        if (removeIFNotin != null) {
            findDeletedDevice = findDeletedDevice.and(new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"HOSTID"), (Object)removeIFNotin, 9));
        }
        if (removeIFin != null) {
            findDeletedDevice = findDeletedDevice.and(new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"HOSTID"), (Object)removeIFin, 8));
        }
        Iterator iterator = existingMapping.getRows("HostGroupMapping", findDeletedDevice);
        ArrayList<Long> deviceIDList = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Row existingMappingRow = (Row)iterator.next();
            deviceIDList.add((Long)existingMappingRow.get("HOSTID"));
        }
        if (!deviceIDList.isEmpty()) {
            Long[] idList = deviceIDList.toArray(new Long[deviceIDList.size()]);
            Criteria addedList = new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"HOSTID"), (Object)idList, 8);
            DataBaseReqestProcessor.executeUpdateQuery("HostGroupMapping", "GROUPID", DeviceGroupUtil.getDefaultGroupID(), addedList, new boolean[0]);
            ExtendedGroupAction.updateLogCollectionAlerts(DeviceGroupUtil.getDefaultGroupID(), idList);
        }
        return true;
    }

    private static Long[] jsonArrayToLongarray(JSONArray array) throws JSONException {
        Long[] result = new Long[array.length()];
        for (int index = 0; index < array.length(); ++index) {
            result[index] = array.getLong(index);
        }
        return result;
    }
}

