/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.group.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceGroupUtil {
    private static long windowsGroupID = 2L;
    private static long defaultGroupID = 1L;
    private static long unixGroupID = 3L;
    private static final Logger LOGGER = Logger.getLogger(DeviceGroupUtil.class.getName());

    public static Object getDeviceCount(Object groupID) {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"GROUPID"), groupID, 0);
        return DBUtil.getCountLong("HostGroupMapping", criteria);
    }

    public static Long getDeviceGroupId(String groupName) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"HostGroup", (String)"NAME"), (Object)groupName, 0, false);
            DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get("HostGroup", criteria);
            if (!dataObject.isEmpty()) {
                return (Long)dataObject.getFirstRow("HostGroup").get("ID");
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return 1L;
    }

    public static DataObject getGroupDO(Long groupID) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)groupID, 0);
        return PersistenceDBUtil.getPersistenceLite().get("HostGroup", criteria);
    }

    public static DataObject getGroupMappingDO(Long groupID) throws DataAccessException, JSONException {
        return DeviceGroupUtil.getGroupMappingDO(new Long[]{groupID}, null);
    }

    public static DataObject getGroupMappingDO(Long[] groupID) throws DataAccessException, JSONException {
        return DeviceGroupUtil.getGroupMappingDO(groupID, null);
    }

    public static DataObject getGroupMappingDO(Long groupID, Long[] deviceID) throws DataAccessException, JSONException {
        return DeviceGroupUtil.getGroupMappingDO(new Long[]{groupID}, deviceID);
    }

    public static DataObject getGroupMappingDO(Long[] groupID, Long[] deviceID) throws DataAccessException, JSONException {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)groupID, 8);
        if (deviceID != null && deviceID.length > 0) {
            criteria = criteria.or(new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"HOSTID"), (Object)deviceID, 8));
        }
        return DeviceGroupUtil.getGroupDetailedDO(criteria);
    }

    public static Long[] collectDeviceIDList(JSONArray groupID) throws DataAccessException, JSONException {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"GROUPID"), groupID.get(0), 0);
        for (int index = 1; index < groupID.length(); ++index) {
            criteria = criteria.or(new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"GROUPID"), groupID.get(index), 0));
        }
        return DeviceGroupUtil.collectDeviceIDList(criteria);
    }

    public static Long[] collectDeviceIDList(Long groupID) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"GROUPID"), (Object)groupID, 0);
        return DeviceGroupUtil.collectDeviceIDList(criteria);
    }

    public static Long[] collectDeviceIDList(Criteria criteria) throws DataAccessException {
        DataObject dobj = PersistenceDBUtil.getPersistence().get("HostGroupMapping", criteria);
        return DeviceGroupUtil.collectDeviceIDList(dobj);
    }

    public static Long[] collectDeviceIDList(DataObject dobj) throws DataAccessException {
        if (dobj.size("HostGroupMapping") <= 0) {
            return new Long[0];
        }
        Long[] deviceID = new Long[dobj.size("HostGroupMapping")];
        Iterator deviceIDs = dobj.getRows("HostGroupMapping");
        int index = 0;
        while (deviceIDs.hasNext()) {
            Row row = (Row)deviceIDs.next();
            deviceID[index] = (Long)row.get("HOSTID");
            ++index;
        }
        return deviceID;
    }

    public static Long[] collectGroupIDList(DataObject dobj) throws DataAccessException {
        Long[] groupID = null;
        if (dobj.size("HostGroup") > 0) {
            groupID = new Long[dobj.size("HostGroup")];
            Iterator deviceIDs = dobj.getRows("HostGroup");
            int index = 0;
            while (deviceIDs.hasNext()) {
                Row row = (Row)deviceIDs.next();
                groupID[index] = (Long)row.get("ID");
                ++index;
            }
        } else {
            groupID = new Long[]{};
        }
        return groupID;
    }

    public static JSONObject collectGroupDetails(long groupID) {
        JSONObject groupDetails = new JSONObject();
        try {
            Long[] devices;
            DataObject dataObject = DeviceGroupUtil.getDeviceGroupDetailsDO(groupID);
            Row row = dataObject.getFirstRow("HostGroup");
            groupDetails.put("NAME", row.get("NAME"));
            groupDetails.put("DESCRIPTION", row.get("DESCRIPTION"));
            groupDetails.put("SAMPLE_DEVICE_NAME", DeviceGroupUtil.getDeviceNameList(dataObject, 10));
            JSONArray array = new JSONArray();
            for (Long deviceID : devices = DeviceGroupUtil.collectDeviceIDList(dataObject)) {
                array.put((Object)((Object)deviceID).toString());
            }
            groupDetails.put("TOTAL_DEVICE_LIST", (Object)array);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return groupDetails;
    }

    public static JSONArray getGroupList(Set<Long> groupList) throws DataAccessException {
        Iterator itr;
        JSONArray groups = new JSONArray();
        Long[] selected = null;
        if (groupList.size() > 10) {
            int index = 0;
            selected = new Long[10];
            itr = groupList.iterator();
            while (itr.hasNext()) {
                selected[index++] = (Long)itr.next();
            }
        } else {
            selected = new Long[groupList.size()];
            groupList.toArray(selected);
        }
        DataObject dobj = DeviceGroupUtil.getGroupsDO(selected);
        itr = dobj.getRows("HostGroup");
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            groups.put(row.get("NAME"));
        }
        return groups;
    }

    public static DataObject getGroupDetailedDO() throws DataAccessException {
        return DeviceGroupUtil.getGroupDetailedDO((Criteria)null);
    }

    public static DataObject getGroupDetailedDO(Long[] groupID) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)groupID, 8);
        return DeviceGroupUtil.getGroupDetailedDO(criteria);
    }

    public static DataObject getGroupsDO(Long[] groupID) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)groupID, 8);
        return PersistenceDBUtil.getPersistence().get("HostGroup", criteria);
    }

    public static DataObject getGroupDetailedDO(Criteria criteria) throws DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"HostGroup"));
        Join join = new Join(Table.getTable((String)"HostGroup"), Table.getTable((String)"HostGroupMapping"), new String[]{"ID"}, new String[]{"GROUPID"}, 1);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        query.addJoin(join);
        query.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    public static long getWindowsGroupID() {
        return windowsGroupID;
    }

    private static void setWindowsGroupID(long windowsGroupID) {
        DeviceGroupUtil.windowsGroupID = windowsGroupID;
    }

    public static long getDefaultGroupID() {
        return defaultGroupID;
    }

    private static void setDefaultGroupID(long defaultGroupID) {
        DeviceGroupUtil.defaultGroupID = defaultGroupID;
    }

    public static long getUnixGroupID() {
        return unixGroupID;
    }

    private static void setUnixGroupID(long unixGroupID) {
        DeviceGroupUtil.unixGroupID = unixGroupID;
    }

    public static boolean checkIsAllowedNameChangeAction(Long ... groupIDs) {
        return DeviceGroupUtil.checkToVerifyDefaultGroups(groupIDs);
    }

    public static boolean checkIsAllowedUpdateAction(Long groupID) {
        return groupID != DeviceGroupUtil.getDefaultGroupID();
    }

    public static boolean checkIsAllowedDeleteAction(UserAccessResource userResource, Long ... groupIDs) {
        if (userResource.checkItHasFullDataAccess()) {
            return DeviceGroupUtil.checkToVerifyDefaultGroups(groupIDs);
        }
        Set<Long> currentGroups = userResource.getAllAllowedGroups();
        if (currentGroups.size() <= groupIDs.length) {
            LOGGER.info("Invalid group delete request");
            return false;
        }
        for (Long groupID : groupIDs) {
            if (currentGroups.contains(groupID)) continue;
            return false;
        }
        return DeviceGroupUtil.checkToVerifyDefaultGroups(groupIDs);
    }

    public static Long[] checkOtherUsersAndgetValidgroups(Map<Long, Map<Long, List<Long>>> userVsGroupMap, Long ... requestedGroupIDs) {
        LinkedList<Long> requestedList = new LinkedList<Long>(Arrays.asList(requestedGroupIDs));
        try {
            HashSet<Long> restricted = new HashSet<Long>();
            Iterator<Long> itr = userVsGroupMap.keySet().iterator();
            while (itr.hasNext()) {
                Long loginID = itr.next();
                Map<Long, List<Long>> viewDetails = userVsGroupMap.get(loginID);
                Iterator<Long> viewItr = userVsGroupMap.keySet().iterator();
                while (viewItr.hasNext()) {
                    Long key = itr.next();
                    List<Long> groupID = viewDetails.get(key);
                    int totalHitcount = 0;
                    for (int index = 0; index < requestedList.size(); ++index) {
                        Long entryFromrquestedList = (Long)requestedList.get(index);
                        if (!groupID.contains(entryFromrquestedList)) continue;
                        ++totalHitcount;
                    }
                    if (totalHitcount != groupID.size()) continue;
                    restricted.addAll(groupID);
                }
            }
            requestedList.removeAll(restricted);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return requestedList.toArray(new Long[requestedList.size()]);
    }

    public static boolean checkToVerifyDefaultGroups(Long ... groupIDs) {
        for (Long groupID : groupIDs) {
            if (groupID != DeviceGroupUtil.getDefaultGroupID() && groupID != DeviceGroupUtil.getUnixGroupID() && groupID != DeviceGroupUtil.getWindowsGroupID()) continue;
            return false;
        }
        return true;
    }

    public static int getAdminServerDefGroupCount() {
        if (ServerDetailsBean.getInstance().isAdminServer()) {
            return DBUtil.getCountInt("HostGroup", new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)1000000000L, 6));
        }
        return -1;
    }

    private static DataObject getDeviceGroupDetailsDO(long groupID) throws DataAccessException {
        Table mapping = Table.getTable((String)"HostGroupMapping");
        Table device = Table.getTable((String)"Hosts");
        Table deviceGroup = Table.getTable((String)"HostGroup");
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"HostGroup"));
        query.addSelectColumn(Column.getColumn((String)"HostGroup", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"HostGroupMapping", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"DISPLAY_NAME"));
        query.setCriteria(new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)groupID, 0));
        query.addJoin(new Join(deviceGroup, mapping, new String[]{"ID"}, new String[]{"GROUPID"}, 1));
        query.addJoin(new Join(mapping, device, new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 1));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    private static Object getDeviceNameList(DataObject dobj, int max) {
        JSONArray array = new JSONArray();
        try {
            Iterator itr = dobj.getRows("Hosts");
            while (itr.hasNext() && max > 0) {
                Row row = (Row)itr.next();
                array.put(row.get("DISPLAY_NAME"));
                --max;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return array;
    }

    public static Long[] getValidatedGroupIDs(JSONArray jsonArray) throws JSONException {
        Long[] groupIDs = new Long[jsonArray.length()];
        Long[] validGroupIDs = null;
        for (int index = 0; index < jsonArray.length(); ++index) {
            groupIDs[index] = jsonArray.getLong(index);
        }
        try {
            Criteria crt = new Criteria(Column.getColumn((String)"HostGroup", (String)"ID"), (Object)groupIDs, 8);
            DataObject obj = PersistenceDBUtil.getPersistence().get("HostGroup", crt);
            validGroupIDs = DeviceGroupUtil.collectGroupIDList(obj);
        }
        catch (Exception e) {
            LOGGER.info("Exception while validating group ids");
            e.printStackTrace();
        }
        return validGroupIDs;
    }

    static {
        DeviceGroupUtil.setWindowsGroupID(DeviceGroupUtil.getDeviceGroupId("WindowsGroup"));
        DeviceGroupUtil.setDefaultGroupID(DeviceGroupUtil.getDeviceGroupId("DefaultGroup"));
        DeviceGroupUtil.setUnixGroupID(DeviceGroupUtil.getDeviceGroupId("UnixGroup"));
    }
}

