/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.management;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.lc.FieldRepository;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.HostDBHandler;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.config.ports.ManageSyslogListenerPort;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.delegation.DelegationUtil;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.device.DeviceProperties;
import com.manageengine.ela.server.common.device.LogCollectionStatus;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.management.DeviceOperations;
import com.manageengine.ela.server.common.device.management.ExtendedDeviceActions;
import com.manageengine.ela.server.common.device.monitors.WindowsDeviceIPMonitor;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.common.util.Credential;
import com.manageengine.ela.server.common.util.Priority;
import com.manageengine.ela.server.common.util.StringUtil;
import com.manageengine.ela.server.reports.converter.ReportConverter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AddOrUpdateEventlogDevice {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final Logger LOGGER = Logger.getLogger(AddOrUpdateEventlogDevice.class.getName());

    public static JSONObject enableOrDisableDevice(Long[] deviceID, int status, Locale locale) throws Exception {
        return DeviceOperations.enableOrDisableDevice(deviceID, status, locale);
    }

    public static ArrayList<Long> addUnverifiedDevice(String deviceName) throws Exception {
        return AddOrUpdateEventlogDevice.addUnverifiedDevice(deviceName, LogSourceCategoryContainer.DeviceCategory.UNKNOWN, null, TechnicianUtil.getDefaultAdminUserID());
    }

    public static ArrayList<Long> addUnverifiedDevice(String deviceName, Long userID) throws Exception {
        return AddOrUpdateEventlogDevice.addUnverifiedDevice(deviceName, LogSourceCategoryContainer.DeviceCategory.UNKNOWN, null, userID);
    }

    public static ArrayList<Long> addUnverifiedDevice(String deviceName, LogSourceCategoryContainer.DeviceCategory deviceCategory) throws Exception {
        return AddOrUpdateEventlogDevice.addUnverifiedDevice(deviceName, deviceCategory, null, TechnicianUtil.getDefaultAdminUserID());
    }

    public static ArrayList<Long> addUnverifiedDevice(String deviceName, LogSourceCategoryContainer.DeviceCategory deviceCategory, Long userID) throws Exception {
        return AddOrUpdateEventlogDevice.addUnverifiedDevice(deviceName, deviceCategory, null, userID);
    }

    public static ArrayList<Long> addUnverifiedDevice(String deviceName, LogSourceCategoryContainer.DeviceCategory deviceCategory, Credential crd, Long userID) throws Exception {
        JSONObject reqJsonObject = new JSONObject();
        reqJsonObject.put("DEVICE_NAME", (Object)deviceName.trim());
        reqJsonObject.put("DEVICE_CATEGORY", (Object)deviceCategory);
        if (crd != null) {
            reqJsonObject.put("DOMAIN_NAME", (Object)crd.getDomain());
            reqJsonObject.put("USERNAME", (Object)crd.getUserName());
            reqJsonObject.put("PASSWORD", (Object)crd.getPassword());
        }
        return AddOrUpdateEventlogDevice.addAndGetDeviceIDList(reqJsonObject, deviceCategory, userID);
    }

    public static ArrayList<Long> addAndGetDeviceIDList(JSONObject reqJsonObject, LogSourceCategoryContainer.DeviceCategory deviceCategory, Long userID) throws Exception {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        if (AddOrUpdateEventlogDevice.addUnverifiedElaDevice(deviceCategory, userID, reqJsonObject)) {
            deviceList.addAll(DeviceUtil.getDeviceIdList(reqJsonObject.getString("DEVICE_NAME")));
        }
        return deviceList;
    }

    private static boolean addUnverifiedElaDevice(LogSourceCategoryContainer.DeviceCategory deviceCategory, Long userID, JSONObject reqJsonObject) throws Exception {
        if (userID == null) {
            userID = DeviceUtil.getLoginID();
        }
        UserAccessResource accessControl = UserAccessResource.getUserAccessResource(userID);
        JSONArray deviceDetails = DeviceUtil.loadDeviceDetailsFromJSON(reqJsonObject);
        if (deviceCategory == LogSourceCategoryContainer.DeviceCategory.WINDOWS || deviceCategory == LogSourceCategoryContainer.DeviceCategory.UNKNOWN) {
            return AddOrUpdateEventlogDevice.configureFromLocalDiscoveredList(deviceDetails, reqJsonObject, new ResponseBuilder(), accessControl);
        }
        return AddOrUpdateEventlogDevice.processAddDeviceRequest(deviceDetails, reqJsonObject, new ResponseBuilder(), accessControl, new boolean[0]);
    }

    public static boolean configureFromLocalDiscoveredList(JSONArray deviceDetails, JSONObject reqJsonObject, ResponseBuilder responseBuilder, UserAccessResource accessControl) throws Exception {
        return AddOrUpdateEventlogDevice.configureFromLocalDiscoveredList(deviceDetails, reqJsonObject, responseBuilder, accessControl, false);
    }

    public static boolean configureValidDeviceFromLocalDiscoveredList(JSONArray deviceDetails, JSONObject reqJsonObject, ResponseBuilder responseBuilder, UserAccessResource accessControl) throws Exception {
        return AddOrUpdateEventlogDevice.configureFromLocalDiscoveredList(deviceDetails, reqJsonObject, responseBuilder, accessControl, true);
    }

    private static boolean configureFromLocalDiscoveredList(JSONArray deviceDetails, JSONObject reqJsonObject, ResponseBuilder responseBuilder, UserAccessResource accessControl, boolean doValidation) throws Exception {
        JSONArray derivedDeviceDetails;
        String key;
        Iterator itr;
        JSONObject domainDevices;
        boolean status = true;
        JSONObject discoveredDevice = DeviceUtil.isDeviceDiscovered(deviceDetails);
        JSONObject invalidDevice = new JSONObject();
        if (discoveredDevice.has("DOMAIN_DEVICES")) {
            reqJsonObject.put("WORKGROUP_ID", JSONObject.NULL);
            domainDevices = discoveredDevice.getJSONObject("DOMAIN_DEVICES");
            itr = domainDevices.keys();
            while (itr.hasNext()) {
                key = itr.next().toString();
                Long domainID = Long.valueOf(key);
                derivedDeviceDetails = domainDevices.getJSONArray(key);
                reqJsonObject.put("DOMAIN_ID", (Object)domainID);
                if (doValidation) {
                    status &= AddOrUpdateEventlogDevice.addValidDevice(derivedDeviceDetails, reqJsonObject, responseBuilder, accessControl, invalidDevice);
                    continue;
                }
                status &= AddOrUpdateEventlogDevice.processAddDeviceRequest(derivedDeviceDetails, reqJsonObject, accessControl, invalidDevice, new boolean[0]);
            }
        }
        if (discoveredDevice.has("WORKGROUP_DEVICES")) {
            reqJsonObject.put("DOMAIN_ID", JSONObject.NULL);
            domainDevices = discoveredDevice.getJSONObject("WORKGROUP_DEVICES");
            itr = domainDevices.keys();
            while (itr.hasNext()) {
                key = itr.next().toString();
                Long workgroupID = Long.valueOf(key);
                derivedDeviceDetails = domainDevices.getJSONArray(key);
                reqJsonObject.put("WORKGROUP_ID", (Object)workgroupID);
                if (doValidation) {
                    status &= AddOrUpdateEventlogDevice.addValidDevice(derivedDeviceDetails, reqJsonObject, responseBuilder, accessControl, invalidDevice);
                    continue;
                }
                status &= AddOrUpdateEventlogDevice.processAddDeviceRequest(derivedDeviceDetails, reqJsonObject, accessControl, invalidDevice, new boolean[0]);
            }
        }
        if (discoveredDevice.has("OTHER_DEVICES")) {
            reqJsonObject.put("WORKGROUP_ID", JSONObject.NULL);
            reqJsonObject.put("DOMAIN_ID", JSONObject.NULL);
            JSONArray derivedDeviceDetails2 = discoveredDevice.getJSONArray("OTHER_DEVICES");
            status = doValidation ? (status &= AddOrUpdateEventlogDevice.addValidDevice(derivedDeviceDetails2, reqJsonObject, responseBuilder, accessControl, invalidDevice)) : (status &= AddOrUpdateEventlogDevice.processAddDeviceRequest(derivedDeviceDetails2, reqJsonObject, accessControl, invalidDevice, new boolean[0]));
        }
        return status & AddOrUpdateEventlogDevice.finalizeResponseBuilder(responseBuilder, invalidDevice);
    }

    public static boolean addDevice(JSONObject requestDetails, ResponseBuilder responseBuilder, Long user_id, boolean ... flag) throws Exception {
        UserAccessResource accessControl = UserAccessResource.getUserAccessResource(user_id);
        return AddOrUpdateEventlogDevice.processAddDeviceRequest(DeviceUtil.loadDeviceDetailsFromJSON(requestDetails), requestDetails, responseBuilder, accessControl, flag);
    }

    public static boolean addDevice(JSONObject requestDetails, ResponseBuilder responseBuilder, UserAccessResource accessControl, boolean ... flag) throws Exception {
        return AddOrUpdateEventlogDevice.processAddDeviceRequest(DeviceUtil.loadDeviceDetailsFromJSON(requestDetails), requestDetails, responseBuilder, accessControl, flag);
    }

    public static boolean addDevice(JSONArray deviceDetails, JSONObject requestDetails, ResponseBuilder responseBuilder, UserAccessResource accessControl, boolean ... flag) throws Exception {
        return AddOrUpdateEventlogDevice.processAddDeviceRequest(deviceDetails, requestDetails, responseBuilder, accessControl, flag);
    }

    public static boolean addValidDevice(JSONArray deviceDetails, JSONObject requestDetails, ResponseBuilder responseBuilder, UserAccessResource accessControl) throws Exception {
        JSONObject invalidDevices = new JSONObject();
        boolean status = AddOrUpdateEventlogDevice.addValidDevice(deviceDetails, requestDetails, responseBuilder, accessControl, invalidDevices);
        return status & AddOrUpdateEventlogDevice.finalizeResponseBuilder(responseBuilder, invalidDevices);
    }

    public static boolean addValidDevice(JSONArray deviceDetails, JSONObject requestDetails, ResponseBuilder responseBuilder, UserAccessResource accessControl, JSONObject invalidDevices) throws Exception {
        boolean status = true;
        JSONArray unknwonDevice = new JSONArray();
        ArrayList<JSONObject> selectedDevice = new ArrayList<JSONObject>(deviceDetails.length());
        for (int index = 0; index < deviceDetails.length(); ++index) {
            JSONObject device = deviceDetails.getJSONObject(index);
            InetAddress inetAddress = DeviceUtil.resolveDNSForDevice(device.getString("NAME"));
            if (inetAddress == null) {
                unknwonDevice.put((Object)device.getString("NAME"));
                continue;
            }
            device.put("NAME", (Object)inetAddress.getHostName());
            device.put("FQDN", (Object)inetAddress.getCanonicalHostName());
            device.put("IPADDRESS", (Object)inetAddress.getHostAddress());
            selectedDevice.add(device);
        }
        if (selectedDevice.size() > 0) {
            boolean subStatus = AddOrUpdateEventlogDevice.processAddDeviceRequest(new JSONArray(selectedDevice), requestDetails, accessControl, invalidDevices, new boolean[0]);
            if (subStatus) {
                responseBuilder.addKeyPair("FORCE_RELOAD_TABLE", Boolean.TRUE);
            }
            status &= subStatus;
        }
        if (unknwonDevice.length() > 0) {
            status = false;
            invalidDevices.put("UNKNOW_DEVICE", (Object)unknwonDevice);
        }
        return status;
    }

    private static boolean processAddDeviceRequest(JSONArray deviceDetails, JSONObject request, ResponseBuilder responseBuilder, UserAccessResource accessControl, boolean ... flag) throws Exception {
        JSONObject invalidDevices = new JSONObject();
        boolean status = AddOrUpdateEventlogDevice.processAddDeviceRequest(deviceDetails, request, accessControl, invalidDevices, flag);
        return status & AddOrUpdateEventlogDevice.finalizeResponseBuilder(responseBuilder, invalidDevices);
    }

    private static boolean processAddDeviceRequest(JSONArray deviceDetails, JSONObject request, UserAccessResource accessControl, JSONObject invalidDevices, boolean ... flag) throws Exception {
        boolean status = true;
        if (deviceDetails.length() == 0) {
            return false;
        }
        long time = System.currentTimeMillis();
        Credential deviceCredential = Credential.getCredential(request);
        deviceCredential.resolveDomainAndUserName();
        Object deviceCat = request.opt("DEVICE_CATEGORY");
        LogSourceCategoryContainer.DeviceCategory deviceCategory = AddOrUpdateEventlogDevice.findDeviceCategory(deviceCat, LogSourceCategoryContainer.DeviceCategory.UNIX);
        Long domainID = request.isNull("DOMAIN_ID") ? null : Long.valueOf(request.getLong("DOMAIN_ID"));
        Long workgroupID = request.isNull("WORKGROUP_ID") ? null : Long.valueOf(request.getLong("WORKGROUP_ID"));
        String monInterval = request.isNull("MONITORINTERVAL") ? "10" : request.getString("MONITORINTERVAL");
        boolean ennableSSL = request.isNull("ENABLE_SSL") ? false : request.getBoolean("ENABLE_SSL");
        Long collectorID = request.isNull("COLLECTOR_ID") ? null : Long.valueOf(request.getLong("COLLECTOR_ID"));
        Integer deviceSourceId = request.isNull("DEVICE_SOURCE_ID") ? null : Integer.valueOf(request.getInt("DEVICE_SOURCE_ID"));
        String sysLogPort = request.isNull("SYSLOG_DEVICE") ? null : String.valueOf(ManageSyslogListenerPort.getDefaultPortPair().getPort());
        String sysLogProtocol = request.isNull("SYSLOG_DEVICE") ? null : ManageSyslogListenerPort.getDefaultPortPair().getProtocol();
        String dns_name = request.isNull("DNS_NAME") ? null : request.getString("DNS_NAME");
        String source_product = request.isNull("SOURCE_PRODUCT") ? null : request.getString("SOURCE_PRODUCT");
        String deviceType = request.isNull("DEVICE_TYPE") ? null : request.getString("DEVICE_TYPE");
        int deviceStatus = request.isNull("STATUS") ? 1 : request.getInt("STATUS");
        Boolean isInherited = request.isNull("IS_INHERITED") ? false : request.getBoolean("IS_INHERITED");
        String delimiter = request.isNull("DELIMITER") ? null : request.getString("DELIMITER");
        String dateFormat = request.isNull("DATE_FORMAT") ? null : request.getString("DATE_FORMAT");
        boolean isDelayedPostAction = request.isNull("DELAYED_DEVICE_POST_ACTION") ? false : request.getBoolean("DELAYED_DEVICE_POST_ACTION");
        LogSourceCategoryContainer.DeviceCategory deviceCategory2 = deviceCategory = deviceCategory == null ? LogSourceCategoryContainer.DeviceCategory.UNIX : deviceCategory;
        if (deviceCategory == LogSourceCategoryContainer.DeviceCategory.AS400) {
            if (!ServerDetailsBean.getInstance().isPremiumFeatureAllowed()) {
                LOGGER.info("Access denied : AS400 device not allowed only in premium edition");
                throw BaseStatusCode.getBaseStatusCode(7426);
            }
            deviceCredential.setDomain(dateFormat + "," + delimiter);
        }
        long groupID = DelegationUtil.getGroupID(deviceCategory, accessControl);
        List<String> deviceNameList = DeviceUtil.getDeviceNameListFromRequestJSON(deviceDetails);
        HashMap<String, HashMap<String, String>> deviceDetailsMap = domainID != null ? AddOrUpdateEventlogDevice.loadDomainDeviceExtendedDetails(deviceNameList.toArray(new String[deviceNameList.size()]), domainID) : null;
        JSONArray duplicateDeviceList = new JSONArray();
        for (int index = 0; index < deviceDetails.length(); ++index) {
            JSONObject jsonObject = deviceDetails.getJSONObject(index);
            String deviceName = jsonObject.getString("NAME");
            DeviceProperties properties = new DeviceProperties(deviceName);
            properties.setDeviceDisplayName(deviceName);
            properties.setDeviceDns_name(deviceName);
            properties.setUserID(accessControl.getUserID());
            properties.setSSLEnabled(ennableSSL);
            if (!jsonObject.isNull("DEVICE_CATEGORY")) {
                properties.setDeviceCategory((LogSourceCategoryContainer.DeviceCategory)jsonObject.get("DEVICE_CATEGORY"));
            } else {
                properties.setDeviceCategory(deviceCategory);
            }
            if (dns_name != null) {
                properties.setDeviceDns_name(dns_name);
            }
            if (source_product != null) {
                properties.setSourceProduct(source_product);
            }
            if (deviceType != null) {
                properties.setDeviceType(deviceType);
            }
            properties.setSyncedDevice(isInherited);
            if (!jsonObject.isNull("IPADDRESS")) {
                properties.setDeviceAddress(jsonObject.getString("IPADDRESS"));
            }
            if (!jsonObject.isNull("ISHISTORICCOLLECTION") && jsonObject.getBoolean("ISHISTORICCOLLECTION")) {
                properties.setLastScanTime(0L);
            }
            if (deviceDetailsMap != null && deviceDetailsMap.get(deviceName.toUpperCase()) != null) {
                HashMap<String, String> details = deviceDetailsMap.get(deviceName.toUpperCase());
                properties.setDeviceFQDN(details.get("DNS_NAME") != null ? details.get("DNS_NAME") : null);
                properties.setDeviceType(details.get("OPERATINGSYSTEM") != null ? details.get("OPERATINGSYSTEM") : null);
            }
            properties.setDeviceStatus(LogCollectionStatus.getStatus(deviceStatus));
            properties.setDeviceCredential(deviceCredential);
            if (monInterval != null) {
                properties.setMonitorInterval(Long.parseLong(monInterval));
            }
            properties.setDeviceGroup(groupID);
            if (collectorID != null) {
                properties.setLogCollectorID(collectorID);
            } else {
                properties.setLogCollectorID(ServerDetailsBean.getInstance().getSysEvtColID());
            }
            if (sysLogPort != null) {
                properties.setDevice_sysLogPort(sysLogPort);
            }
            if (sysLogProtocol != null) {
                properties.setDevice_sysLogProtocol(sysLogProtocol);
            }
            if (domainID != null) {
                properties.setDeviceDomainID(domainID);
            }
            if (workgroupID != null) {
                properties.setDeviceWorkgroupID(workgroupID);
            }
            if (deviceSourceId != null) {
                properties.setDeviceSourceId(deviceSourceId);
            }
            if (!request.isNull("SYSLOG_PROTOCOL")) {
                properties.setDevice_sysLogProtocol(request.getString("SYSLOG_PROTOCOL"));
            }
            if (!request.isNull("DNS_FULLNAME")) {
                properties.setDeviceFQDN(request.getString("DNS_FULLNAME"));
            }
            if (!request.isNull("LAST_MSG_TIME")) {
                properties.setLastMsgTime(Long.parseLong(request.getString("LAST_MSG_TIME")));
            }
            if (!request.isNull("SYSLOG_PORT")) {
                properties.setDevice_sysLogPort(request.getString("SYSLOG_PORT"));
            }
            if (!request.isNull("AUTO_ADD")) {
                if (request.getBoolean("AUTO_ADD")) {
                    properties.setAutoAddDevice(true);
                } else {
                    properties.setAutoAddDevice(false);
                }
            }
            if (!AddOrUpdateEventlogDevice.checkDeviceAvailablity(properties)) {
                if (properties.getDeviceAddress() == null) {
                    properties.setDeviceAddress(deviceName);
                }
                if (properties.getDeviceFQDN() == null) {
                    properties.setDeviceFQDN(deviceName);
                }
                status &= AddOrUpdateEventlogDevice.addNewEventlogDevice(properties, isDelayedPostAction, flag);
                continue;
            }
            duplicateDeviceList.put((Object)deviceName);
        }
        if (deviceCategory == LogSourceCategoryContainer.DeviceCategory.WINDOWS) {
            HostDBHandler.synchronizeNow("Add new Device", true);
        }
        if (duplicateDeviceList.length() > 0) {
            invalidDevices.put("DUPLICATE_DEVICE", (Object)duplicateDeviceList);
        }
        LOGGER.fine("Time taken for add device : " + (System.currentTimeMillis() - time));
        return status;
    }

    public static boolean addNewEventlogDevice(DeviceProperties properties) throws Exception {
        boolean status = AddOrUpdateEventlogDevice.addNewEventlogDevice(properties, false, false);
        if (status && properties.getDeviceCategory() == LogSourceCategoryContainer.DeviceCategory.WINDOWS) {
            HostDBHandler.synchronizeNow("Add new Device", true);
        }
        return status;
    }

    public static boolean addNewEventlogDevice(DeviceProperties properties, boolean isDelayedPostAction, boolean ... flag) throws Exception {
        boolean deviceStatus = true;
        long time = System.currentTimeMillis();
        DataObject deviceDataObject = PersistenceDBUtil.getPersistence().constructDataObject();
        AddOrUpdateEventlogDevice.loadDeviceDetailsInDataObject(deviceDataObject, properties);
        DeviceOperations.updateDeviceTypeSet();
        try {
            HostDBHandler.addOrUpdateHostsCache(deviceDataObject);
            deviceDataObject = PersistenceDBUtil.getPersistence((boolean[])flag).add(deviceDataObject);
            Row deviceDetails = deviceDataObject.getFirstRow("HostDetails");
            Long deviceID = (Long)deviceDetails.get("HOST_ID");
            properties.setDeviceID(deviceID);
            if (LogSourceCategoryContainer.DeviceCategory.AS400 == properties.getDeviceCategory()) {
                ExtendedDeviceActions.handlPostAS400Setup(properties);
            } else if (LogSourceCategoryContainer.DeviceCategory.WINDOWS == properties.getDeviceCategory()) {
                ExtendedDeviceActions.populateWindowsPredefinedLogtypes(properties);
            }
            try {
                NotificationManager.getInstance().hostMap.put(properties.getDeviceID(), properties.getDeviceDns_name());
                NotificationManager.getInstance().addHostsToDefaultThreatProfile(deviceID, properties.getDeviceGroup());
                WindowsDeviceIPMonitor.getInstance().add(properties.getDeviceID(), Priority.MEDIUM);
            }
            catch (Exception exp) {
                LOGGER.log(Level.FINER, "WARNING: Exception while adding entry in ipmonitor for Host {0}", properties.getDeviceDns_name());
                exp.printStackTrace();
            }
            if (properties.getDeviceCategory() != LogSourceCategoryContainer.DeviceCategory.UNKNOWN) {
                ExtendedDeviceActions.handlepostDelayedActions(Arrays.asList(properties), isDelayedPostAction);
            }
            if (!properties.isAutoAddDevice()) {
                try {
                    HostDBHandler.addSlUpdateRow(properties.getDeviceID(), HostDBHandler.getServiceType(CommonUtil.SlUpdateConstants.HOSTADD), ServerDetailsBean.getInstance().getSysEvtColID());
                }
                catch (Exception exp) {
                    LOGGER.log(Level.FINER, "WARNING: Exception while adding entry in slupdate {0}", properties.getDeviceDns_name());
                    exp.printStackTrace();
                }
            }
            LOGGER.log(Level.INFO, "Host Added succesfully {0}", properties.getDeviceDns_name());
        }
        catch (Exception exp) {
            deviceStatus = false;
            LOGGER.info("Exception occurred while addNewEventlogDevice , exception details : " + exp.getMessage());
        }
        LOGGER.fine("Time taken for add single device : " + (System.currentTimeMillis() - time));
        UserAccessResource.removeAllCache();
        return deviceStatus;
    }

    private static void loadDeviceDetailsInDataObject(DataObject deviceDataObject, DeviceProperties properties) throws Exception {
        Row deviceParentRow = new Row("Hosts");
        Row deviceDetails = new Row("HostDetails");
        Row deviceGroupMapping = new Row("HostGroupMapping");
        deviceParentRow.set("HOST_IPADDRESS", (Object)properties.getDeviceAddress());
        deviceParentRow.set("HOST_NAME", (Object)properties.getDeviceName());
        if (properties.getDeviceDisplayName() != null) {
            deviceParentRow.set("DISPLAY_NAME", (Object)properties.getDeviceDisplayName());
        } else {
            deviceParentRow.set("DISPLAY_NAME", (Object)properties.getDeviceName());
        }
        deviceParentRow.set("DNS_NAME", (Object)properties.getDeviceDns_name());
        deviceParentRow.set("DNS_FULLNAME", (Object)properties.getDeviceFQDN());
        deviceDetails.set("HOST_ID", deviceParentRow.get("HOST_ID"));
        deviceDetails.set("SLID", (Object)properties.getLogCollectorID());
        deviceDetails.set("TYPE", (Object)properties.getDeviceCategory().getCategoryName());
        deviceDetails.set("SUBTYPE", (Object)properties.getDeviceType());
        deviceDetails.set("SOURCE_PRODUCT", (Object)properties.getParenProductUUID());
        Credential cred = properties.getDeviceCredential();
        if (cred != null) {
            if (cred.getPassword() != null && !cred.getPassword().isEmpty()) {
                String decryptedPwd = EnDecryptImplSingleton.getInstance().encrypt(cred.getPassword());
                deviceDetails.set("PASSWORD", (Object)decryptedPwd);
            }
            deviceDetails.set("USERNAME", (Object)cred.getUserName());
            deviceDetails.set("DOMAIN_NAME", (Object)cred.getDomain());
        }
        deviceDetails.set("DOMAIN_ID", (Object)properties.getDeviceDomainID());
        deviceDetails.set("WORKGROUP_ID", (Object)properties.getDeviceWorkgroupID());
        deviceDetails.set("MON_INTERVAL", (Object)(properties.getMonitorInterval() > 10L ? properties.getMonitorInterval() : 10L));
        deviceDetails.set("SYSLOG_PORT", (Object)properties.getDevice_sysLogPort());
        deviceDetails.set("SYSLOG_PROTOCOL", (Object)properties.getDevice_sysLogProtocol());
        deviceDetails.set("LOG_COLLECTION_STATUS", (Object)properties.getDeviceStatus().getStatus());
        deviceDetails.set("ISINHERITED", (Object)(properties.isSyncedDevice() ? new Integer(1) : new Integer(0)));
        deviceDetails.set("STATUS", (Object)0L);
        deviceDetails.set("IMAGE", (Object)properties.getDeviceCategory().getImage());
        deviceDetails.set("ENABLESSL", (Object)properties.isSSLEnabled());
        deviceDetails.set("DEVICE_SOURCE_ID", (Object)properties.getDeviceSourceId());
        if (properties.getLastMsgTime() != null) {
            deviceDetails.set("LAST_MSG_TIME", (Object)properties.getLastMsgTime());
        }
        if (properties.getSourceProduct() != null) {
            deviceDetails.set("SOURCE_PRODUCT", (Object)properties.getSourceProduct());
        }
        deviceGroupMapping.set("GROUPID", (Object)properties.getDeviceGroup());
        deviceGroupMapping.set("HOSTID", deviceParentRow.get("HOST_ID"));
        deviceDataObject.addRow(deviceParentRow);
        deviceDataObject.addRow(deviceDetails);
        deviceDataObject.addRow(deviceGroupMapping);
        if (LogSourceCategoryContainer.DeviceCategory.AS400 == properties.getDeviceCategory()) {
            Row ibmDeviceDetails = new Row("IBMDeviceConfigurations");
            ibmDeviceDetails.set("DEVICE_ID", deviceParentRow.get("HOST_ID"));
            deviceDataObject.addRow(ibmDeviceDetails);
        }
    }

    public static boolean updateDevice(JSONObject deviceListJsonObject, String[] deviceIds) throws BaseStatusCode {
        return AddOrUpdateEventlogDevice.updateDevice(deviceListJsonObject, StringUtil.stringArryToLongArray(deviceIds));
    }

    public static boolean updateDevice(JSONObject deviceListJsonObject, Long[] deviceIds) throws BaseStatusCode {
        boolean deviceStatus = true;
        try {
            LogSourceCategoryContainer.DeviceCategory deviceCategory;
            Long monInterval;
            Long l = monInterval = deviceListJsonObject.isNull("MON_INTERVAL") ? null : Long.valueOf(deviceListJsonObject.getLong("MON_INTERVAL"));
            if (deviceIds.length == 1) {
                long deviceId = deviceIds[0];
                Long[] existingProperties = DeviceUtil.getDeviceProperties(deviceId);
                Credential deviceCredential = Credential.getCredential(deviceListJsonObject);
                deviceCredential.resolveDomainAndUserName();
                String displayName = deviceListJsonObject.isNull("DISPLAY_NAME") ? null : deviceListJsonObject.getString("DISPLAY_NAME");
                String deviceIPAddress = deviceListJsonObject.isNull("DEVICE_IPADDRESS") ? null : deviceListJsonObject.getString("DEVICE_IPADDRESS");
                String sysLogPort = deviceListJsonObject.isNull("SYSLOG_PORT") ? null : deviceListJsonObject.getString("SYSLOG_PORT");
                String sysLogProtocol = deviceListJsonObject.isNull("SYSLOG_PROTOCOL") ? null : deviceListJsonObject.getString("SYSLOG_PROTOCOL");
                String image = deviceListJsonObject.isNull("IMAGE") ? null : deviceListJsonObject.getString("IMAGE");
                boolean isDefaultCredential = !deviceListJsonObject.isNull("DEFAULT_CREDENTIAL") && deviceListJsonObject.getBoolean("DEFAULT_CREDENTIAL");
                boolean enableSSL = !deviceListJsonObject.isNull("ENABLE_SSL") && deviceListJsonObject.getBoolean("ENABLE_SSL");
                existingProperties.setDeviceDisplayName(displayName);
                existingProperties.setDeviceAddress(deviceIPAddress);
                existingProperties.setDevice_sysLogProtocol(sysLogProtocol);
                existingProperties.setDevice_sysLogPort(sysLogPort);
                String delimiter = deviceListJsonObject.isNull("DELIMITER") ? null : deviceListJsonObject.getString("DELIMITER");
                String dateFormat = deviceListJsonObject.isNull("DATE_FORMAT") ? null : deviceListJsonObject.getString("DATE_FORMAT");
                LogSourceCategoryContainer.DeviceCategory deviceCategory2 = AddOrUpdateEventlogDevice.findDeviceCategory(deviceListJsonObject.opt("DEVICE_CATEGORY"), null);
                if (deviceCategory2 != null) {
                    if (deviceCategory2 == LogSourceCategoryContainer.DeviceCategory.AS400) {
                        deviceCredential.setDomain(dateFormat + "," + delimiter);
                    }
                    if (image == null) {
                        image = deviceCategory2.getImage();
                    }
                }
                HashMap<String, Object> deviceHashMap = new HashMap<String, Object>();
                if (displayName != null && !displayName.trim().isEmpty()) {
                    deviceHashMap.put("DISPLAY_NAME", displayName);
                    ReportConverter.removeDisplayNameCache(deviceId);
                }
                if (deviceIPAddress != null && !deviceIPAddress.trim().isEmpty()) {
                    deviceHashMap.put("HOST_IPADDRESS", deviceIPAddress);
                }
                if (!deviceHashMap.isEmpty()) {
                    AddOrUpdateEventlogDevice.updateDataBase("Hosts", "HOST_ID", deviceId, deviceHashMap);
                }
                HashMap<String, Object> deviceDetailsHashMap = new HashMap<String, Object>();
                if (deviceCategory2 != null) {
                    deviceDetailsHashMap.put("TYPE", deviceCategory2.getCategoryName());
                }
                if (deviceCategory2 == LogSourceCategoryContainer.DeviceCategory.AS400 && deviceCredential.getDomain() != null && !deviceCredential.getDomain().trim().isEmpty()) {
                    deviceDetailsHashMap.put("DOMAIN_NAME", deviceCredential.getDomain());
                }
                if (isDefaultCredential) {
                    deviceDetailsHashMap.put("USERNAME", null);
                    deviceDetailsHashMap.put("PASSWORD", null);
                    if (deviceCategory2 != LogSourceCategoryContainer.DeviceCategory.AS400) {
                        deviceDetailsHashMap.put("DOMAIN_NAME", null);
                    }
                } else {
                    if (deviceCredential.getUserName() != null && !deviceCredential.getUserName().equals("")) {
                        deviceDetailsHashMap.put("USERNAME", deviceCredential.getUserName());
                        if (deviceCategory2 != LogSourceCategoryContainer.DeviceCategory.AS400) {
                            deviceDetailsHashMap.put("DOMAIN_NAME", deviceCredential.getDomain());
                        }
                    }
                    if (deviceCredential.getPassword() != null) {
                        deviceDetailsHashMap.put("PASSWORD", EnDecryptImplSingleton.getInstance().encrypt(deviceCredential.getPassword()));
                    }
                }
                if (monInterval != null && monInterval >= 10L) {
                    deviceDetailsHashMap.put("MON_INTERVAL", monInterval.toString());
                }
                if (sysLogProtocol != null) {
                    deviceDetailsHashMap.put("SYSLOG_PROTOCOL", sysLogProtocol);
                }
                if (sysLogPort != null) {
                    deviceDetailsHashMap.put("SYSLOG_PORT", sysLogPort);
                }
                if (image != null) {
                    deviceDetailsHashMap.put("IMAGE", image);
                }
                deviceDetailsHashMap.put("ENABLESSL", String.valueOf(enableSSL));
                if (existingProperties.getDeviceCategory() == LogSourceCategoryContainer.DeviceCategory.UNKNOWN || existingProperties.getDeviceCategory() == LogSourceCategoryContainer.DeviceCategory.UNKNOWNCATEGORY) {
                    deviceDetailsHashMap.put("IMAGE", deviceCategory2.getImage());
                    existingProperties.setDeviceCategory(deviceCategory2);
                    ExtendedDeviceActions.handlepostDelayedActions(Arrays.asList(new DeviceProperties[]{existingProperties}), true);
                }
                AddOrUpdateEventlogDevice.updateDataBase("HostDetails", "HOST_ID", deviceId, deviceDetailsHashMap);
                HostDBHandler.addSlUpdateRow(deviceId, HostDBHandler.getServiceType(CommonUtil.SlUpdateConstants.HOSTUPDATE), existingProperties.getLogCollectorID());
            } else if (monInterval != null && monInterval >= 10L) {
                HashMap<String, Object> deviceDetailsHashMap = new HashMap<String, Object>();
                deviceDetailsHashMap.put("MON_INTERVAL", monInterval.toString());
                for (int index = 0; index < deviceIds.length; ++index) {
                    AddOrUpdateEventlogDevice.updateDataBase("HostDetails", "HOST_ID", deviceIds[index], deviceDetailsHashMap);
                }
                DeviceUtil.handleSLUpdateForUpdateDevice(new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceIds, 8));
            }
            if (monInterval != null && monInterval >= 10L && (deviceCategory = AddOrUpdateEventlogDevice.findDeviceCategory(deviceListJsonObject.opt("DEVICE_CATEGORY"), null)) != null && deviceCategory == LogSourceCategoryContainer.DeviceCategory.AS400) {
                ArrayList<String> scheduleNameList = new ArrayList<String>();
                for (Long deviceId : deviceIds) {
                    scheduleNameList.add(DeviceUtil.getDeviceBasicDetails(deviceId).get("DEVICE_NAME") + "_AS400Schedule");
                }
                UpdateQueryImpl updateQuery = new UpdateQueryImpl("Periodic");
                updateQuery.addJoin(new Join("Periodic", "Schedule", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2));
                Criteria criteria = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)scheduleNameList.toArray(new String[0]), 8);
                updateQuery.setCriteria(criteria);
                updateQuery.setUpdateColumn("TIME_PERIOD", (Object)monInterval);
                PERSISTENCELITE.update((UpdateQuery)updateQuery);
            }
        }
        catch (BaseStatusCode basecode) {
            throw basecode;
        }
        catch (JSONException exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        catch (Exception exp) {
            deviceStatus = false;
            LOGGER.info("Exception occurred while addNewEventlogDevice , exception details : " + exp.getMessage());
            exp.printStackTrace();
        }
        FieldRepository.get_instance().updateFields();
        return deviceStatus;
    }

    private static LogSourceCategoryContainer.DeviceCategory findDeviceCategory(Object value, LogSourceCategoryContainer.DeviceCategory defaultvalue) {
        LogSourceCategoryContainer.DeviceCategory category = defaultvalue;
        if (value != null) {
            category = value instanceof LogSourceCategoryContainer.DeviceCategory ? (LogSourceCategoryContainer.DeviceCategory)value : LogSourceCategoryContainer.DeviceCategory.getCategory(value.toString());
        }
        return category;
    }

    private static void updateDataBase(String tableName, String pKey, Object pKeyValue, Map<String, Object> data) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)pKey), pKeyValue, 0);
        DataBaseReqestProcessor.executeUpdateQuery(tableName, data, criteria, new boolean[0]);
    }

    public static boolean checkDeviceAvailablity(DeviceProperties properties) throws Exception {
        return AddOrUpdateEventlogDevice.checkDeviceAvailablity(properties.getDeviceDns_name(), properties.getDeviceName(), properties.getDeviceAddress(), properties.getDeviceFQDN());
    }

    public static boolean checkDeviceAvailablity(String dnsName, String name, String fqdn, String ipAddress) throws Exception {
        boolean status = false;
        DataObject dobj = AddOrUpdateEventlogDevice.checkELADeviceAvailablity(dnsName, name, ipAddress, fqdn);
        if (dobj != null && !dobj.isEmpty()) {
            status = true;
        }
        return status;
    }

    public static DataObject checkELADeviceAvailablity(DeviceProperties properties) throws Exception {
        return AddOrUpdateEventlogDevice.checkELADeviceAvailablity(properties.getDeviceDns_name(), properties.getDeviceName(), properties.getDeviceAddress(), properties.getDeviceFQDN());
    }

    public static DataObject checkELADeviceAvailablity(String dnsName, String name, String fqdn, String ipAddress) throws Exception {
        DataObject dobj = null;
        Criteria criteria = new Criteria(Column.getColumn((String)"Hosts", (String)"DNS_NAME"), (Object)dnsName, 0);
        if (name != null) {
            criteria = criteria.or(new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_NAME"), (Object)name, 0));
        }
        if (ipAddress != null) {
            Criteria childCriteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_NAME"), (Object)ipAddress, 0);
            childCriteria = childCriteria.or(new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_IPADDRESS"), (Object)ipAddress, 0));
            criteria = criteria.or(childCriteria);
        } else if (fqdn != null) {
            criteria = criteria.or(new Criteria(Column.getColumn((String)"Hosts", (String)"DNS_FULLNAME"), (Object)fqdn, 0));
        }
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("Hosts");
            tableList.add("HostDetails");
            dobj = PERSISTENCELITE.get(tableList, criteria);
        }
        catch (Exception exp) {
            LOGGER.info("Exception occurred while checkDeviceAvailablity , exception details : " + exp.getMessage());
        }
        return dobj;
    }

    private static HashMap<String, HashMap<String, String>> loadDomainDeviceExtendedDetails(String[] deviceList, Long domainID) {
        HashMap deviceDetailsMap = null;
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELADomainComputerDetails"));
        Criteria criteria = new Criteria(Column.getColumn((String)"ELADomainComputerDetails", (String)"NAME"), (Object)deviceList, 8);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"ELADomainComputerDetails", (String)"DOMAIN_ID"), (Object)domainID, 0));
        selectQuery.setCriteria(criteria);
        selectQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            deviceDetailsMap = new HashMap();
            Iterator itr = dobj.getRows("ELADomainComputerDetails");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                HashMap<String, String> details = new HashMap<String, String>();
                String osValue = row.get("OPERATINGSYSTEM") == null ? null : row.get("OPERATINGSYSTEM").toString();
                try {
                    Long osType = row.get("OS_TYPE") == null ? 2576L : Long.valueOf(row.get("OS_TYPE").toString());
                    if (osType == 2576L) {
                        osValue = osValue != null ? osValue + " WKS" : "WKS";
                    }
                }
                catch (Exception exp) {
                    LOGGER.info("Unable to find device OS type : " + row.get("NAME") + "   osValue : " + osValue);
                }
                details.put("OPERATINGSYSTEM", osValue);
                String dnsName = (String)row.get("DNS_NAME");
                if (dnsName != null) {
                    details.put("DNS_NAME", dnsName);
                }
                deviceDetailsMap.put(row.get("NAME").toString().toUpperCase(), details);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return deviceDetailsMap;
    }

    public static boolean checkAndADDLocalHost() {
        boolean status = false;
        ServerDetailsBean instance = ServerDetailsBean.getInstance();
        if (!instance.isWindows()) {
            return status;
        }
        try {
            InetAddress localhost = InetAddressHandler.getLocalHost();
            DeviceProperties properties = new DeviceProperties(localhost.getHostName());
            properties.setDeviceAddress(localhost.getHostAddress());
            String canonicalName = localhost.getCanonicalHostName();
            properties.setDeviceDisplayName(localhost.getHostName());
            properties.setDeviceDns_name(localhost.getHostName());
            properties.setDeviceFQDN(canonicalName);
            properties.setDeviceCategory(LogSourceCategoryContainer.DeviceCategory.WINDOWS);
            properties.setDeviceGroup(LogSourceCategoryContainer.DeviceCategory.WINDOWS.getDefaultGrouID());
            properties.setDeviceStatus(LogCollectionStatus.ENABLED);
            if (canonicalName != null && canonicalName.contains(".")) {
                String domainName = canonicalName.substring(canonicalName.indexOf(".") + 1, canonicalName.length());
                properties.setDeviceCredential(Credential.getCredential(null, null, domainName, null));
            }
            if (instance.getSystemOS() != null && instance.getSystemOS().contains("SERVER")) {
                properties.setDeviceType(instance.getSystemOS());
            } else {
                properties.setDeviceType(instance.getSystemOS() + " WKS");
            }
            if (!AddOrUpdateEventlogDevice.checkDeviceAvailablity(properties)) {
                AddOrUpdateEventlogDevice.addNewEventlogDevice(properties);
            }
            status = true;
        }
        catch (Exception exp) {
            LOGGER.info("Exception while adding device : " + exp.getMessage());
        }
        return status;
    }

    private static boolean finalizeResponseBuilder(ResponseBuilder responseBuilder, JSONObject invalidDevices) throws JSONException {
        boolean status = true;
        if (!invalidDevices.isNull("UNKNOW_DEVICE")) {
            status = false;
            responseBuilder.addKeyPair("UNKNOW_DEVICE", invalidDevices.getJSONArray("UNKNOW_DEVICE"));
        }
        if (!invalidDevices.isNull("DUPLICATE_DEVICE")) {
            status = false;
            responseBuilder.addKeyPair("DUPLICATE_DEVICE", invalidDevices.getJSONArray("DUPLICATE_DEVICE"));
        }
        return status;
    }
}

