/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.management;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.config.ports.ManageSyslogListenerPort;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import com.manageengine.ela.server.common.device.management.DeviceOperations;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.common.util.Credential;
import com.zoho.za.ns.discovery.NetworkDevice;
import com.zoho.za.ns.ip.IP;
import com.zoho.za.ns.syslog.SyslogDevice;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class AddOrUpdateSyslogDevice {
    private static final Logger LOGGER = Logger.getLogger(AddOrUpdateSyslogDevice.class.getName());
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();

    public static boolean addSysLogHostAfterDiscovery(JSONArray deviceDetails, JSONObject reqJsonObject, ResponseBuilder responseBuilder, UserAccessResource accessControl) {
        boolean status = false;
        try {
            LinkedBlockingDeque<IP> ipQueue = new LinkedBlockingDeque<IP>();
            ArrayList<String> ipList = new ArrayList<String>();
            String requestIpList = reqJsonObject.isNull("syslogIps") ? null : reqJsonObject.getString("syslogIps");
            ArrayList<JSONObject> selectedDevice = new ArrayList<JSONObject>(deviceDetails.length());
            JSONObject resultObj = new JSONObject();
            JSONArray unixip = new JSONArray();
            JSONArray unixHost = new JSONArray();
            JSONArray deviceList = new JSONArray();
            JSONArray unixids = new JSONArray();
            String[] array = requestIpList.split(",");
            for (int i = 0; i < array.length; ++i) {
                String deviceStr = array[i];
                ipQueue.add(new IP(deviceStr));
                ipList.add(deviceStr);
            }
            if (!ipList.isEmpty()) {
                JSONObject device;
                List validList = NetworkDevice.discover(ipQueue);
                HashMap allHostDetails = new HashMap();
                for (Map validHostDetail : validList) {
                    allHostDetails.put(validHostDetail.get("ip"), validHostDetail);
                }
                CharSequence[] IpArr = new String[ipList.size()];
                CharSequence[] TypeArr = new String[ipList.size()];
                CharSequence[] VendorArr = new String[ipList.size()];
                int count = 0;
                for (int i = 0; i < ipList.size(); ++i) {
                    String ip = (String)ipList.get(i);
                    device = deviceDetails.getJSONObject(i);
                    String hostName = "";
                    InetAddress inetAddress = DeviceUtil.resolveDNSForDevice(device.getString("NAME"));
                    hostName = inetAddress == null ? ip : inetAddress.getHostName();
                    Map hostDetail = (Map)allHostDetails.get(ip);
                    IpArr[count] = ip;
                    if (hostDetail != null) {
                        TypeArr[count] = (String)hostDetail.get("type");
                        VendorArr[count] = (String)hostDetail.get("vendor");
                    } else {
                        TypeArr[count] = "Unknown";
                        VendorArr[count] = "Unknown";
                    }
                    if (!(((String)VendorArr[count]).toLowerCase().contains("cisco") || ((String)VendorArr[count]).toLowerCase().contains("hypervisor") || ((String)VendorArr[count]).toLowerCase().contains("syslog"))) {
                        unixHost.put((Object)hostName);
                        unixip.put((Object)ip);
                    }
                    deviceList.put((Object)hostName);
                    ++count;
                }
                JSONObject hostListJsonObject = new JSONObject();
                hostListJsonObject.put("DEVICE_NAME", (Object)String.join((CharSequence)",", IpArr));
                hostListJsonObject.put("SYSLOG_PORT", ManageSyslogListenerPort.getDefaultPortPair().getPort());
                hostListJsonObject.put("SYSLOG_PROTOCOL", (Object)ManageSyslogListenerPort.getDefaultPortPair().getProtocol());
                hostListJsonObject.put("DEVICETYPELIST", (Object)String.join((CharSequence)",", TypeArr));
                hostListJsonObject.put("DEVICEVENDORLIST", (Object)String.join((CharSequence)",", VendorArr));
                hostListJsonObject.put("MONITORINTERVAL", 0);
                for (int index = 0; index < deviceDetails.length(); ++index) {
                    device = deviceDetails.getJSONObject(index);
                    CharSequence vendor = VendorArr[index];
                    if (((String)vendor).toLowerCase().contains("cisco")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.CISCO);
                    } else if (((String)vendor).toLowerCase().contains("hypervisor")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.ESXI);
                    } else if (((String)vendor).toLowerCase().contains("syslog")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.SYSLOG);
                    }
                    selectedDevice.add(device);
                }
                status = AddOrUpdateEventlogDevice.addValidDevice(new JSONArray(selectedDevice), hostListJsonObject, responseBuilder, accessControl);
                for (int i = 0; i < unixHost.length(); ++i) {
                    unixids.put((Object)AddOrUpdateSyslogDevice.findID(unixHost.getString(i)));
                }
                resultObj.put("unixList", (Object)unixip);
                resultObj.put("unixHost", (Object)unixHost);
                resultObj.put("unixIds", (Object)unixids);
                resultObj.put("deviceList", (Object)deviceList);
                responseBuilder.setStatus(resultObj);
            }
            return status;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return status;
        }
    }

    public static boolean updateSysLogHostList(JSONObject reqJsonObject, ResponseBuilder responseBuilder) {
        boolean result = false;
        JSONObject resultObj = new JSONObject();
        JSONArray successList = new JSONArray();
        JSONArray forwardFailureList = new JSONArray();
        JSONArray failureList = new JSONArray();
        int count = 0;
        try {
            Credential crd = Credential.getCredential(reqJsonObject);
            String user = crd.getUserName();
            String pass = crd.getPassword();
            Integer sshPort = reqJsonObject.isNull("sshport") ? 22 : Integer.valueOf(reqJsonObject.getString("sshport"));
            Integer sysLogPort = reqJsonObject.isNull("SYSLOG_PORT") ? ManageSyslogListenerPort.getDefaultPortPair().getPort() : Integer.valueOf(reqJsonObject.getString("SYSLOG_PORT")).intValue();
            String sysLogProtocol = reqJsonObject.isNull("SYSLOG_PROTOCOL") ? ManageSyslogListenerPort.getDefaultPortPair().getProtocol() : reqJsonObject.getString("SYSLOG_PROTOCOL");
            String[] ip = reqJsonObject.getString("syslogIps").split(",");
            String[] deviceIds = null;
            JSONObject deviceDetail = new JSONObject();
            deviceDetail.put("username", (Object)user);
            deviceDetail.put("password", (Object)pass);
            deviceDetail.put("sshPort", (Object)sshPort);
            deviceDetail.put("syslogPort", (Object)sysLogPort);
            deviceDetail.put("syslogProtocol", (Object)sysLogProtocol);
            if (!reqJsonObject.isNull("DEVICE_ID")) {
                deviceIds = reqJsonObject.getString("DEVICE_ID").split(",");
            }
            if (user != null && pass != null) {
                String hostAddress;
                String string = hostAddress = reqJsonObject.isNull("SERVER_IP") ? null : reqJsonObject.getString("SERVER_IP");
                if (hostAddress == null) {
                    try {
                        hostAddress = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (Exception ee) {
                        LOGGER.info("Exception while getting server ip address: " + ee.getMessage());
                        ee.printStackTrace();
                    }
                }
                for (count = 0; count < ip.length; ++count) {
                    String deviceStr = ip[count];
                    SyslogDevice device = new SyslogDevice(deviceStr, user, pass, sshPort.intValue());
                    String deviceID = deviceIds != null ? deviceIds[count] : AddOrUpdateSyslogDevice.findID(deviceStr);
                    deviceDetail.put("deviceName", (Object)deviceStr);
                    deviceDetail.put("deviceID", (Object)deviceID);
                    String[] deviceIdArray = new String[]{deviceID};
                    DeviceOperations.checkAndDisableLogForwarding(deviceIdArray);
                    if (device.connect()) {
                        if (hostAddress != null && device.enableLogForward(hostAddress, sysLogPort.intValue(), sysLogProtocol)) {
                            successList.put((Object)deviceStr);
                            AddOrUpdateSyslogDevice.updateSyslogDeviceTable(deviceDetail);
                        } else {
                            forwardFailureList.put((Object)deviceStr);
                        }
                        AddOrUpdateEventlogDevice.updateDevice(reqJsonObject, deviceIdArray);
                        device.disconnect();
                        continue;
                    }
                    failureList.put((Object)deviceStr);
                }
                resultObj.put("success", (Object)successList);
                resultObj.put("failure", (Object)failureList);
                resultObj.put("forwardfailure", (Object)forwardFailureList);
                if (!ManageSyslogListenerPort.isEnabledPort(sysLogProtocol, sysLogPort)) {
                    ManageSyslogListenerPort.setSyslogListenerPortStatus(sysLogProtocol, sysLogPort, true);
                }
            } else {
                return AddOrUpdateEventlogDevice.updateDevice(reqJsonObject, deviceIds);
            }
            responseBuilder.setStatus(resultObj);
            result = true;
        }
        catch (Exception ex) {
            try {
                String[] ip = reqJsonObject.getString("syslogIps").split(",");
                for (int i = count + 1; i < ip.length; ++i) {
                    failureList.put((Object)ip[i]);
                }
                resultObj.put("success", (Object)successList);
                resultObj.put("failure", (Object)failureList);
                responseBuilder.setStatus(resultObj);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            ex.printStackTrace();
            result = false;
        }
        return result;
    }

    private static void updateSyslogDeviceTable(JSONObject deviceDetail) {
        try {
            long deviceId = Long.parseLong((String)deviceDetail.get("deviceID"));
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"ZA_SYSLOG_DEVICES"));
            sql.addSelectColumn(Column.getColumn((String)"ZA_SYSLOG_DEVICES", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"ZA_SYSLOG_DEVICES", (String)"DEVICE_ID"), (Object)deviceId, 0);
            sql.setCriteria(crit);
            DataObject dObj = DataAccess.get((SelectQuery)sql);
            if (dObj.isEmpty()) {
                Row newRow = new Row("ZA_SYSLOG_DEVICES");
                newRow.set("DEVICE_ID", (Object)deviceId);
                newRow.set("DEVICE_NAME", deviceDetail.get("deviceName"));
                newRow.set("SSH_PORT", deviceDetail.get("sshPort"));
                newRow.set("USERNAME", deviceDetail.get("username"));
                newRow.set("PASSWORD", deviceDetail.get("password"));
                newRow.set("SYSLOG_PORT", deviceDetail.get("syslogPort"));
                newRow.set("SYSLOG_PROTOCOL", deviceDetail.get("syslogProtocol"));
                DataObject dataObject = PERSISTENCELITE.constructDataObject();
                dataObject.addRow(newRow);
                PERSISTENCELITE.add(dataObject);
            } else {
                Row updateRow = dObj.getFirstRow("ZA_SYSLOG_DEVICES");
                updateRow.set("SSH_PORT", deviceDetail.get("sshPort"));
                updateRow.set("USERNAME", deviceDetail.get("username"));
                updateRow.set("PASSWORD", deviceDetail.get("password"));
                updateRow.set("SYSLOG_PORT", deviceDetail.get("syslogPort"));
                updateRow.set("SYSLOG_PROTOCOL", deviceDetail.get("syslogProtocol"));
                dObj.updateRow(updateRow);
                DataAccess.update((DataObject)dObj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String findID(String displayName) {
        String result = "";
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        sql.addSelectColumn(Column.getColumn((String)"Hosts", (String)"*"));
        Criteria crit = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_IPADDRESS"), (Object)displayName, 0);
        sql.setCriteria(crit);
        try {
            DataObject dataObject = DataAccess.get((SelectQuery)sql);
            if (dataObject.isEmpty()) {
                sql.setCriteria(null);
                crit = new Criteria(Column.getColumn((String)"Hosts", (String)"DISPLAY_NAME"), (Object)displayName, 0);
                sql.setCriteria(crit);
                dataObject = DataAccess.get((SelectQuery)sql);
                Row row = dataObject.getFirstRow("Hosts");
                result = Long.toString((Long)row.get("HOST_ID"));
            } else {
                Row row = dataObject.getFirstRow("Hosts");
                result = Long.toString((Long)row.get("HOST_ID"));
            }
        }
        catch (Exception ex) {
            LOGGER.info("Exception occurred while getting HOSTID , exception details : " + ex.getMessage());
            ex.printStackTrace();
        }
        return result;
    }

    public static boolean addSysLogHostWithoutDiscovery(JSONArray deviceDetails, JSONObject reqJsonObject, ResponseBuilder responseBuilder, UserAccessResource accessControl) {
        boolean status = false;
        JSONArray unixids = new JSONArray();
        try {
            String[] VendorArr;
            ArrayList<JSONObject> selectedDevice = new ArrayList<JSONObject>(deviceDetails.length());
            String[] stringArray = VendorArr = reqJsonObject.isNull("DEVICEVENDORLIST") ? null : reqJsonObject.getString("DEVICEVENDORLIST").split(",");
            if (VendorArr != null) {
                JSONObject device;
                int index;
                for (index = 0; index < deviceDetails.length(); ++index) {
                    device = deviceDetails.getJSONObject(index);
                    String vendor = VendorArr[index];
                    if (vendor.toLowerCase().contains("cisco")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.CISCO);
                    } else if (vendor.toLowerCase().contains("hypervisor")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.ESXI);
                    } else if (vendor.toLowerCase().contains("syslog")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.SYSLOG);
                    } else if (vendor.toLowerCase().contains("palo") && vendor.toLowerCase().contains("alto")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.PALOALTO);
                    } else if (vendor.toLowerCase().contains("sonicwall")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.SONICWALL);
                    } else if (vendor.toLowerCase().contains("fortinet")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.FORTINET);
                    } else if (vendor.toLowerCase().contains("juniper")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.JUNIPER);
                    } else if (vendor.toLowerCase().contains("checkpoint")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.CHECKPOINT);
                    } else if (vendor.toLowerCase().contains("netscreen")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.NETSCREEN);
                    } else if (vendor.toLowerCase().contains("watchguard")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.WATCHGUARD);
                    } else if (vendor.toLowerCase().contains("cyberoam") || vendor.toLowerCase().contains("sophos")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.SOPHOS);
                    } else if (vendor.toLowerCase().contains("barracuda")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.BARRACUDA);
                    } else if (vendor.toLowerCase().contains("huawei")) {
                        device.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.HUAWEI);
                    }
                    selectedDevice.add(device);
                }
                reqJsonObject.put("SYSLOG_PORT", ManageSyslogListenerPort.getDefaultPortPair().getPort());
                reqJsonObject.put("SYSLOG_PROTOCOL", (Object)ManageSyslogListenerPort.getDefaultPortPair().getProtocol());
                status = AddOrUpdateEventlogDevice.addDevice(new JSONArray(selectedDevice), reqJsonObject, responseBuilder, accessControl, new boolean[0]);
                for (index = 0; index < deviceDetails.length(); ++index) {
                    device = deviceDetails.getJSONObject(index);
                    if (device.has("DEVICE_CATEGORY") && (LogSourceCategoryContainer.DeviceCategory)device.get("DEVICE_CATEGORY") != LogSourceCategoryContainer.DeviceCategory.UNIX) continue;
                    unixids.put((Object)AddOrUpdateSyslogDevice.findID(device.getString("NAME")));
                }
                responseBuilder.addKeyPair("unixIds", unixids);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    private static String[] getDefaultSyslogPorts() {
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"SyslogServers"));
        sql.addSelectColumn(Column.getColumn((String)"SyslogServers", (String)"*"));
        Criteria crit = new Criteria(Column.getColumn((String)"SyslogServers", (String)"PORTS"), (Object)"-", 1);
        sql.setCriteria(crit);
        try {
            DataObject dataObject = DataAccess.get((SelectQuery)sql);
            Row row = dataObject.getFirstRow("SyslogServers");
            String allport = (String)row.get("PORTS");
            int idx = allport.indexOf("-");
            if (idx < 0) {
                idx = allport.length();
            }
            String port = allport.substring(0, idx);
            return port.split(" ");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

