/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.management;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.device.DeviceProperties;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class AddWindowsDeviceListner {
    private static final Logger LOGGER = Logger.getLogger(AddWindowsDeviceListner.class.getName());

    public static void addLocalMachine() {
        AddOrUpdateEventlogDevice.checkAndADDLocalHost();
    }

    public static boolean addDiscoveredDomainControllers(JSONObject json, AtomicInteger count) throws Exception {
        if (json == null) {
            LOGGER.info("Requested domain is not valid");
            return false;
        }
        String domainName = json.getString("DOMAIN_NAME");
        LOGGER.info("Going to Configure Domain  : " + json);
        List domainControllers = ADSDomainHandler.getDCList((String)domainName);
        if (count.get() > 0) {
            AddWindowsDeviceListner.checkAndAddDCFromLocalDB(json, domainControllers, count);
        }
        LOGGER.info("Completed Initial Configuration based on discovered domaincontrollers,for the raised domain " + domainName);
        return true;
    }

    private static int checkAndAddDCFromLocalDB(JSONObject domainDetails, List<String> domainControllers, AtomicInteger count) throws JSONException {
        int processedDomainControllers = 0;
        long domainID = domainDetails.getLong("DOMAIN_ID");
        for (int index = 0; index < domainControllers.size() && count.get() > 0; ++index) {
            count.decrementAndGet();
            String dcOriginalNAME = domainControllers.get(index);
            String dcName = InetAddressHandler.getNameFromFQDN(dcOriginalNAME);
            DeviceProperties properties = new DeviceProperties(dcOriginalNAME);
            properties.setDeviceDisplayName(dcName);
            properties.setDeviceDns_name(dcName);
            properties.setDeviceFQDN(dcOriginalNAME);
            properties.setDeviceAddress(dcOriginalNAME);
            properties.setDeviceDomainID(domainID);
            properties.setDeviceType("Windows Server");
            properties.setDeviceCategory(LogSourceCategoryContainer.DeviceCategory.WINDOWS);
            properties.setDeviceGroup(LogSourceCategoryContainer.DeviceCategory.WINDOWS.getDefaultGrouID());
            properties.setDeviceSourceId(2);
            AddWindowsDeviceListner.checkAndAddDevice(properties);
            ++processedDomainControllers;
        }
        return processedDomainControllers;
    }

    public static int checkAndaddDiscoveredServers(JSONObject domainDetails, AtomicInteger count) throws JSONException {
        String domainName = domainDetails.getString("DOMAIN_NAME");
        LOGGER.info("Going to Configure Domain for servers : " + domainDetails);
        List domainControllers = ADSDomainHandler.getDCList((String)domainName);
        LOGGER.info("Going to Add " + count + "  devices from the discovered servers");
        int processedDomainControllers = 0;
        long domainID = domainDetails.getLong("DOMAIN_ID");
        String tableName = "ELADomainComputerDetails";
        Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_ID"), (Object)domainID, 0);
        Criteria notIN = new Criteria(Column.getColumn((String)tableName, (String)"NAME"), (Object)domainControllers.toArray(), 9);
        notIN = notIN.and(new Criteria(Column.getColumn((String)tableName, (String)"DNS_NAME"), (Object)domainControllers.toArray(), 9));
        criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OS_TYPE"), (Object)2561, 0));
        criteria = criteria.and(notIN);
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
        selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
        selectQuery.setCriteria(criteria);
        selectQuery.setRange(new Range(1, count.get()));
        Iterator itr = null;
        try {
            DataObject dobj = PersistenceDBUtil.getPersistenceLite().get((SelectQuery)selectQuery);
            itr = dobj.getRows(tableName);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            LOGGER.info("Unable to fetch data from dataBase for domain " + domainName);
            return 0;
        }
        while (itr.hasNext() && count.get() > 0) {
            count.decrementAndGet();
            Row row = (Row)itr.next();
            DeviceProperties properties = new DeviceProperties((String)row.get("NAME"));
            properties.setDeviceDisplayName((String)row.get("NAME"));
            properties.setDeviceDns_name((String)row.get("NAME"));
            properties.setDeviceFQDN((String)row.get("DNS_NAME"));
            properties.setDeviceType((String)row.get("OPERATINGSYSTEM"));
            properties.setDeviceAddress((String)row.get("NAME"));
            properties.setDeviceDomainID(domainID);
            properties.setDeviceCategory(LogSourceCategoryContainer.DeviceCategory.WINDOWS);
            properties.setDeviceGroup(LogSourceCategoryContainer.DeviceCategory.WINDOWS.getDefaultGrouID());
            properties.setDeviceSourceId(2);
            AddWindowsDeviceListner.checkAndAddDevice(properties);
            ++processedDomainControllers;
        }
        LOGGER.info("Initial configured count of Devices are configured Successfully , count : " + count);
        return processedDomainControllers;
    }

    private static boolean checkAndAddDevice(DeviceProperties properties) {
        boolean status = false;
        try {
            if (!AddOrUpdateEventlogDevice.checkDeviceAvailablity(properties)) {
                if (AddOrUpdateEventlogDevice.addNewEventlogDevice(properties)) {
                    LOGGER.info("Selected Domain Controller successfully Added, DCNAME " + properties.getDeviceName());
                } else {
                    LOGGER.info("Problem occurred while adding Selected Domain Controller, DCNAME " + properties.getDeviceName());
                }
            } else {
                LOGGER.info("Selected Domain Controller Already exists, DCNAME " + properties.getDeviceName());
            }
            status = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return status;
    }
}

