/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.management;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.AS400ScanThread;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.sa.server.util.HostDBHandler;
import com.adventnet.sa.server.util.InheritedHostHandler;
import com.adventnet.sym.winaccess.InstallAgentThread;
import com.adventnet.taskengine.Scheduler;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.device.LogCollectionStatus;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.monitors.WindowsDeviceIPMonitor;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.Priority;
import com.manageengine.ela.server.reports.converter.ReportConverter;
import com.zoho.za.ns.syslog.SyslogDevice;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.elasticsearch.common.Strings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceOperations {
    private static final Logger LOGGER = Logger.getLogger(DeviceOperations.class.getName());
    private static final Persistence PERSISTENCE = PersistenceDBUtil.getPersistence();
    public static HashSet<String> deviceTypeSet = new HashSet();

    public static JSONObject enableOrDisableDevice(Long[] deviceIds, int status, Locale locale) {
        JSONObject response_data = new JSONObject();
        try {
            String successKey = "eventlog.inheritedhost.status.message.success";
            StringBuffer response_text = new StringBuffer();
            Criteria parentCrit = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)deviceIds, 8);
            parentCrit = parentCrit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"LOG_COLLECTION_STATUS"), (Object)LogCollectionStatus.getStatus(status).getStatus(), 1));
            SelectQueryImpl deviceSql = new SelectQueryImpl(Table.getTable((String)"Hosts"));
            deviceSql.addSelectColumn(Column.getColumn(null, (String)"*"));
            deviceSql.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 1));
            deviceSql.addJoin(new Join("HostDetails", ADSDomainHandler.tableName, new String[]{"DOMAIN_ID"}, new String[]{"DOMAIN_ID"}, 1));
            deviceSql.addSortColumn(new SortColumn("Hosts", "HOST_NAME", true));
            Criteria ibmCrit = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.AS400.getCategoryName(), 0);
            Criteria inheritedCrit = new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)1, 0);
            Criteria inheritedOldCrit = new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)1, 0);
            inheritedOldCrit = inheritedOldCrit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SOURCE_PRODUCT"), null, 0));
            Criteria others = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.AS400.getCategoryName(), 1).and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)0, 0));
            deviceSql.setCriteria(parentCrit.and(ibmCrit));
            DataObject imbDevice = PERSISTENCE.get((SelectQuery)deviceSql);
            deviceSql.setCriteria(parentCrit.and(others));
            DataObject normalDevice = PERSISTENCE.get((SelectQuery)deviceSql);
            deviceSql.setCriteria(parentCrit.and(inheritedCrit));
            DataObject inheritedDevice = PERSISTENCE.get((SelectQuery)deviceSql);
            deviceSql.setCriteria(parentCrit.and(inheritedOldCrit));
            DataObject oldAdapRequest = PERSISTENCE.get((SelectQuery)deviceSql);
            if (!imbDevice.isEmpty()) {
                DeviceOperations.updateIBMDevices(imbDevice, status);
            }
            if (!normalDevice.isEmpty()) {
                DeviceOperations.updateOtherDevices(normalDevice, status, false);
            }
            if (!inheritedDevice.isEmpty()) {
                DeviceOperations.updateInheritedDevices(inheritedDevice, status, response_data);
            }
            if (!oldAdapRequest.isEmpty()) {
                LOGGER.info("WARNING : Request processed based on Old ADAP request  enableOrDisableDevice");
                DeviceOperations.updateOtherDevices(oldAdapRequest, status, true);
            }
            ResourceBundle bundle = ProductBundle.getInstance().getBundle(locale);
            if (response_data.length() == 0 || !response_data.has("ERROR")) {
                response_data.put("STATUS", true);
                response_text.append(bundle.getString(successKey));
            } else {
                response_data.put("STATUS", false);
                JSONArray array = response_data.getJSONArray("ERROR");
                for (int index = 0; index < array.length(); ++index) {
                    response_text = response_text.length() != 0 ? response_text.append(';').append(bundle.getString(array.getString(index))) : response_text.append(bundle.getString(array.getString(index)));
                }
            }
            response_data.put("STATUS_MESSAGE", (Object)response_text.toString());
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return response_data;
    }

    private static void updateInheritedDevices(DataObject inheritedDevice, Integer status, JSONObject response_data) throws JSONException {
        String error = null;
        try {
            error = InheritedHostHandler.inheritedHostBatchupdate(inheritedDevice, status);
        }
        catch (Exception exp) {
            LOGGER.info("Exception occurred in while updating device : " + exp.getMessage());
        }
        if (error != null) {
            response_data.put("ERROR", (Object)new JSONArray().put((Object)error));
        }
    }

    private static void updateOtherDevices(DataObject normalDevice, int status, boolean ... flag) throws Exception {
        Iterator itr = normalDevice.getRows("HostDetails");
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            HostDBHandler.updateHost(normalDevice, row, status, flag);
        }
        PERSISTENCE.update(normalDevice);
    }

    private static void updateIBMDevices(DataObject imbDevice, int status) throws Exception {
        Iterator itr = imbDevice.getRows("Hosts");
        while (itr.hasNext()) {
            Row hRow = (Row)itr.next();
            Long deviceID = (Long)hRow.get("HOST_ID");
            Row deviceDetails = imbDevice.getRow("HostDetails", new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceID, 0));
            String dns_name = (String)hRow.get("DNS_NAME");
            deviceDetails.set("LOG_COLLECTION_STATUS", (Object)status);
            if (status == 2) {
                ClockDaemon as400FetchTask = new ClockDaemon();
                as400FetchTask.executeAfterDelay(2000L, (Runnable)new AS400ScanThread(dns_name, deviceID));
            } else {
                DeviceOperations.handleIBMScheduleDetails(dns_name);
            }
            imbDevice.updateRow(deviceDetails);
        }
        PERSISTENCE.update(imbDevice);
    }

    private static void handleIBMScheduleDetails(String dns_name) throws Exception {
        String scheduleName = dns_name + "_AS400Schedule";
        SelectQueryImpl taskSql = new SelectQueryImpl(Table.getTable((String)"Task_Input"));
        taskSql.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"*"));
        taskSql.addSelectColumn(Column.getColumn((String)"Schedule", (String)"*"));
        taskSql.addJoin(new Join("Task_Input", "Schedule", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        taskSql.setCriteria(new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)scheduleName, 0));
        DataObject taskDO = PERSISTENCE.get((SelectQuery)taskSql);
        Iterator taskItr = taskDO.getRows("Task_Input");
        while (taskItr.hasNext()) {
            Row taskRow = (Row)taskItr.next();
            int admin_status = (Integer)taskRow.get("ADMIN_STATUS");
            long instance_id = (Long)taskRow.get("INSTANCE_ID");
            Scheduler dbScheduler = (Scheduler)BeanUtil.lookup((String)"Scheduler");
            if (3 == admin_status) {
                dbScheduler.setTaskInputAdminStatus(instance_id, 4);
                continue;
            }
            if (4 != admin_status) continue;
            dbScheduler.setTaskInputAdminStatus(instance_id, 3);
        }
    }

    public static boolean deleteDevice(String deviceIds, Long userID) throws Exception {
        Object[] deviceIdArray = Strings.splitStringByCommaToArray((String)deviceIds);
        if (!DeviceOperations.checkisAdapDevicePresent(deviceIdArray)) {
            DeviceOperations.checkAndDisableLogForwarding((String[])deviceIdArray);
            HostDBHandler.deleteSLUpdateServiceID((String[])deviceIdArray);
            DeviceOperations.deleteDeviceDetails(HostDBHandler.getDeleteDataObject(deviceIds, new boolean[0]));
            DBUtil.deleteExistingRows("LogCollectionAlert", new Criteria(Column.getColumn((String)"LogCollectionAlert", (String)"HOST_ID"), (Object)deviceIdArray, 8), new boolean[0]);
            for (int i = 0; i < deviceIdArray.length; ++i) {
                ReportConverter.removeDisplayNameCache(Long.parseLong((String)deviceIdArray[i]));
            }
        } else {
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
        UserAccessResource.removeAllCache();
        return true;
    }

    public static void checkAndDisableLogForwarding(String[] deviceIdArray) {
        block10: {
            Criteria criteria = new Criteria(Column.getColumn((String)"ZA_SYSLOG_DEVICES", (String)"DEVICE_ID"), (Object)deviceIdArray, 8);
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"ZA_SYSLOG_DEVICES"));
            sql.addSelectColumn(Column.getColumn((String)"ZA_SYSLOG_DEVICES", (String)"*"));
            sql.setCriteria(criteria);
            try {
                DataObject dataObject = DataAccess.get((SelectQuery)sql);
                if (dataObject == null) break block10;
                String hostAddress = null;
                try {
                    Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                    while (networkInterfaces.hasMoreElements()) {
                        NetworkInterface ni = networkInterfaces.nextElement();
                        Enumeration<InetAddress> nias = ni.getInetAddresses();
                        while (nias.hasMoreElements()) {
                            InetAddress ia = nias.nextElement();
                            if (ia.isLinkLocalAddress() || ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                            hostAddress = ia.getLocalHost().getHostAddress();
                        }
                    }
                }
                catch (Exception ee) {
                    LOGGER.info("Exception while getting server ip address: " + ee.getMessage());
                    ee.printStackTrace();
                }
                Iterator rows = dataObject.getRows("ZA_SYSLOG_DEVICES");
                while (rows.hasNext()) {
                    Row row = (Row)rows.next();
                    String user = (String)row.get("USERNAME");
                    String pass = (String)row.get("PASSWORD");
                    Integer sshPort = (Integer)row.get("SSH_PORT");
                    Integer syslogPort = (Integer)row.get("SYSLOG_PORT");
                    String syslogProtocol = (String)row.get("SYSLOG_PROTOCOL");
                    String deviceName = (String)row.get("DEVICE_NAME");
                    SyslogDevice device = new SyslogDevice(deviceName, user, pass, sshPort.intValue());
                    if (device.connect()) {
                        if (hostAddress != null && device.disableLogForward(hostAddress, syslogPort.intValue())) {
                            LOGGER.info("Device log forwarding is stopped");
                        } else {
                            LOGGER.info("WARNING : Device log forwarding is not stopped for device = " + deviceName + " with ssh port =" + sshPort);
                        }
                        device.disconnect();
                        continue;
                    }
                    LOGGER.info("WARNING : Device cannot be connected so log forwarding is not stopped. device name = " + deviceName + " with ssh port =" + sshPort);
                }
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean checkisAdapDevicePresent(Object[] deviceIdArray) {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceIdArray, 8);
        return DBUtil.getCountInt("HostDetails", criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)1L, 0))) > 0;
    }

    public static boolean deleteDevice(Long[] deviceIds, Long userID) throws Exception {
        if (!DeviceOperations.checkisAdapDevicePresent(deviceIds)) {
            HostDBHandler.deleteSLUpdateServiceID(deviceIds);
            DeviceOperations.deleteDeviceDetails(HostDBHandler.getDeleteDataObject(deviceIds, new boolean[0]));
            DBUtil.deleteExistingRows("LogCollectionAlert", new Criteria(Column.getColumn((String)"LogCollectionAlert", (String)"HOST_ID"), (Object)deviceIds, 8), new boolean[0]);
            for (int i = 0; i < deviceIds.length; ++i) {
                ReportConverter.removeDisplayNameCache(deviceIds[i]);
            }
        } else {
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
        UserAccessResource.removeAllCache();
        return true;
    }

    public static boolean deleteDeviceDetails(DataObject deivceDO) throws Exception {
        Iterator deviceItr = deivceDO.getRows("Hosts");
        while (deviceItr.hasNext()) {
            String deviceType;
            Row deviceRow = (Row)deviceItr.next();
            String dns_name = (String)deviceRow.get("DNS_NAME");
            Long deviceId = (Long)deviceRow.get("HOST_ID");
            Row deviceDetailsRow = deivceDO.getRow("HostDetails", new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceId, 0));
            Long slid = (Long)deviceDetailsRow.get("SLID");
            Row slRow = deivceDO.getRow("SyslogServers", new Criteria(Column.getColumn((String)"SyslogServers", (String)"SLID"), (Object)slid, 0));
            if (slRow != null && "-".equals((String)slRow.get("PORTS"))) {
                HashMap agentDetails = new HashMap();
                HostDBHandler.populateAgentDetails(agentDetails, slid, deviceDetailsRow, slRow);
                HostDBHandler.updateAgentSLId(slid, ServerDetailsBean.getInstance().getSysEvtColID(), "HOSTDELETE");
                InstallAgentThread uninstallAgent = new InstallAgentThread(agentDetails, false);
                uninstallAgent.start();
                DBUtil.deleteRow(slRow, new boolean[0]);
            }
            if ("IBM AS/400".equals(deviceType = (String)deviceDetailsRow.get("TYPE"))) {
                DataAccess.delete((String)"Schedule", (Criteria)new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)(dns_name + "_AS400Schedule"), 0));
            }
            HostDBHandler.deleteNotifications(deviceId, dns_name);
            HostDBHandler.deleteFilters(dns_name, deviceId);
            HostDBHandler.deleteApplicationsEnteries(deviceId);
            HostDBHandler.deleteAddOnEnteries(dns_name, deviceId);
            HostDBHandler.deleteHostArchiveEntries(deviceId, dns_name);
            DBUtil.deleteRow(deviceRow, new boolean[0]);
            HostDBHandler.slupdateForDelete(slid, deviceId);
        }
        HostDBHandler.synchronizeNow("Delete Device", true);
        DeviceOperations.updateDeviceTypeSet();
        return true;
    }

    public static void pingDevices(Long[] hostIds) {
        WindowsDeviceIPMonitor monitor = WindowsDeviceIPMonitor.getInstance();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)hostIds, 8);
            DataBaseReqestProcessor.executeUpdateQuery("HostDetails", "LOG_COLLECTION_STATUS", LogCollectionStatus.PING.getStatus(), criteria, new boolean[0]);
            DataObject devices = PersistenceDBUtil.getPersistence().get("HostDetails", criteria);
            Iterator deviceItr = devices.getRows("HostDetails");
            while (deviceItr.hasNext()) {
                Row deviceDetails = (Row)deviceItr.next();
                Long deviceId = (Long)deviceDetails.get("HOST_ID");
                monitor.add(deviceId, Priority.HIGH);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDeviceTypeSet() {
        if (deviceTypeSet.isEmpty()) {
            Connection con = null;
            DataSet ds = null;
            try {
                Table hostDetailsTable = Table.getTable((String)"HostDetails");
                SelectQueryImpl sQuery = new SelectQueryImpl(hostDetailsTable);
                Column typeColumn = Column.getColumn((String)"HostDetails", (String)"TYPE").distinct();
                typeColumn.setColumnAlias("type");
                sQuery.addSelectColumn(typeColumn);
                RelationalAPI relapi = RelationalAPI.getInstance();
                con = relapi.getConnection();
                ds = relapi.executeQuery((Query)sQuery, con);
                while (ds.next()) {
                    deviceTypeSet.add(((String)ds.getValue("type")).toLowerCase());
                }
                LOGGER.fine("deviceTypeSet at end of initDeviceTypeSet : " + deviceTypeSet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (ds != null) {
                    try {
                        ds.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void updateDeviceTypeSet() {
        deviceTypeSet.clear();
        DeviceOperations.initDeviceTypeSet();
    }
}

