/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.management;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.SQLGenerator;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.persistence.xml.Xml2DoConverter;
import com.adventnet.sa.server.AS400ScanThread;
import com.adventnet.sa.server.ELSInitializer;
import com.adventnet.sa.server.util.HostDBHandler;
import com.manageengine.ela.server.common.device.DeviceProperties;
import com.manageengine.ela.server.common.device.LogSourceCategory;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.executors.processor.extended.CommonFixedThreadExecutor;
import com.manageengine.ela.server.common.executors.queue.priority.PriorityQueueFieldRunnable;
import com.manageengine.ela.server.common.util.Priority;
import java.io.File;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtendedDeviceActions {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final Logger LOGGER = Logger.getLogger(ExtendedDeviceActions.class.getName());
    private static final String[] PREDEFINED_LOGTYPES = new String[]{"Application", "Security", "System", "Setup"};

    static void handlPostAS400Setup(DeviceProperties properties) throws Exception {
        ExtendedDeviceActions.addAS400Schedule(properties.getDeviceDns_name() + "_AS400Schedule", properties.getMonitorInterval());
        new ClockDaemon().executeAfterDelay(2000L, (Runnable)new AS400ScanThread(properties.getDeviceDns_name(), properties.getDeviceID()));
    }

    static void handlepostDelayedActions(final List<DeviceProperties> properties, boolean isDelayedPostAction) {
        if (!isDelayedPostAction) {
            ExtendedDeviceActions.startPostDelayedAction(properties);
        } else {
            CommonFixedThreadExecutor.getInstance().execute(new PriorityQueueFieldRunnable(Priority.LOW){

                @Override
                public void run() {
                    ExtendedDeviceActions.startPostDelayedAction(properties);
                }
            });
        }
    }

    static void startPostDelayedAction(List<DeviceProperties> properties) {
        for (DeviceProperties data : properties) {
            try {
                ExtendedDeviceActions.handlePostDeviceSetup(data);
                HostDBHandler.addLogCollectionEntry(data.getDeviceID(), (Long)data.getDeviceGroup());
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    static void handlePostDeviceSetup(DeviceProperties properties) {
        long time = System.currentTimeMillis();
        try {
            if (Boolean.parseBoolean(System.getProperty("SysLog.addProfile", "true"))) {
                ExtendedDeviceActions.configureDeviceDefaultProfile(properties.getDeviceID(), properties.getDeviceDns_name(), properties.getDeviceCategory());
            }
            if (Boolean.parseBoolean(System.getProperty("SysLog.addAlert", "false"))) {
                ExtendedDeviceActions.addDefaultAlert(properties.getDeviceDns_name(), properties.getDeviceID(), properties.getDeviceCategory().getCategoryName(), properties.getUserID());
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "WARNING: Exception while adding default Profile for Host {0}", properties.getDeviceDns_name());
            exp.printStackTrace();
        }
        LOGGER.info("Time taken for PostDeviceSetup : " + (System.currentTimeMillis() - time));
    }

    public static void populateWindowsPredefinedLogtypes(DeviceProperties properties) {
        HashMap<String, Boolean> logtypeDetails = new HashMap<String, Boolean>();
        for (String logtype : PREDEFINED_LOGTYPES) {
            logtypeDetails.put(logtype, Boolean.TRUE);
        }
        ELSInitializer.createPredefinedWindowsLogtypes(properties.getDeviceID(), properties.getLastScanTime(), logtypeDetails);
    }

    private static void addDefaultAlert(String deviceDns_name, Long deviceID, String deviceCategory, Long userID) throws Exception {
        Table table = Table.getTable((String)"NotfnConfiguration");
        SelectQueryImpl sql = new SelectQueryImpl(table);
        sql.addSelectColumn(Column.getColumn((String)"NotfnConfiguration", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"LACriteria", (String)"*"));
        Join join = new Join(table, Table.getTable((String)"LACriteria"), new String[]{"NOTIFID"}, new String[]{"CRIT_ID"}, 2);
        Criteria crt = null;
        crt = "WINDOWS".equalsIgnoreCase(deviceCategory) ? new Criteria(Column.getColumn((String)"LACriteria", (String)"CRITERIA_NAME"), (Object)"Audit logs cleared", 0).or(new Criteria(Column.getColumn((String)"LACriteria", (String)"CRITERIA_NAME"), (Object)"Failed Logins", 0)) : new Criteria(Column.getColumn((String)"LACriteria", (String)"CRITERIA_NAME"), (Object)"Failed Logins", 0);
        sql.addJoin(join);
        sql.setCriteria(crt);
        LOGGER.log(Level.FINER, " getAlert : SelectQuery is ----->  {0}", sql);
        DataObject dataObject = PERSISTENCELITE.get((SelectQuery)sql);
        LOGGER.log(Level.FINER, "AddHost DEBUG: DataObject obtained is ------------>  {0}", dataObject);
        LOGGER.log(Level.FINER, "AddHost DEBUG: DataObject obtained is ------------>  ");
        String email = DeviceUtil.getTechnicianEmail(userID);
        Iterator itr = dataObject.getRows("NotfnConfiguration");
        while (itr.hasNext()) {
            Row nc = (Row)itr.next();
            Row hNotif = new Row("HostNotification");
            hNotif.set("HOSTID", (Object)deviceID);
            hNotif.set("NOTIFID", nc.get("NOTIFID"));
            nc.set("MAILID", (Object)email);
            dataObject.updateRow(nc);
            dataObject.addRow(hNotif);
        }
        LOGGER.log(Level.FINER, " AddHost in default alert conf : {0} Saved DO : \n\n", dataObject);
        PERSISTENCELITE.update(dataObject);
    }

    private static void addAS400Schedule(String scheduleName, Long time_period) throws Exception {
        DataObject scheduleDO = PERSISTENCELITE.constructDataObject();
        Row scheduleRow = new Row("Schedule");
        scheduleRow.set("SCHEDULE_NAME", (Object)scheduleName);
        scheduleDO.addRow(scheduleRow);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Row periodicRow = new Row("Periodic");
        periodicRow.set("SCHEDULE_ID", scheduleRow.get("SCHEDULE_ID"));
        periodicRow.set("START_DATE", (Object)timestamp);
        periodicRow.set("TIME_PERIOD", (Object)new Long(time_period));
        periodicRow.set("UNIT_OF_TIME", (Object)"minutes");
        scheduleDO.addRow(periodicRow);
        long scheduleID = DeviceUtil.getScheduler().createSchedule(scheduleDO);
        WritableDataObject taskInputDO = new WritableDataObject();
        Row taskInputRow = new Row("Task_Input");
        taskInputRow.set("SCHEDULE_ID", (Object)new Long(scheduleID));
        taskInputDO.addRow(taskInputRow);
        String task_Name = "AS400WorkFlow";
        Long taskID = DeviceUtil.getTaskID(task_Name);
        Row scheduledTaskRow = new Row("Scheduled_Task");
        scheduledTaskRow.set("SCHEDULE_ID", (Object)scheduleID);
        scheduledTaskRow.set("TASK_ID", (Object)taskID);
        scheduledTaskRow.set("TRANSACTION_TIME", (Object)new Integer(Integer.parseInt(System.getProperty("ReportTimeOut", "1500"))));
        scheduleDO.addRow(scheduledTaskRow);
        PERSISTENCELITE.update(scheduleDO);
        DeviceUtil.getScheduler().scheduleTask(scheduleName, task_Name, (DataObject)taskInputDO, 1, 5);
        LOGGER.log(Level.FINER, "TaskDO ::::::::: {0}", taskInputDO);
        LOGGER.log(Level.INFO, "The {0} sucessfully added", new Object[]{scheduleName});
    }

    public static synchronized Long getConfigureDeviceDefaultProfile(Long deviceID) throws Exception {
        DataObject deviceDetails = DeviceUtil.getDeviceDetailsDO(deviceID, Arrays.asList("DNS_NAME"), Arrays.asList("TYPE"));
        String dnsName = (String)deviceDetails.getFirstValue("Hosts", "DNS_NAME");
        String type = (String)deviceDetails.getFirstValue("HostDetails", "TYPE");
        return ExtendedDeviceActions.configureDeviceDefaultProfile(deviceID, dnsName, LogSourceCategoryContainer.DeviceCategory.getCategory(type));
    }

    public static synchronized Long getConfigureDeviceDefaultProfile(Long deviceID, String rName, String type) throws Exception {
        return ExtendedDeviceActions.configureDeviceDefaultProfile(deviceID, rName, LogSourceCategoryContainer.DeviceCategory.getCategory(type));
    }

    private static synchronized Long configureDeviceDefaultProfile(Long deviceID, String rName, LogSourceCategory logSourceCategory) throws Exception {
        try {
            DataObject obj = PERSISTENCELITE.get("ReportConfig", new Criteria(Column.getColumn((String)"ReportConfig", (String)"PROFILENAME"), (Object)(rName + "_Profile"), 0));
            if (!obj.isEmpty()) {
                return (Long)obj.getFirstValue("ReportConfig", "REPORTID");
            }
        }
        catch (Exception obj) {
            // empty catch block
        }
        File file = new File(System.getProperty("server.home") + File.separator + "conf" + File.separator + "EventLogAnalyzer" + File.separator + "syslog-profiles.xml");
        URL url = file.toURI().toURL();
        DataObject object = Xml2DoConverter.transform((URL)url, (boolean)false);
        Iterator itr = object.getRows("ReportConfig");
        while (itr.hasNext()) {
            Row rc = (Row)itr.next();
            String profileName = (String)rc.get("PROFILENAME");
            rc.set("PROFILENAME", (Object)(rName + profileName));
            rc.set("CREATED_ON", (Object)ExtendedDeviceActions.getTime());
            object.updateRow(rc);
            Row rpt2Hosts = new Row("Hosts2ReportConfig");
            rpt2Hosts.set("HOST_ID", (Object)deviceID);
            rpt2Hosts.set("REPORTID", rc.get("REPORTID"));
            rpt2Hosts.set("TYPE", (Object)"Host");
            object.addRow(rpt2Hosts);
            Row fRow = new Row("Filters");
            Row rfRow = new Row("ReportConfigToFilters");
            rfRow.set("TYPE", (Object)"Include");
            rfRow.set("REPORTID", rc.get("REPORTID"));
            String rbbgList = null;
            if (logSourceCategory == LogSourceCategoryContainer.DeviceCategory.WINDOWS) {
                fRow.set("FILTERNAME", (Object)(rName + profileName + "_EvtTime"));
                rfRow.set("FILTERNAME", (Object)(rName + profileName + "_EvtTime"));
                rbbgList = "Windows Custom Reports";
            } else {
                fRow.set("FILTERNAME", (Object)(rName + profileName + "_SysTime"));
                rfRow.set("FILTERNAME", (Object)(rName + profileName + "_SysTime"));
                rbbgList = "Unix Reports";
            }
            object.addRow(fRow);
            object.addRow(rfRow);
            ExtendedDeviceActions.addRBBGIDMapping(rc.get("REPORTID"), object, rbbgList);
        }
        DataObject saved = PERSISTENCELITE.update(object);
        Long reportID = (Long)saved.getFirstValue("ReportConfig", "REPORTID");
        LOGGER.log(Level.FINER, " Report ID : {0} Saved DO : \n\n{1}", new Object[]{reportID, saved});
        HashMap map = new HashMap();
        SQLGenerator sqlGen = new SQLGenerator(reportID, map);
        sqlGen.generate();
        return reportID;
    }

    private static void addRBBGIDMapping(Object reportId, DataObject dobj, String rbbgList) throws Exception {
        StringTokenizer st = new StringTokenizer(rbbgList, ",");
        Criteria base = null;
        while (st.hasMoreTokens()) {
            String rbbgname = st.nextToken();
            Criteria crt = new Criteria(Column.getColumn((String)"ReportBuildingBlockGroup", (String)"RBBGNAME"), (Object)rbbgname, 0);
            if (base == null) {
                base = crt;
                continue;
            }
            base = base.or(crt);
        }
        DataObject doo = PERSISTENCELITE.get("ReportBuildingBlockGroup", base);
        Iterator it = doo.getRows("ReportBuildingBlockGroup");
        while (it.hasNext()) {
            Long rbbgid = (Long)((Row)it.next()).get("RBBGID");
            Row r = new Row("ReportConfigToRBBGMapping");
            r.set("REPORTID", reportId);
            r.set("RBBGID", (Object)rbbgid);
            dobj.addRow(r);
        }
    }

    private static String getTime() {
        String pattern = "MM/dd/yyyy- HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(new Date());
    }
}

