/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.management.ember;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.ember.datasource.DefaultDataSource;
import com.manageengine.ela.server.common.handlers.domain.DomainHandler;
import com.manageengine.ela.server.common.handlers.workgroup.WorkgroupHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.Credential;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import org.json.JSONObject;

public class DeviceDataSource {
    public static JSONObject getDeviceDetails(Long deviceID, ArrayList<Column> columnArrayList) throws Exception {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"HostDetails"));
        selectQuery.addJoin(new Join("HostDetails", "Hosts", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceID, 0);
        selectQuery.setCriteria(criteria);
        ArrayList<Column> columnList = new ArrayList<Column>();
        columnList.add(Column.getColumn((String)"HostDetails", (String)"HOST_ID"));
        if (columnArrayList == null) {
            columnList.add(Column.getColumn((String)"HostDetails", (String)"TYPE"));
            columnList.add(Column.getColumn((String)"Hosts", (String)"DNS_NAME"));
            columnList.add(Column.getColumn((String)"Hosts", (String)"DISPLAY_NAME"));
            columnList.add(Column.getColumn((String)"Hosts", (String)"HOST_IPADDRESS"));
            columnList.add(Column.getColumn((String)"HostDetails", (String)"DOMAIN_NAME"));
            columnList.add(Column.getColumn((String)"HostDetails", (String)"USERNAME"));
            columnList.add(Column.getColumn((String)"HostDetails", (String)"MON_INTERVAL"));
            columnList.add(Column.getColumn((String)"HostDetails", (String)"SYSLOG_PORT"));
            columnList.add(Column.getColumn((String)"HostDetails", (String)"SYSLOG_PROTOCOL"));
            columnList.add(Column.getColumn((String)"HostDetails", (String)"DOMAIN_ID"));
            columnList.add(Column.getColumn((String)"HostDetails", (String)"IMAGE"));
            columnList.add(Column.getColumn((String)"HostDetails", (String)"ENABLESSL"));
            columnList.add(Column.getColumn((String)"HostDetails", (String)"WORKGROUP_ID"));
            columnList.add(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"));
        } else {
            columnList.addAll(columnArrayList);
        }
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), true));
        selectQuery.addSelectColumns(columnList);
        LinkedList<HashMap<Column, Object>> result = DefaultDataSource.getRows((SelectQuery)selectQuery, 0, 1);
        JSONObject deviceDetails = new JSONObject();
        if (result.size() > 0) {
            HashMap<Column, Object> hashMap = result.getFirst();
            Column type_colName = Column.getColumn((String)"HostDetails", (String)"TYPE");
            Object type = hashMap.get(type_colName);
            Object domainID = hashMap.get(Column.getColumn((String)"HostDetails", (String)"DOMAIN_ID"));
            Object workgroupID = hashMap.get(Column.getColumn((String)"HostDetails", (String)"WORKGROUP_ID"));
            Column userNameColumn = Column.getColumn((String)"HostDetails", (String)"USERNAME");
            Object defaultUserName = hashMap.get(userNameColumn);
            Object defaultDomainName = hashMap.get(Column.getColumn((String)"HostDetails", (String)"DOMAIN_NAME"));
            LogSourceCategoryContainer.DeviceCategory category = LogSourceCategoryContainer.DeviceCategory.getCategory(type.toString());
            if (category == LogSourceCategoryContainer.DeviceCategory.UNKNOWN) {
                hashMap.put(type_colName, LogSourceCategoryContainer.DeviceCategory.UNKNOWNCATEGORY.getCategoryName());
            }
            deviceDetails.put("IS_DEFAULT_AUTHENTICATION", defaultUserName != null);
            try {
                if (defaultDomainName != null && defaultUserName != null && category != LogSourceCategoryContainer.DeviceCategory.AS400) {
                    Credential crd = Credential.getCredential(defaultUserName.toString(), null, defaultDomainName.toString(), null);
                    crd.resolveDomainAndUserName();
                    hashMap.put(userNameColumn, crd.getUserNameWithDomain());
                }
                if (domainID != null) {
                    String userName;
                    JSONObject domainDetails = DomainHandler.getDomainDetailsJSON(Long.parseLong(domainID.toString()));
                    String string = userName = domainDetails.isNull("USER_NAME") ? null : domainDetails.getString("USER_NAME");
                    if (userName != null && !userName.contains("@") && !userName.contains("\\")) {
                        userName = domainDetails.getString("DOMAIN_FLAT_NAME") + "\\" + userName;
                        domainDetails.put("USER_NAME", (Object)userName);
                    }
                    deviceDetails.put("DOMAIN_DETAILS", (Object)domainDetails);
                } else if (workgroupID != null) {
                    JSONObject workGroupDetails = WorkgroupHandler.getWorkgroupDetails(Long.valueOf(workgroupID.toString()));
                    deviceDetails.put("WORKGROUP_DETAILS", (Object)workGroupDetails);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            Set<Column> keySet = hashMap.keySet();
            for (Column column : keySet) {
                deviceDetails.put(column.getColumnName(), hashMap.get(column));
            }
        } else {
            throw BaseStatusCode.getBaseStatusCode(7940);
        }
        return deviceDetails;
    }
}

