/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.management.ember;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.sa.server.util.DBUtil;
import java.sql.Connection;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class FilterDataSource {
    private static final Logger LOGGER = Logger.getLogger(FilterDataSource.class.getName());
    private static final int MAX_OULIST = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getOUFilterList(String parentOUName, long domainID) throws Exception {
        long time = System.currentTimeMillis();
        String derivedColumn = "OBJECTROOT_DN_DERIVED";
        int extimatedLength = "ELAOuContainerGeneralDetails".length() + 2;
        String tableAliasOne = new StringBuilder(extimatedLength).append("ELAOuContainerGeneralDetails").append("_").append("1").toString();
        String tableAliastwo = new StringBuilder(extimatedLength).append("ELAOuContainerGeneralDetails").append("_").append("2").toString();
        Table tableOne = Table.getTable((String)"ELAOuContainerGeneralDetails", (String)tableAliasOne);
        Table tableTwo = Table.getTable((String)"ELAOuContainerGeneralDetails", (String)tableAliastwo);
        SelectQueryImpl selectQuery = new SelectQueryImpl(tableOne);
        selectQuery.addSelectColumn(Column.getColumn((String)tableAliasOne, (String)"NAME").distinct());
        selectQuery.addSelectColumn(Column.getColumn((String)tableAliasOne, (String)"OBJECTROOT_DN"));
        selectQuery.addSelectColumn(Column.getColumn((String)tableAliasOne, (String)"DISTINGUISHEDNAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)tableAliastwo, (String)"OBJECTROOT_DN", (String)derivedColumn));
        selectQuery.addJoin(new Join(tableOne, tableTwo, new String[]{"DISTINGUISHEDNAME"}, new String[]{"OBJECTROOT_DN"}, 1));
        Criteria criteria = new Criteria(Column.getColumn((String)tableAliasOne, (String)"DOMAIN_ID"), (Object)domainID, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)tableAliasOne, (String)"OBJECTROOT_DN"), (Object)parentOUName, 0));
        selectQuery.setCriteria(criteria);
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)tableAliasOne, (String)"NAME"), true));
        selectQuery.setRange(new Range(0, 2000));
        Connection con = null;
        DataSet totalOU = null;
        JSONArray resultJsonArray = new JSONArray();
        try {
            con = RelationalAPI.getInstance().getConnection();
            totalOU = RelationalAPI.getInstance().executeQuery((Query)selectQuery, con);
            while (totalOU.next()) {
                JSONObject eachOU = new JSONObject();
                eachOU.put("OU_NAME", totalOU.getValue(1));
                eachOU.put("DISTINGUISHED_NAME", totalOU.getValue(3));
                eachOU.put("HAS_CHILD", totalOU.getValue(4) != null);
                resultJsonArray.put((Object)eachOU);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSetOrDataSet(null, totalOU);
            DBUtil.closeStmtAndConnection(null, con);
            throw throwable;
        }
        DBUtil.closeResultSetOrDataSet(null, totalOU);
        DBUtil.closeStmtAndConnection(null, con);
        LOGGER.fine("Total time taken in OUFilter tree : " + (System.currentTimeMillis() - time));
        return resultJsonArray;
    }

    private static Criteria getCountCriteria(Long parentOUHash, long domainID) {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAOuContainerGeneralDetails", (String)"DOMAIN_ID"), (Object)domainID, 0);
        return criteria.and(new Criteria(Column.getColumn((String)"ELAOuContainerGeneralDetails", (String)"OBJECTROOT_DN_HASHCODE"), (Object)parentOUHash, 0));
    }
}

