/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.monitors;

import com.manageengine.ela.server.common.device.monitors.WindowsDeviceIPValidator;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.common.executors.queue.priority.PriorityQueueField;
import com.manageengine.ela.server.common.util.Priority;
import java.util.concurrent.PriorityBlockingQueue;

public class WindowsDeviceIPMonitor {
    private static final int MAX_THREADS = 2;
    private static WindowsDeviceIPMonitor instance = null;
    private ConcurrentQueue<PriorityQueueField<Long>> queue = new CommonQueueImpl<PriorityQueueField<Long>>(new PriorityBlockingQueue());

    private WindowsDeviceIPMonitor(int maxThreads) {
        WindowsDeviceIPValidator processor = new WindowsDeviceIPValidator(this.queue);
        for (int threads = 0; threads < 2; ++threads) {
            Thread thread = processor.start();
            thread.setName("EventlogIPMonitor-" + threads);
        }
    }

    public static WindowsDeviceIPMonitor getInstance() {
        if (instance == null) {
            instance = new WindowsDeviceIPMonitor(2);
        }
        return instance;
    }

    public void add(Long data) throws Exception {
        PriorityQueueField<Long> entry = new PriorityQueueField<Long>(data);
        if (!this.queue.contains(entry)) {
            this.queue.add(entry);
        }
    }

    public void add(Long data, Priority priority) throws Exception {
        PriorityQueueField<Long> entry = new PriorityQueueField<Long>(data, priority);
        if (!this.queue.contains(entry)) {
            this.queue.add(entry);
        }
    }
}

