/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.monitors;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ela.server.common.device.LogCollectionStatus;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.executors.processor.CommonQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.common.executors.queue.priority.PriorityQueueField;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;

public class WindowsDeviceIPValidator
extends CommonQueueProcessor<PriorityQueueField<Long>> {
    private static final Logger LOGGER = Logger.getLogger(WindowsDeviceIPValidator.class.getName());
    private static final Persistence PERSISTANCE_LITE = PersistenceDBUtil.getPersistenceLite();

    public WindowsDeviceIPValidator(ConcurrentQueue<PriorityQueueField<Long>> queue) throws IllegalArgumentException {
        super(queue);
    }

    @Override
    protected PriorityQueueField<Long> getData() throws InterruptedException {
        return (PriorityQueueField)this.queue.get();
    }

    @Override
    public void process(PriorityQueueField<Long> data) {
        try {
            this.processDevice(data);
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Unable to process request for Device  " + data + "  details : " + exp.getMessage());
        }
    }

    private void processDevice(PriorityQueueField<Long> deviceID) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        selectQuery.addJoin(new Join("Hosts", "ELADeviceIPConfigurations", new String[]{"HOST_ID"}, new String[]{"DEVICE_ID"}, 1));
        selectQuery.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
        Criteria crit = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)deviceID.getData(), 0);
        selectQuery.setCriteria(crit);
        selectQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        DataObject dobj = PERSISTANCE_LITE.get((SelectQuery)selectQuery);
        if (!dobj.isEmpty()) {
            Row deviceRow = dobj.getFirstRow("Hosts");
            Row deviceDetailsrow = dobj.getFirstRow("HostDetails");
            LogCollectionStatus collectionstatus = DeviceUtil.getLogCollectionStatus(deviceDetailsrow);
            String dnsName = (String)deviceRow.get("DNS_FULLNAME");
            String name = (String)deviceRow.get("DNS_NAME");
            String existingIP = (String)deviceRow.get("HOST_IPADDRESS");
            InetAddress[] address = this.getInetAddress(name, dnsName, existingIP);
            boolean status = false;
            if (collectionstatus == LogCollectionStatus.PING) {
                boolean device_status = false;
                if (address != null) {
                    for (InetAddress addr : address) {
                        try {
                            if (!addr.isReachable(10000) && !CommonUtil.isPingable(addr)) continue;
                            device_status = true;
                            break;
                        }
                        catch (Exception exp) {
                            exp.printStackTrace();
                        }
                    }
                }
                DeviceUtil.updatePingNowStatus(device_status, deviceDetailsrow, dobj);
            }
            if (status |= this.checkAndupdateDeviceData(address, dobj, deviceRow, deviceID)) {
                PERSISTANCE_LITE.update(dobj);
            }
        } else {
            LOGGER.log(Level.FINE, "No such device found  " + deviceID.getData());
        }
    }

    private boolean checkAndupdateDeviceData(InetAddress[] address, DataObject dobj, Row deviceRow, PriorityQueueField<Long> deviceID) throws DataAccessException {
        boolean status = true;
        String existingIP = (String)deviceRow.get("HOST_IPADDRESS");
        if (address != null) {
            if (!(address[0].getHostAddress() == null || existingIP != null && existingIP.equals(address[0].getHostAddress()))) {
                deviceRow.set("HOST_IPADDRESS", (Object)address[0].getHostAddress());
                dobj.updateRow(deviceRow);
            } else {
                status = false;
            }
            status |= this.checkAndupdateConfiguration(deviceID.getData(), dobj, address, existingIP);
        }
        return status;
    }

    private boolean checkAndupdateConfiguration(Long deviceID, DataObject dobj, InetAddress[] address, String oldIP) {
        boolean status = true;
        try {
            DeviceIP ipaddress = new DeviceIP(address);
            if (dobj.containsTable("ELADeviceIPConfigurations")) {
                Row row = dobj.getFirstRow("ELADeviceIPConfigurations");
                if (this.compareWithExistingData(row, ipaddress)) {
                    row.set("DEVICE_ID", (Object)deviceID);
                    row.set("IPV4", (Object)ipaddress.getIPV4Address());
                    row.set("IPV6", (Object)ipaddress.getIPV6Address());
                    dobj.updateRow(row);
                    this.checkAndupdateHistory(dobj, deviceID, ipaddress);
                } else {
                    status = false;
                }
            } else {
                Row row = new Row("ELADeviceIPConfigurations");
                row.set("DEVICE_ID", (Object)deviceID);
                if (address != null) {
                    row.set("IPV4", (Object)ipaddress.getIPV4Address());
                    row.set("IPV6", (Object)ipaddress.getIPV6Address());
                } else {
                    ipaddress.setIPV4Address(oldIP);
                    row.set("IPV4", (Object)oldIP);
                    ipaddress.setIPV6Address(oldIP);
                }
                dobj.addRow(row);
                this.checkAndupdateHistory(dobj, deviceID, ipaddress);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Unable to process configuration updates for device  " + deviceID);
        }
        return status;
    }

    private boolean compareWithExistingData(Row firstRow, DeviceIP ipaddress) {
        return false;
    }

    private void checkAndupdateHistory(DataObject dobj, Long deviceID, DeviceIP ipaddress) {
        Row row = new Row("ELADeviceIPHistory");
        row.set("ENTRY_TIME", (Object)System.nanoTime());
        row.set("DEVICE_ID", (Object)deviceID);
        row.set("IPV4", (Object)ipaddress.getIPV4Address());
        row.set("IPV6", (Object)ipaddress.getIPV6Address());
        try {
            dobj.addRow(row);
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Unable to add history for device: " + deviceID + " Exception details : " + exp.getMessage());
        }
    }

    private InetAddress[] getInetAddress(String ... list) {
        for (String name : list) {
            try {
                InetAddress[] address = InetAddressHandler.getAllByName(name);
                return address;
            }
            catch (Exception exp) {
                LOGGER.log(Level.FINE, "Unable to resolve device : " + name + " Exception details : " + exp.getMessage());
            }
        }
        return null;
    }

    private class DeviceIP {
        private JSONArray ipv4 = new JSONArray();
        private JSONArray ipv6 = new JSONArray();

        public DeviceIP(InetAddress[] address) {
            if (address != null) {
                this.loadIPV6andV4Address(address);
            }
        }

        private void loadIPV6andV4Address(InetAddress[] address) {
            for (InetAddress addr : address) {
                if (addr instanceof Inet4Address) {
                    this.ipv4.put((Object)addr.getHostAddress());
                    continue;
                }
                if (!(addr instanceof Inet6Address)) continue;
                this.ipv6.put((Object)addr.getHostAddress());
            }
        }

        public String getIPV4Address() {
            return this.ipv4.length() > 0 ? this.ipv4.toString() : null;
        }

        public void setIPV4Address(String address) {
            this.ipv4.put((Object)address);
        }

        public void setIPV6Address(String address) {
            this.ipv6.put((Object)address);
        }

        public String getIPV6Address() {
            return this.ipv6.length() > 0 ? this.ipv6.toString() : null;
        }
    }
}

