/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.device.util;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.sa.server.util.HostDBHandler;
import com.adventnet.taskengine.Scheduler;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.credential.CredentialHandler;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.device.DeviceProperties;
import com.manageengine.ela.server.common.device.LogCollectionStatus;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import com.manageengine.ela.server.common.device.management.ExtendedDeviceActions;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.common.network.status.DeviceStatusValidator;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.Credential;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceUtil {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final Logger LOGGER = Logger.getLogger(DeviceUtil.class.getName());
    public static final long MIN_MONITORINTERVAL = 10L;
    private static Scheduler scheduler = null;
    private static List<Integer> defaultSyslogPort = null;
    private static int[] commonPorts = new int[]{21, 22, 80, 135, 137, 139, 161, 443, 445, 3389, 4567, 8080};
    private static final Lock DNSRESOLVELOCK = new ReentrantLock(true);

    public static Scheduler getScheduler() throws Exception {
        if (scheduler == null) {
            scheduler = (Scheduler)BeanUtil.lookup((String)"Scheduler");
        }
        return scheduler;
    }

    public static String getTechnicianEmail(Long userId) throws Exception {
        Table table = Table.getTable((String)"AaaContactInfo");
        SelectQueryImpl sql = new SelectQueryImpl(table);
        sql.addSelectColumn(Column.getColumn((String)"AaaUserContactInfo", (String)"*"));
        sql.addSelectColumn(Column.getColumn((String)"AaaContactInfo", (String)"*"));
        String[] cols1 = new String[]{"CONTACTINFO_ID"};
        String[] cols2 = new String[]{"CONTACTINFO_ID"};
        sql.addJoin(new Join(table, Table.getTable((String)"AaaUserContactInfo"), cols1, cols2, 2));
        sql.setCriteria(new Criteria(Column.getColumn((String)"AaaUserContactInfo", (String)"USER_ID"), (Object)userId, 0));
        LOGGER.log(Level.FINER, "getEmail: SelectQuery is ----->  {0}", sql);
        DataObject obtained = PERSISTENCELITE.get((SelectQuery)sql);
        LOGGER.log(Level.FINER, "DEBUG: DataObject obtained is ------------>  {0}", obtained);
        return (String)obtained.getFirstValue("AaaContactInfo", 2);
    }

    public static List<Integer> getDefaultSyslogPorts() {
        if (defaultSyslogPort == null) {
            defaultSyslogPort = ImmutableList.of((Object)513, (Object)514);
        }
        return defaultSyslogPort;
    }

    public static boolean isValidDevice(String deviceIdentity) {
        return DeviceUtil.resolveDNSForDevice(deviceIdentity) != null;
    }

    public static InetAddress resolveDNSForDevice(String deviceIdentity) {
        if (deviceIdentity == null) {
            LOGGER.info("Invalid Device Identity : " + deviceIdentity);
            return null;
        }
        try {
            InetAddress address = null;
            DNSRESOLVELOCK.lock();
            try {
                address = InetAddressHandler.getInetAddress(deviceIdentity);
                if (address.isLoopbackAddress() || address.isAnyLocalAddress()) {
                    address = InetAddressHandler.getLocalHost();
                }
            }
            finally {
                DNSRESOLVELOCK.unlock();
            }
            return address;
        }
        catch (Exception exp) {
            LOGGER.info("Unknown Device : " + deviceIdentity);
            return null;
        }
    }

    public static Long getTaskID(String taskName) throws Exception {
        DataObject taskDO = PERSISTENCELITE.get("TaskEngine_Task", new Criteria(new Column("TaskEngine_Task", "TASK_NAME"), (Object)taskName, 2));
        Long taskID = null;
        Row taskEngTaskRow = taskDO.getRow("TaskEngine_Task", (Row)null);
        if (taskEngTaskRow != null) {
            taskID = (Long)taskEngTaskRow.get(1);
        }
        return taskID;
    }

    public static ArrayList<Long> getDeviceIdList(String deviceName) throws DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID"));
        query.setCriteria(new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_NAME"), (Object)deviceName, 0));
        DataObject hostDO = PERSISTENCELITE.get((SelectQuery)query);
        ArrayList<Long> deviceIds = new ArrayList<Long>();
        if (!hostDO.isEmpty()) {
            Iterator iterator = hostDO.getRows("Hosts");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                deviceIds.add((Long)row.get("HOST_ID"));
            }
        }
        return deviceIds;
    }

    public static Long getLoginID() {
        com.adventnet.authentication.Credential loginCrd = AuthUtil.getUserCredential();
        if (loginCrd != null) {
            return loginCrd.getUserId();
        }
        return TechnicianUtil.getDefaultAdminUserID();
    }

    public static Long getDeviceId(String deviceName) throws DataAccessException {
        ArrayList<Long> deviceIds = DeviceUtil.getDeviceIdList(deviceName);
        if (deviceIds.size() > 0) {
            return deviceIds.get(0);
        }
        return -1L;
    }

    private static Long getDeviceId(String deviceName, Column column) throws DataAccessException {
        Iterator iterator;
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID"));
        query.setCriteria(new Criteria(column, (Object)deviceName, 0));
        DataObject hostDO = PERSISTENCELITE.get((SelectQuery)query);
        if (!hostDO.isEmpty() && (iterator = hostDO.getRows("Hosts")).hasNext()) {
            Row row = (Row)iterator.next();
            String deviceId = String.valueOf(row.get("HOST_ID"));
            return NumberUtils.toLong((String)deviceId);
        }
        return -1L;
    }

    public static Long getDeviceIdByDisplayName(String displayName) throws DataAccessException {
        Column column = Column.getColumn((String)"Hosts", (String)"DISPLAY_NAME");
        return DeviceUtil.getDeviceId(displayName, column);
    }

    public static long getDeviceIdByDNSNameFullName(String deviceName) throws DataAccessException {
        Column column = Column.getColumn((String)"Hosts", (String)"DNS_FULLNAME");
        return DeviceUtil.getDeviceId(deviceName, column);
    }

    public static com.manageengine.ela.server.common.credential.Credential getDeviceCredential(Long deviceID) throws DataAccessException {
        String userName = null;
        String password = null;
        String domain = null;
        Column deviceIdCol = Column.getColumn((String)"HostDetails", (String)"HOST_ID");
        Criteria criteria = new Criteria(deviceIdCol, (Object)deviceID, 0);
        DataObject dObj = PERSISTENCELITE.get("HostDetails", criteria);
        if (!dObj.isEmpty()) {
            Row row = dObj.getRow("HostDetails");
            userName = (String)row.get("USERNAME");
            password = EnDecryptImplSingleton.getInstance().decrypt((String)row.get("PASSWORD"));
            domain = (String)row.get("DOMAIN_NAME");
            if (!Strings.isNullOrEmpty((String)domain) && !Strings.isNullOrEmpty((String)userName)) {
                userName = domain + "\\" + userName;
            }
            return CredentialHandler.getCustomCredential(userName, password, null, null);
        }
        return null;
    }

    public static boolean isPortAlreadyAvailable(Integer port) {
        if (DeviceUtil.getDefaultSyslogPorts().contains(port)) {
            return true;
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"SYSLOG_PORT"), (Object)port, 0);
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get("HostDetails", criteria);
            return !dataObject.isEmpty();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static LogCollectionStatus getLogCollectionStatus(Object status) {
        try {
            return status != null ? LogCollectionStatus.getStatus(Integer.valueOf(status.toString())) : LogCollectionStatus.ENABLED;
        }
        catch (Exception exp) {
            LOGGER.fine("Exception in logcollection status conversion : " + exp);
            return LogCollectionStatus.ENABLED;
        }
    }

    public static LogCollectionStatus getLogCollectionStatus(Row deviceDetails) {
        try {
            return deviceDetails != null ? LogCollectionStatus.getStatus(Integer.valueOf(deviceDetails.get("LOG_COLLECTION_STATUS").toString())) : LogCollectionStatus.ENABLED;
        }
        catch (Exception exp) {
            LOGGER.fine("Exception in logcollection status conversion : " + exp);
            return LogCollectionStatus.ENABLED;
        }
    }

    public static boolean updatePingNowStatus(boolean status, Row deviceDetails, DataObject dobj) {
        if (deviceDetails == null) {
            return false;
        }
        if (!status) {
            deviceDetails.set("STATUS", (Object)BaseStatusCode.getBaseStatusCode(7945).getOrgStatusCode());
        } else {
            deviceDetails.set("STATUS", (Object)BaseStatusCode.getBaseStatusCode(0).getOrgStatusCode());
        }
        deviceDetails.set("LOG_COLLECTION_STATUS", (Object)LogCollectionStatus.ENABLED.getStatus());
        try {
            dobj.updateRow(deviceDetails);
            dobj = PersistenceDBUtil.getPersistenceLite().update(dobj);
        }
        catch (Exception exp) {
            LOGGER.info("Exception in logcollection status update : " + exp);
            return false;
        }
        return true;
    }

    public static LogSourceCategoryContainer.DeviceCategory getDeviceCategory(Long deviceID) {
        try {
            Row deviceDetails = HostDBHandler.getHostDetailsRow(deviceID);
            return LogSourceCategoryContainer.DeviceCategory.getCategory(deviceDetails.get("TYPE").toString());
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return LogSourceCategoryContainer.DeviceCategory.UNKNOWN;
        }
    }

    public static LogSourceCategoryContainer.DeviceCategory getDeviceCategory(Object category) {
        try {
            if (category != null) {
                return LogSourceCategoryContainer.DeviceCategory.getCategory(category.toString());
            }
        }
        catch (Exception exp) {
            LOGGER.fine("Exception in getDeviceCategory conversion : " + exp);
        }
        return LogSourceCategoryContainer.DeviceCategory.SYSLOG;
    }

    public static void updateDeviceStatus(Long device_id, LogCollectionStatus enabled) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)device_id, 0);
            DataBaseReqestProcessor.executeUpdateQuery("HostDetails", "LOG_COLLECTION_STATUS", enabled.getStatus(), criteria, new boolean[0]);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void updateDeviceStatus(String deviceName, LogCollectionStatus status) {
        try {
            Row row = HostDBHandler.getHostDetailsRow(deviceName);
            Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), row.get("HOST_ID"), 0);
            DataBaseReqestProcessor.executeUpdateQuery("HostDetails", "LOG_COLLECTION_STATUS", status.getStatus(), criteria, new boolean[0]);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void updateMonitorInterval(Long[] deviceList, int monitorInterval) throws Exception {
        if ((long)monitorInterval > 10L) {
            Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceList, 8);
            Criteria type = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.WINDOWS.getCategoryName(), 0);
            type = type.or(new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.AS400.getCategoryName(), 0));
            DataBaseReqestProcessor.executeUpdateQuery("HostDetails", "MON_INTERVAL", monitorInterval, criteria.and(type), new boolean[0]);
            DeviceUtil.handleSLUpdateForUpdateDevice(criteria.and(type));
        }
    }

    public static void updateSysLogPort(Long[] deviceList, int syslogProt) throws Exception {
        if (!DeviceUtil.isValidSyslogPort(syslogProt)) {
            throw BaseStatusCode.getBaseStatusCode(9001);
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceList, 8);
        Criteria type = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.AS400.getCategoryName(), 1);
        type = type.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SYSLOG_PORT"), null, 1));
        DataBaseReqestProcessor.executeUpdateQuery("HostDetails", "SYSLOG_PORT", syslogProt, criteria.and(type), new boolean[0]);
        DeviceUtil.handleSLUpdateForUpdateDevice(criteria.and(type));
    }

    public static void updateCredential(Long[] deviceList, Credential crd) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceList, 8);
        Criteria type = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.AS400.getCategoryName(), 1);
        type = type.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SYSLOG_PORT"), null, 0));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DOMAIN_NAME", crd.getDomain());
        if (crd.getPassword() != null && !crd.getPassword().isEmpty()) {
            String decryptedPwd = EnDecryptImplSingleton.getInstance().encrypt(crd.getPassword());
            map.put("PASSWORD", decryptedPwd);
        } else {
            map.put("PASSWORD", null);
        }
        map.put("USERNAME", crd.getUserName());
        DataBaseReqestProcessor.executeUpdateQuery("HostDetails", map, criteria.and(type), new boolean[0]);
        DeviceUtil.handleSLUpdateForUpdateDevice(criteria.and(type));
    }

    public static void handleSLUpdateForUpdateDevice(Criteria criteria) {
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get("HostDetails", criteria);
            Iterator itr = dobj.getRows("HostDetails");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                HostDBHandler.addSlUpdateRow((Long)row.get("HOST_ID"), HostDBHandler.getServiceType(CommonUtil.SlUpdateConstants.HOSTUPDATE), (Long)row.get("SLID"));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static boolean isValidSyslogPort(String sysLogPort) {
        try {
            int port = Integer.parseInt(sysLogPort);
            return DeviceUtil.isValidSyslogPort(port);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static boolean isValidSyslogPort(int port) {
        try {
            if (DeviceUtil.isPortAlreadyAvailable(port)) {
                return true;
            }
            boolean status = DeviceStatusValidator.checkPortstatus(port);
            return !status;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static boolean isValidMachine(String deviceName) {
        for (int port : commonPorts) {
            if (!DeviceStatusValidator.checkPortstatus(deviceName, port, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidMachine(InetAddress address) {
        for (int port : commonPorts) {
            if (!DeviceStatusValidator.checkPortstatus(address, port, true, 2000)) continue;
            return true;
        }
        return false;
    }

    public static JSONObject isDeviceDiscovered(JSONObject reqJsonObject) throws BaseStatusCode {
        try {
            String deviceName = reqJsonObject.getString("DEVICE_NAME");
            Criteria criteria = new Criteria(Column.getColumn((String)"ELADomainComputerDetails", (String)"NAME"), (Object)deviceName, 0);
            criteria = criteria.or(new Criteria(Column.getColumn((String)"ELADomainComputerDetails", (String)"DNS_NAME"), (Object)deviceName, 0));
            DataObject dataObject = PERSISTENCELITE.get("ELADomainComputerDetails", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getFirstRow("ELADomainComputerDetails");
                reqJsonObject.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.WINDOWS);
                reqJsonObject.put("DOMAIN_ID", row.get("DOMAIN_ID"));
            } else {
                Criteria criteria1 = new Criteria(Column.getColumn((String)"ELAWorkgroupComputerDetails", (String)"NAME"), (Object)deviceName, 0);
                DataObject dataObject1 = PERSISTENCELITE.get("ELAWorkgroupComputerDetails", criteria1);
                if (!dataObject1.isEmpty()) {
                    Row row = dataObject1.getFirstRow("ELAWorkgroupComputerDetails");
                    reqJsonObject.put("DEVICE_CATEGORY", (Object)LogSourceCategoryContainer.DeviceCategory.WINDOWS);
                    reqJsonObject.put("WORKGROUP_ID", row.get("WORKGROUP_ID"));
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return reqJsonObject;
    }

    public static JSONObject isDeviceDiscovered(JSONArray request) {
        JSONObject result = new JSONObject();
        HashMap<String, JSONObject> processMap = new HashMap<String, JSONObject>();
        try {
            String commonName;
            Row row;
            String[] name;
            for (int index = 0; index < request.length(); ++index) {
                JSONObject device = request.getJSONObject(index);
                name = device.getString("NAME");
                processMap.put(name.toUpperCase(), device);
            }
            JSONObject domainDevices = new JSONObject();
            JSONObject workGroupDevices = new JSONObject();
            name = processMap.keySet().toArray(new String[processMap.size()]);
            Criteria criteria = new Criteria(Column.getColumn((String)"ELADomainComputerDetails", (String)"NAME"), (Object)name, 8, false);
            criteria = criteria.or(new Criteria(Column.getColumn((String)"ELADomainComputerDetails", (String)"DNS_NAME"), (Object)name, 8, false));
            DataObject dataObject = PERSISTENCELITE.get("ELADomainComputerDetails", criteria);
            Iterator itr = dataObject.getRows("ELADomainComputerDetails");
            while (itr.hasNext()) {
                try {
                    String dnsName;
                    row = (Row)itr.next();
                    Long domainID = (Long)row.get("DOMAIN_ID");
                    commonName = (String)row.get("NAME");
                    if (commonName != null) {
                        commonName = commonName.toUpperCase();
                    }
                    if ((dnsName = (String)row.get("DNS_NAME")) != null) {
                        dnsName = dnsName.toUpperCase();
                    }
                    String key = domainID.toString();
                    JSONArray domaindeviceArray = null;
                    if (domainDevices.isNull(key)) {
                        domaindeviceArray = new JSONArray();
                        domainDevices.put(key, (Object)domaindeviceArray);
                    } else {
                        domaindeviceArray = domainDevices.getJSONArray(key);
                    }
                    if (dnsName != null && processMap.containsKey(dnsName)) {
                        domaindeviceArray.put((Object)((JSONObject)processMap.get(dnsName)).put("NAME", row.get("DNS_NAME")));
                        processMap.remove(dnsName);
                        continue;
                    }
                    domaindeviceArray.put((Object)((JSONObject)processMap.get(commonName)).put("NAME", row.get("NAME")));
                    processMap.remove(commonName);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            name = processMap.keySet().toArray(new String[processMap.size()]);
            criteria = new Criteria(Column.getColumn((String)"ELAWorkgroupComputerDetails", (String)"NAME"), (Object)name, 8, false);
            dataObject = PERSISTENCELITE.get("ELAWorkgroupComputerDetails", criteria);
            itr = dataObject.getRows("ELAWorkgroupComputerDetails");
            while (itr.hasNext()) {
                try {
                    row = (Row)itr.next();
                    Long workgroupID = (Long)row.get("WORKGROUP_ID");
                    commonName = (String)row.get("NAME");
                    if (commonName != null) {
                        commonName = commonName.toUpperCase();
                    }
                    String key = workgroupID.toString();
                    JSONArray workgroupDeviceArray = null;
                    if (domainDevices.isNull(key)) {
                        workgroupDeviceArray = new JSONArray();
                        workGroupDevices.put(key, (Object)workgroupDeviceArray);
                    } else {
                        workgroupDeviceArray = domainDevices.getJSONArray(key);
                    }
                    workgroupDeviceArray.put((Object)((JSONObject)processMap.get(commonName)).put("NAME", row.get("NAME")));
                    processMap.remove(commonName);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            JSONArray otherDevices = new JSONArray();
            if (processMap.size() > 0) {
                Set otherDeviceSet = processMap.keySet();
                for (String key : otherDeviceSet) {
                    otherDevices.put(processMap.get(key));
                }
            }
            if (domainDevices.length() > 0) {
                result.put("DOMAIN_DEVICES", (Object)domainDevices);
            }
            if (workGroupDevices.length() > 0) {
                result.put("WORKGROUP_DEVICES", (Object)workGroupDevices);
            }
            if (otherDevices.length() > 0) {
                result.put("OTHER_DEVICES", (Object)otherDevices);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return result;
    }

    public static void startDeviceDomainIDMigration() {
        JSONArray domainDetails = ADSDomainHandler.getDomainDetails();
        try {
            if (domainDetails.length() > 0) {
                DeviceUtil.startMigrationFromExistingDomainName(domainDetails);
                DeviceUtil.startMigrationFromExistingDeviceName();
            } else {
                LOGGER.info("No matching domains discovered");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private static void startMigrationFromExistingDomainName(JSONArray domainDetails) {
        for (int index = 0; index < domainDetails.length(); ++index) {
            try {
                JSONObject domain = domainDetails.getJSONObject(index);
                Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_NAME"), (Object)domain.getString("DOMAIN_NAME"), 0, false);
                if (!domain.isNull("DOMAIN_FLAT_NAME")) {
                    criteria = criteria.or(new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_NAME"), (Object)domain.getString("DOMAIN_FLAT_NAME"), 0, false));
                }
                if (!domain.isNull("DOMAIN_DNS_NAME")) {
                    criteria = criteria.or(new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_NAME"), (Object)domain.getString("DOMAIN_DNS_NAME"), 0, false));
                }
                criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_ID"), null, 0));
                criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"WORKGROUP_ID"), null, 0));
                criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.WINDOWS.getCategoryName(), 0));
                DataBaseReqestProcessor.executeUpdateQuery("HostDetails", "DOMAIN_ID", domain.getLong("DOMAIN_ID"), criteria, new boolean[0]);
                continue;
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    private static void startMigrationFromExistingDeviceName() {
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("Hosts");
            tableList.add("HostDetails");
            Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_ID"), null, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"WORKGROUP_ID"), null, 0));
            criteria = criteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.WINDOWS.getCategoryName(), 0));
            DataObject deviceDO = PERSISTENCELITE.get(tableList, criteria);
            Iterator itr = deviceDO.getRows("Hosts");
            while (itr.hasNext()) {
                Row deviceRow = (Row)itr.next();
                Criteria deviceIDCriteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), deviceRow.get("HOST_ID"), 0);
                Row deviceDetails = deviceDO.getRow("HostDetails", deviceIDCriteria);
                String deviceName = (String)deviceRow.get("HOST_NAME");
                JSONObject jsonObject = new JSONObject();
                DeviceUtil.isDeviceDiscovered(jsonObject.put("DEVICE_NAME", (Object)deviceName));
                if (!jsonObject.isNull("DOMAIN_ID")) {
                    deviceDetails.set("DOMAIN_ID", jsonObject.get("DOMAIN_ID"));
                    deviceDO.updateRow(deviceDetails);
                    continue;
                }
                if (jsonObject.isNull("WORKGROUP_ID")) continue;
                deviceDetails.set("WORKGROUP_ID", jsonObject.get("WORKGROUP_ID"));
                deviceDO.updateRow(deviceDetails);
            }
            PERSISTENCELITE.update(deviceDO);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void updateExistingDevicesForAddedDomain(JSONObject domainDetails) {
        DeviceUtil.startMigrationFromExistingDomainName(new JSONArray().put((Object)domainDetails));
    }

    public static Map<Long, Long> getConfiguredReportID(List<Long> allDeviceID) throws DataAccessException {
        HashMap<Long, Long> reportHash = new HashMap<Long, Long>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_NAME"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"DNS_NAME"));
        query.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID"));
        query.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"TYPE"));
        query.addSelectColumn(Column.getColumn((String)"Hosts2ReportConfig", (String)"REPORTID"));
        query.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"REPORTID"));
        query.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"PROFILENAME"));
        query.setCriteria(new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)allDeviceID.toArray(new Long[allDeviceID.size()]), 8));
        query.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
        query.addJoin(new Join("HostDetails", "Hosts2ReportConfig", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 1));
        query.addJoin(new Join("Hosts2ReportConfig", "ReportConfig", new String[]{"REPORTID"}, new String[]{"REPORTID"}, 1));
        DataObject deviceDetails = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        for (int index = 0; index < allDeviceID.size(); ++index) {
            Long key = allDeviceID.get(index);
            try {
                Criteria criteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)key, 0);
                Row device = deviceDetails.getRow("Hosts", criteria);
                String device_Name = (String)device.get("HOST_NAME");
                String device_dns_Name = (String)device.get("DNS_NAME");
                criteria = new Criteria(Column.getColumn((String)"ReportConfig", (String)"PROFILENAME"), (Object)(device_Name + "_Profile"), 0);
                criteria = criteria.or(new Criteria(Column.getColumn((String)"ReportConfig", (String)"PROFILENAME"), (Object)(device_dns_Name + "_Profile"), 0));
                Row reportConfig = deviceDetails.getRow("ReportConfig", criteria);
                Long reportID = null;
                if (reportConfig != null) {
                    reportID = (Long)reportConfig.get("REPORTID");
                } else {
                    LOGGER.severe("Device Report ID missing for " + key + "  Creating new custom report");
                    criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)key, 0);
                    reportID = ExtendedDeviceActions.getConfigureDeviceDefaultProfile(key, device_dns_Name, (String)deviceDetails.getRow("HostDetails", criteria).get("TYPE"));
                }
                reportHash.put(key, reportID);
                continue;
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return reportHash;
    }

    public static JSONArray loadDeviceDetailsFromJSON(JSONObject reqJsonObject) throws BaseStatusCode, JSONException {
        JSONArray array = new JSONArray();
        if (!reqJsonObject.isNull("CUSTOM_DEVICE_DETAILS")) {
            array.put((Object)reqJsonObject.getJSONObject("CUSTOM_DEVICE_DETAILS"));
        } else {
            if (!reqJsonObject.isNull("DEVICE_NAME")) {
                String[] normalDevice = reqJsonObject.getString("DEVICE_NAME").split(",");
                for (int index = 0; index < normalDevice.length; ++index) {
                    String name = DeviceUtil.getValidDeviceName(normalDevice[index]);
                    if (name == null) continue;
                    array.put((Object)new JSONObject().put("NAME", (Object)name.trim()));
                }
            }
            if (!reqJsonObject.isNull("DEVICE_NAME_HISTORICCOLLECTION")) {
                String[] historicCollection;
                for (String name : historicCollection = reqJsonObject.getString("DEVICE_NAME_HISTORICCOLLECTION").split(",")) {
                    if ((name = DeviceUtil.getValidDeviceName(name)) == null) continue;
                    array.put((Object)new JSONObject().put("NAME", (Object)name.trim()).put("ISHISTORICCOLLECTION", (Object)Boolean.TRUE));
                }
            }
        }
        if (array.length() == 0) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return array;
    }

    private static String getValidDeviceName(String name) {
        if (name != null && !(name = name.trim()).isEmpty()) {
            return name.trim();
        }
        return null;
    }

    public static List<String> getDeviceNameListFromRequestJSON(JSONArray deviceDetails) throws JSONException {
        ArrayList<String> deviceNames = new ArrayList<String>();
        for (int index = 0; index < deviceDetails.length(); ++index) {
            deviceNames.add(deviceDetails.getJSONObject(index).getString("NAME"));
        }
        return deviceNames;
    }

    public static DataObject getDeviceDetailsDO(Long deviceID, List<String> deviceTableColumns, List<String> deviceDetailsTableColumns) throws DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        query.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID"));
        query.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID"));
        for (String colName : deviceTableColumns) {
            query.addSelectColumn(Column.getColumn((String)"Hosts", (String)colName));
        }
        for (String colName : deviceDetailsTableColumns) {
            query.addSelectColumn(Column.getColumn((String)"HostDetails", (String)colName));
        }
        query.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
        query.setCriteria(new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)deviceID, 0));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
    }

    public static DeviceProperties getDeviceProperties(long deviceId) {
        DeviceProperties properties = new DeviceProperties();
        properties.setDeviceID(deviceId);
        Criteria criteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)deviceId, 0);
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get(Arrays.asList("Hosts", "HostDetails", "HostGroupMapping"), criteria);
            Row device = dobj.getRow("Hosts");
            Row deviceDetails = dobj.getRow("HostDetails");
            Row group = dobj.getRow("HostGroupMapping");
            LogSourceCategoryContainer.DeviceCategory category = LogSourceCategoryContainer.DeviceCategory.getCategory((String)deviceDetails.get("TYPE"));
            if (category != LogSourceCategoryContainer.DeviceCategory.UNKNOWN && category != LogSourceCategoryContainer.DeviceCategory.UNKNOWNCATEGORY) {
                properties.setDeviceCategory(category);
                if ((Integer)deviceDetails.get("ISINHERITED") == 1) {
                    properties.setSyncedDevice(true);
                }
                return properties;
            }
            properties.setDeviceCategory(category);
            properties.setDeviceName((String)device.get("HOST_NAME"));
            properties.setDeviceDns_name((String)device.get("DNS_NAME"));
            properties.setDeviceAddress((String)device.get("HOST_IPADDRESS"));
            properties.setDeviceFQDN((String)device.get("DNS_FULLNAME"));
            properties.setDeviceDisplayName((String)device.get("DISPLAY_NAME"));
            properties.setDeviceGroup((Long)group.get("GROUPID"));
            properties.setLogCollectorID((Long)deviceDetails.get("SLID"));
            if ((Integer)deviceDetails.get("ISINHERITED") == 1) {
                properties.setSyncedDevice(true);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return properties;
    }

    public static Map<String, String> getDeviceBasicDetails(Long deviceID) throws DataAccessException {
        HashMap<String, String> deviceBasicInfo = new HashMap<String, String>();
        DataObject dobj = DeviceUtil.getDeviceDetailsDO(deviceID, Arrays.asList("DNS_NAME"), Arrays.asList("DOMAIN_ID", "WORKGROUP_ID", "DOMAIN_NAME", "USERNAME", "PASSWORD"));
        Row deviceDetailsRow = dobj.getFirstRow("HostDetails");
        deviceBasicInfo.putAll(CommonUtil.findHostCredentialDetails(deviceDetailsRow));
        String dnsName = (String)dobj.getFirstValue("Hosts", "DNS_NAME");
        if (deviceBasicInfo.get("DOMAIN_NAME") == null) {
            deviceBasicInfo.put("DOMAIN_NAME", dnsName);
        }
        deviceBasicInfo.put("DEVICE_NAME", dnsName);
        return deviceBasicInfo;
    }

    public static boolean isConfigurable(Long deviceID) throws DataAccessException {
        int[] status = new int[]{LogCollectionStatus.ENABLED.getStatus(), LogCollectionStatus.SCANNING.getStatus(), LogCollectionStatus.SCHEDULE.getStatus(), LogCollectionStatus.PING.getStatus()};
        Criteria crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceID, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)LogSourceCategoryContainer.DeviceCategory.WINDOWS.getCategoryName(), 0));
        crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"SYSLOG_PORT"), null, 0));
        return DBUtil.getCountInt("HostDetails", crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"LOG_COLLECTION_STATUS"), (Object)status, 8))) != 0;
    }

    public static com.manageengine.ela.server.common.credential.Credential getCredential(String hostName) throws DataAccessException {
        Iterator deviceDetailsIterator;
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        selectQuery.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
        selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_NAME"), (Object)hostName, 0);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCELITE.get((SelectQuery)selectQuery);
        if (!dataObject.isEmpty() && (deviceDetailsIterator = dataObject.getRows("HostDetails")).hasNext()) {
            Row deviceDetailsRow = (Row)deviceDetailsIterator.next();
            String username = (String)deviceDetailsRow.get("USERNAME");
            String password = (String)deviceDetailsRow.get("PASSWORD");
            com.manageengine.ela.server.common.credential.Credential credential = CredentialHandler.getCustomCredential(username, password, null, hostName);
            return credential;
        }
        return null;
    }

    public static DeviceProperties getDeviceName(Long linkedDeviceId) throws DataAccessException, BaseStatusCode {
        Criteria deviceIdCriteria = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)linkedDeviceId, 0);
        DataObject dataObject = PERSISTENCELITE.get("Hosts", deviceIdCriteria);
        if (!dataObject.isEmpty()) {
            DeviceProperties deviceProperties = new DeviceProperties();
            Iterator deviceIterator = dataObject.getRows("Hosts");
            if (deviceIterator.hasNext()) {
                Row deviceRow = (Row)deviceIterator.next();
                deviceProperties.setDeviceName(String.valueOf(deviceRow.get("HOST_NAME")));
                deviceProperties.setDeviceDisplayName(String.valueOf(deviceRow.get("DISPLAY_NAME")));
            }
            return deviceProperties;
        }
        throw BaseStatusCode.getBaseStatusCode(7940);
    }

    public static long addAndGetDeviceId(String deviceName, LogSourceCategoryContainer.DeviceCategory deviceCategory) throws Exception {
        if (deviceName == null || deviceName.isEmpty()) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        Long deviceId = DeviceUtil.getDeviceIdByDisplayName(deviceName);
        if (deviceId > 0L) {
            return deviceId;
        }
        deviceId = DeviceUtil.getDeviceId(deviceName);
        if (deviceId < 0L) {
            AddOrUpdateEventlogDevice.addUnverifiedDevice(deviceName, deviceCategory);
            deviceId = DeviceUtil.getDeviceId(deviceName);
            AddOrUpdateEventlogDevice.enableOrDisableDevice(new Long[]{deviceId}, LogCollectionStatus.DISABLED.getStatus(), ResourceBundleMgr.getInstance().getServerLocale());
        }
        return deviceId;
    }

    public static Long getDomainIdFromDeviceName(String name) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELADomainComputerDetails", (String)"NAME"), (Object)name, 0, false);
        DataObject dataObject = PERSISTENCELITE.get("ELADomainComputerDetails", criteria = criteria.or(new Criteria(Column.getColumn((String)"ELADomainComputerDetails", (String)"DNS_NAME"), (Object)name, 0, false)));
        Iterator itr = dataObject.getRows("ELADomainComputerDetails");
        if (itr.hasNext()) {
            Row row = (Row)itr.next();
            return (Long)row.get("DOMAIN_ID");
        }
        return -1L;
    }

    public static com.manageengine.ela.server.common.credential.Credential getExistingCredential(String deviceName) throws DataAccessException, JSONException {
        com.manageengine.ela.server.common.credential.Credential credential = DeviceUtil.getCredential(deviceName);
        if (credential == null || credential.getUserName() == null) {
            Long domainId = DeviceUtil.getDomainIdFromDeviceName(deviceName);
            if (domainId > 0L) {
                return CredentialHandler.getCredentialFromDomainID(domainId);
            }
            return null;
        }
        return credential;
    }

    public static Long getDeviceStatus(Long deviceID) {
        Long status = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"HostDetails"));
            sq.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceID, 0);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("HostDetails");
            if (it.hasNext()) {
                Row r = (Row)it.next();
                status = (Long)r.get("STATUS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static Map<Long, String> getDeviceNamesFromDeviceIDs(Long[] deviceIDs) {
        HashMap<Long, String> ret = new HashMap<Long, String>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"Hosts"));
            sq.addSelectColumn(Column.getColumn((String)"Hosts", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)deviceIDs, 8);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("Hosts");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                ret.put((Long)row.get("HOST_ID"), (String)row.get("HOST_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Long getSysEvtColID(Long hostId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)hostId, 0);
            DataObject doo = PERSISTENCELITE.get("HostDetails", c);
            if (doo.size("HostDetails") > 0) {
                return (Long)doo.getFirstValue("HostDetails", "SLID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.info("Returning default slid of 1");
        return CommonUtil.getSysEvtColID();
    }
}

