/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery;

import com.manageengine.ela.server.common.discovery.BaseDiscoveryImpl;
import com.manageengine.ela.server.common.discovery.Discovery;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.discovery.windows.WindowsDiscovery;
import com.manageengine.ela.server.common.discovery.windows.domain.DomainDiscovery;
import com.manageengine.ela.server.common.discovery.windows.workgroup.WorkGroupDiscovery;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.discovery.SQLDiscovery;

public class DiscoveryClassFactory {
    private static DiscoveryClassFactory instance = null;
    public static final int WINDOWS_OBJECTS = 1;
    public static final int WINDOWS_DOMAINS = 2;
    public static final int WINDOWS_WORKGROUPS = 3;
    public static final int SQLSERVERS_DISCOVERY = 4;

    private DiscoveryClassFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiscoveryClassFactory getInstance() {
        Class<DiscoveryClassFactory> clazz = DiscoveryClassFactory.class;
        synchronized (DiscoveryClassFactory.class) {
            if (instance == null) {
                instance = new DiscoveryClassFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Discovery getDiscoverClass(int flag, DiscoveryParameters params) {
        BaseDiscoveryImpl instance = null;
        switch (flag) {
            case 1: {
                instance = new WindowsDiscovery(params);
                break;
            }
            case 2: {
                instance = new DomainDiscovery(params);
                break;
            }
            case 3: {
                instance = new WorkGroupDiscovery(params);
                break;
            }
            case 4: {
                instance = new SQLDiscovery(params);
            }
        }
        return instance;
    }
}

