/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.database.DatabaseBulkUploadHandler;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.discovery.Discovery;
import com.manageengine.ela.server.common.discovery.DiscoveryClassFactory;
import com.manageengine.ela.server.common.discovery.DiscoveryFileProcessorCallBack;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.discovery.DiscoveryThread;
import com.manageengine.ela.server.common.discovery.windows.ldap.ADQueryBase;
import com.manageengine.ela.server.common.executors.processor.CommonQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.handlers.workgroup.WorkgroupHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class DiscoveryHandler {
    private static final Logger LOGGER = Logger.getLogger(DiscoveryHandler.class.getName());

    public static void startDomainDiscovery(boolean isThreaded) throws Exception {
        DiscoveryParameters parameters = new DiscoveryParameters();
        DiscoveryHandler.startDomainDiscovery(parameters, isThreaded);
    }

    public static void startDomainDiscovery(DiscoveryParameters parameters, boolean isThreaded) throws Exception {
        Discovery dynamicClass = DiscoveryClassFactory.getInstance().getDiscoverClass(2, parameters);
        DiscoveryHandler.checkAndCallDiscovery(dynamicClass, null, isThreaded);
    }

    public static void startWorkGroupDiscovery(boolean isThreaded) throws Exception {
        DiscoveryParameters parameters = new DiscoveryParameters();
        DiscoveryHandler.startWorkGroupDiscovery(parameters, isThreaded);
    }

    public static void startWorkGroupDiscovery(DiscoveryParameters parameters, boolean isThreaded) throws Exception {
        Discovery dynamicClass = DiscoveryClassFactory.getInstance().getDiscoverClass(3, parameters);
        DiscoveryHandler.checkAndCallDiscovery(dynamicClass, null, isThreaded);
    }

    public static void startWindowsObjectDiscovery(String domain, boolean isThreaded, boolean deleteOldEntries, int categoryFlag, int typeFlag) throws Exception {
        switch (typeFlag) {
            case 1: {
                DiscoveryHandler.startWindowsDomainDiscovery(ADSDomainHandler.getDomainDetails((String)domain), isThreaded, deleteOldEntries, categoryFlag);
                break;
            }
            case 2: {
                DiscoveryHandler.startWindowsWorkgroupDiscovery(WorkgroupHandler.getWorkgroupDetails(domain), isThreaded, deleteOldEntries, categoryFlag);
                break;
            }
            default: {
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
        }
    }

    public static void startWindowsObjectDiscovery(JSONObject domainDetails, boolean isThreaded, boolean deleteOldEntries, int categoryFlag, int typeFlag) throws Exception {
        switch (typeFlag) {
            case 1: {
                DiscoveryHandler.startWindowsDomainDiscovery(domainDetails, isThreaded, deleteOldEntries, categoryFlag);
                break;
            }
            case 2: {
                DiscoveryHandler.startWindowsWorkgroupDiscovery(domainDetails, isThreaded, deleteOldEntries, categoryFlag);
                break;
            }
            default: {
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
        }
    }

    public static void startWindowsCustomDiscovery(DiscoveryParameters parameters, boolean isThreaded) throws Exception {
        Discovery dynamicClass = DiscoveryClassFactory.getInstance().getDiscoverClass(1, parameters);
        DiscoveryHandler.checkAndCallDiscovery(dynamicClass, parameters, isThreaded);
    }

    private static void startWindowsDomainDiscovery(JSONObject domainDetails, boolean isThreaded, boolean deleteOldEntries, int categoryFlag) throws Exception {
        DiscoveryParameters parameters = DiscoveryHandler.getCommonDomainDiscoveryParams(domainDetails, deleteOldEntries, categoryFlag);
        DiscoveryHandler.includeDBDependentProcess(parameters);
        DiscoveryHandler.startWindowsCommonObjectDiscovery(parameters, isThreaded);
    }

    public static DiscoveryParameters getCommonDomainDiscoveryParams(JSONObject domainDetails, boolean deleteOldEntries, int categoryFlag) throws DataAccessException, JSONException, BaseStatusCode {
        DiscoveryParameters parameters = new DiscoveryParameters();
        Long domainID = domainDetails.getLong("DOMAIN_ID");
        parameters.setDomainName(domainDetails.getString("DOMAIN_NAME"));
        parameters.setDomainID(domainID);
        parameters.setUniqueCriteriavalue(domainID);
        if (categoryFlag == 1 || categoryFlag == 2 || categoryFlag == 3) {
            DataBaseReqestProcessor.initializeWindowsAttributes("WINDOWS_COMPUTERS", domainDetails, parameters);
            parameters.setDiscoveryUniqueOption(categoryFlag);
            parameters.setflushOldData(deleteOldEntries);
            parameters.setTableName("ELADomainComputerDetails");
            switch (categoryFlag) {
                case 1: {
                    parameters.setLdapQuery(ADQueryBase.getWindowsServers());
                    break;
                }
                case 2: {
                    parameters.setLdapQuery(ADQueryBase.getWorkstations());
                    break;
                }
                case 3: {
                    parameters.setLdapQuery(ADQueryBase.getAllComputers());
                }
            }
        } else if (categoryFlag == 6 || categoryFlag == 5 || categoryFlag == 7) {
            DataBaseReqestProcessor.initializeWindowsAttributes("WINDOWS_CONTAINERS", domainDetails, parameters);
            parameters.setDiscoveryUniqueOption(categoryFlag);
            parameters.setflushOldData(deleteOldEntries);
            parameters.setTableName("ELAOuContainerGeneralDetails");
            switch (categoryFlag) {
                case 6: {
                    parameters.setLdapQuery(ADQueryBase.getAllContainers());
                    break;
                }
                case 5: {
                    parameters.setLdapQuery(ADQueryBase.getAllOUs());
                    break;
                }
                case 7: {
                    parameters.setLdapQuery(ADQueryBase.getAllOUsAndContainers());
                }
            }
        } else if (categoryFlag == 101 || categoryFlag == 201) {
            DataBaseReqestProcessor.initializeWindowsAttributes("WINDOWS_DOMAIN_USERS", domainDetails, parameters);
            parameters.setDiscoveryUniqueOption(categoryFlag);
            parameters.setflushOldData(deleteOldEntries);
            parameters.setTableName("ELADomainUserDetails");
            parameters.setLdapQuery(ADQueryBase.getAllUsers());
        } else if (categoryFlag == 102) {
            DataBaseReqestProcessor.initializeWindowsAttributes("WINDOWS_DOMAIN_GROUPS", domainDetails, parameters);
            parameters.setDiscoveryUniqueOption(categoryFlag);
            parameters.setflushOldData(deleteOldEntries);
            parameters.setTableName("ELADomainGroupDetails");
            parameters.setLdapQuery(ADQueryBase.getAllGroups());
        } else {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return parameters;
    }

    private static void startWindowsWorkgroupDiscovery(JSONObject workgroupdetails, boolean isThreaded, boolean deleteOldEntries, int categoryFlag) throws Exception {
        DiscoveryParameters parameters = new DiscoveryParameters();
        Long workGroupID = workgroupdetails.getLong("WORKGROUP_ID");
        parameters.setWorkGroupID(workGroupID);
        parameters.setDomainName(workgroupdetails.getString("WORKGROUP_NAME"));
        DataBaseReqestProcessor.initializeWindowsAttributes("WINDOWS_WORKGROUP_COMPUTERS", workgroupdetails, parameters);
        parameters.setDiscoveryUniqueOption(categoryFlag);
        parameters.setflushOldData(deleteOldEntries);
        parameters.setDiscoveryType(2);
        parameters.setTableName("ELAWorkgroupComputerDetails");
        parameters.setUniqueCriteriaColumnName("WORKGROUP_ID");
        parameters.setUniqueCriteriavalue(workGroupID);
        DiscoveryHandler.includeDBDependentProcess(parameters);
        DiscoveryHandler.startWindowsCommonObjectDiscovery(parameters, isThreaded);
    }

    public static void includeDBDependentProcess(DiscoveryParameters parameters) {
        CommonQueueImpl<String> queue = new CommonQueueImpl<String>();
        CommonQueueProcessor<String> uploader = DatabaseBulkUploadHandler.createNewBulkUploader(queue, parameters.getTableName(), parameters.getColumnOrder());
        parameters.setFileProcessor(new DiscoveryFileProcessorCallBack(queue));
        parameters.setDependentDBProcessor(uploader);
    }

    private static void startWindowsCommonObjectDiscovery(DiscoveryParameters parameters, boolean isThreaded) throws Exception {
        Discovery dynamicClass = DiscoveryClassFactory.getInstance().getDiscoverClass(1, parameters);
        DiscoveryHandler.checkAndCallDiscovery(dynamicClass, parameters, isThreaded);
    }

    public static void startSQLServerDiscovery() throws Exception {
        Discovery dynamicClass = DiscoveryClassFactory.getInstance().getDiscoverClass(4, null);
        CommonUtil.updateSysConfiguration("SQL_Discovery", "1", true);
        DiscoveryHandler.checkAndCallDiscovery(dynamicClass, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAndCallDiscovery(Discovery instance, DiscoveryParameters traceAction, boolean isThreaded) throws Exception {
        if (isThreaded) {
            LOGGER.info("DiscoveryThread taking care for the request At : " + System.currentTimeMillis());
            DiscoveryThread thread = new DiscoveryThread(instance, traceAction);
            thread.setName(DiscoveryThread.class.getName());
            if (traceAction != null) {
                traceAction.setPreActivityCompleted(false);
                thread.start();
                traceAction.getProcessLock().lock();
                try {
                    long time = System.currentTimeMillis();
                    LOGGER.info("Started DependentActivity wait check");
                    if (!traceAction.isPreActivityCompleted()) {
                        LOGGER.info("DependentActivity not yet completed, going to wait for completion");
                        traceAction.getProcessWaitCondn().await();
                        LOGGER.info("DependentActivity is completed(!), released from wait block");
                    } else {
                        LOGGER.info("DependentActivity is already completed");
                    }
                    LOGGER.info("Time taken in DependentActivity verification process : " + (System.currentTimeMillis() - time));
                }
                finally {
                    traceAction.getProcessLock().unlock();
                }
            } else {
                thread.start();
            }
        } else {
            long time = System.currentTimeMillis();
            if (traceAction != null && traceAction.getDomainID() != null) {
                traceAction.initDiscoveryStatusHolder();
                traceAction.getStatusHolder().commitStatus();
                try {
                    instance.startDiscovery();
                }
                finally {
                    traceAction.getStatusHolder().finalizeStatus();
                }
            } else {
                instance.startDiscovery();
            }
            LOGGER.info("Total Time taken for Discovery : " + (System.currentTimeMillis() - time));
        }
    }
}

