/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery;

import com.manageengine.ela.server.common.discovery.Discovery;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import java.util.logging.Logger;

class DiscoveryThread
extends Thread {
    private Discovery instance = null;
    private DiscoveryParameters traceAction = null;
    private static final Logger LOGGER = Logger.getLogger(DiscoveryThread.class.getName());

    DiscoveryThread(Discovery instance, DiscoveryParameters traceAction) {
        this.instance = instance;
        this.traceAction = traceAction;
    }

    @Override
    public void run() {
        long time;
        block6: {
            time = System.currentTimeMillis();
            try {
                if (this.traceAction != null && (this.traceAction.getDomainID() != null || this.traceAction.getWorkGroupID() != null)) {
                    this.traceAction.initDiscoveryStatusHolder();
                    this.traceAction.getStatusHolder().commitStatus();
                    try {
                        this.instance.startDiscovery();
                        break block6;
                    }
                    finally {
                        this.traceAction.getStatusHolder().finalizeStatus();
                    }
                }
                this.instance.startDiscovery();
            }
            catch (Exception exp) {
                LOGGER.info("Exception while starting device dicovery : " + exp.getMessage());
            }
        }
        LOGGER.info("Total Time taken for Discovery : " + (System.currentTimeMillis() - time));
    }
}

