/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows;

import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ads.fw.jni.ADSNativeHandler;
import com.manageengine.ads.fw.ldap.ad.ADSADErrorHandler;
import com.manageengine.ads.fw.ldap.ad.ADSADListener;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.discovery.listner.ObjectDiscoveryListener;
import com.manageengine.ela.server.common.discovery.windows.ldap.BasicLdapQuery;
import com.manageengine.ela.server.common.handlers.workgroup.WorkgroupHandler;
import com.manageengine.ela.server.common.jni.windows.ELANativeHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;

public class DataCollector {
    private static final Logger LOGGER = Logger.getLogger(DataCollector.class.getName());

    public static ADSADErrorHandler getObjectsBasedOnFlag(DiscoveryParameters parameters) throws Exception {
        switch (parameters.getDiscoveryType()) {
            case 1: {
                String domainName = parameters.getDomainName();
                ArrayList<String> dAttributeList = parameters.getAttriubuteList();
                BasicLdapQuery query = parameters.getLdapQuery();
                if (query == null) {
                    throw BaseStatusCode.getBaseStatusCode(7428);
                }
                return DataCollector.collectAllDomainObjectsWithListner(domainName, dAttributeList, query, parameters.getListner());
            }
            case 2: {
                String workgroupName = parameters.getDomainName();
                ArrayList<String> wAttributeList = parameters.getAttriubuteList();
                return DataCollector.collectAllWorkgroupObjectsWithListner(workgroupName, wAttributeList, parameters.getListner());
            }
        }
        return null;
    }

    public static ADSADErrorHandler collectAllWorkgroupObjectsWithListner(String workGroupName, ArrayList<String> attributes, ObjectDiscoveryListener listener) throws Exception {
        Properties workGroupDetails = WorkgroupHandler.getWorkGroupDetails(workGroupName);
        if (workGroupDetails != null && !workGroupDetails.isEmpty()) {
            DataCollector.collectWorkGroupObjects(workGroupDetails, "Computer", attributes, listener);
        } else {
            LOGGER.info("Invalid WorkGroup details found");
        }
        return null;
    }

    public static ADSADErrorHandler collectAllDomainObjectsWithListner(String domainName, ArrayList<String> attributes, BasicLdapQuery query, ObjectDiscoveryListener listener) throws Exception {
        Properties domainDetails = ADSDomainHandler.getDomainCredentialValues((String)domainName);
        if (domainDetails != null && !domainDetails.isEmpty()) {
            String defaultNamingContext = null;
            defaultNamingContext = query.getBaseContext() != null ? query.getBaseContext() : domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
            return DataCollector.collectObjects(domainDetails, query.getQueryString(), attributes, defaultNamingContext, listener);
        }
        LOGGER.info("Invalid Domain details");
        return null;
    }

    public static ArrayList<?> collectAllDomainObjectsWithoutListner(String domainName, ArrayList<String> attributes, BasicLdapQuery query) throws Exception {
        ArrayList<?> result = null;
        Properties domainDetails = ADSDomainHandler.getDomainCredentialValues((String)domainName);
        if (domainDetails != null && !domainDetails.isEmpty()) {
            String defaultNamingContext = null;
            defaultNamingContext = query.getBaseContext() != null ? query.getBaseContext() : domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
            result = DataCollector.collectObjectsWithoutListner(domainDetails, query.getQueryString(), attributes, defaultNamingContext);
        } else {
            LOGGER.info("Invalid Domain details");
        }
        return result;
    }

    public static ArrayList<?> collectObjectsWithoutListner(Properties domainDetails, String query, ArrayList<String> attributes, String ouDN) throws Exception {
        return ADSNativeHandler.getObjectsWithOutListener((Properties)domainDetails, (String)ouDN, attributes, (String)query);
    }

    public static ADSADErrorHandler collectObjects(Properties domainDetails, String query, ArrayList<String> attributes, String ouDN, ObjectDiscoveryListener listener) throws Exception {
        return ADSNativeHandler.getObjects((Properties)domainDetails, (String)ouDN, attributes, (String)query, (ADSADListener)listener);
    }

    public static void collectWorkGroupObjects(Properties workgroupDetails, String objectClass, ArrayList<String> attributes, ObjectDiscoveryListener listener) throws Exception {
        ELANativeHandler.getWorkGroupObjects(workgroupDetails, objectClass, attributes, listener);
    }
}

