/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows;

import com.adventnet.persistence.DataAccessException;
import com.manageengine.ads.fw.ldap.ad.ADSADErrorHandler;
import com.manageengine.ela.server.common.database.DataBaseSpecificActions;
import com.manageengine.ela.server.common.database.DatabaseBulkUploadHandler;
import com.manageengine.ela.server.common.database.handlers.DataBaseHandlerFactory;
import com.manageengine.ela.server.common.discovery.BaseDiscoveryImpl;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.discovery.windows.DataCollector;
import com.manageengine.ela.server.common.discovery.windows.WindowsDiscoveryListener;
import com.manageengine.ela.server.common.executors.processor.QueueProcessor;
import com.manageengine.ela.server.common.io.file.writer.FileIOHandler;
import com.manageengine.ela.server.common.io.file.writer.QueueProcessorParams;
import com.manageengine.ela.server.common.io.file.writer.TempFileWriter;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class WindowsDiscovery
extends BaseDiscoveryImpl {
    private TempFileWriter writer = null;
    private static volatile Map<String, HashSet<Integer>> processingList = new HashMap<String, HashSet<Integer>>();
    private static final Logger LOGGER = Logger.getLogger(WindowsDiscovery.class.getName());
    private static final ReentrantLock ACCESS_LOCK = new ReentrantLock();

    public WindowsDiscovery(DiscoveryParameters param) throws IllegalArgumentException {
        super(param);
        if (!this.justifyParameters()) {
            throw new IllegalArgumentException(param.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDiscovery() throws Exception {
        long time;
        block9: {
            time = System.currentTimeMillis();
            boolean isAlreadyRunning = this.isAlreadyRunning();
            try {
                if (!isAlreadyRunning) {
                    this.startPreActivity();
                    break block9;
                }
                LOGGER.info("Discovery Request for domain " + this.parameters.getDomainName() + "  is already in progress , Search Option : " + this.parameters.getDiscoveryUniqueOption());
                return;
            }
            finally {
                this.signalDiscoveryMainThread();
            }
        }
        try {
            this.startWindowsDiscovery();
        }
        catch (Exception exp) {
            LOGGER.info("Exception in WindowsDiscovery  , details : " + exp.getMessage());
            throw exp;
        }
        finally {
            this.startPostActivity();
        }
        super.checkCallBack();
        LOGGER.info("Time taken for Windows Device Discovery : " + (System.currentTimeMillis() - time));
    }

    @Override
    protected void startPreActivity() throws IOException, IllegalArgumentException, IllegalAccessException, InterruptedException, DataAccessException {
        try {
            this.addCurrentProcessOfDomain();
            if (this.parameters.isConfigureDefaultFileDump()) {
                String tempFile = WindowsDiscovery.createTempFile(this.parameters.getDomainName().replace(".", "_"));
                DataBaseSpecificActions defaulltValue = DataBaseHandlerFactory.getInstance().getDataBaseHandler();
                this.writer = this.createQueuedWriter(tempFile, 1, defaulltValue);
                if (this.parameters.getListner() == null) {
                    this.parameters.setListner(new WindowsDiscoveryListener(this.writer, defaulltValue, this.parameters.getAttriubuteDetails()));
                }
            } else if (this.parameters.getListner() == null) {
                throw new IllegalArgumentException("Listner cannot be null");
            }
            this.startDependentActivity();
        }
        finally {
            this.signalDiscoveryMainThread();
        }
    }

    @Override
    protected void startDependentActivity() throws DataAccessException {
        if (this.parameters.flushOldData()) {
            LOGGER.info("Delete BaseTable Old entries called for domain : " + this.parameters.getDomainName());
            String uniqueColumnName = this.parameters.getUniqueCriteriaColumnName();
            if (uniqueColumnName == null) {
                uniqueColumnName = "DOMAIN_ID";
            }
            DatabaseBulkUploadHandler.clearOldComputerEntries(this.parameters.getTableName(), uniqueColumnName, this.parameters.getUniqueCriteriavalue());
        } else {
            LOGGER.info("Process started withOut deleting Old entries for DOmain : " + this.parameters.getDomainName());
        }
    }

    private void signalDiscoveryMainThread() {
        this.parameters.getProcessLock().lock();
        try {
            LOGGER.info("Start DependentActivity wait check");
            this.parameters.setPreActivityCompleted(true);
            this.parameters.getProcessWaitCondn().signalAll();
            LOGGER.info("Start DependentActivity signal sent from windows discovery");
        }
        finally {
            this.parameters.getProcessLock().unlock();
        }
    }

    @Override
    protected void startPostActivity() throws InterruptedException {
        this.removeCurrentProcessOfDomain();
        if (this.writer != null) {
            this.writer.finalizeWriter();
        }
        long time = System.currentTimeMillis();
        this.waitFordependentProcessorToComplete();
        LOGGER.info("Time taken for DependentProcessToComplete (DataBase Dump):" + (System.currentTimeMillis() - time));
    }

    private void startWindowsDiscovery() throws Exception {
        long time = System.currentTimeMillis();
        LOGGER.info("Windows Discovery started At :" + time);
        ADSADErrorHandler errorHandler = DataCollector.getObjectsBasedOnFlag(this.parameters);
        if (errorHandler != null) {
            Hashtable errorList = errorHandler.getError((Object)this.parameters.getDomainName());
            try {
                if (errorList != null) {
                    if (errorList.get("ERROR_CODE") != null) {
                        BigInteger hexValue = new BigInteger(errorList.get("ERROR_CODE").toString(), 16);
                        this.parameters.getStatusHolder().setStatusCode(hexValue.longValue());
                    }
                    if (errorList.get("ERROR_MESSAGE") != null) {
                        this.parameters.getStatusHolder().setStatusMessage(errorList.get("ERROR_MESSAGE").toString());
                    }
                }
            }
            catch (Exception exp) {
                LOGGER.info("Unable to get Error information , details " + exp.getMessage());
            }
        }
        LOGGER.info("Time taken for Device Discovery (Dump data not included):" + (System.currentTimeMillis() - time) + " Search option " + this.parameters.getDiscoveryUniqueOption());
    }

    private void waitFordependentProcessorToComplete() throws InterruptedException {
        QueueProcessor<String> dependentDBuploader = this.parameters.getDependentDBProcessor();
        if (dependentDBuploader != null) {
            dependentDBuploader.stopIfQueueIsEmpty();
            dependentDBuploader.waitForCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlreadyRunning() {
        boolean result = false;
        String keyValyue = this.parameters.getDomainName().toUpperCase();
        ACCESS_LOCK.lock();
        try {
            HashSet<Integer> list;
            if (processingList.containsKey(keyValyue) && (list = processingList.get(keyValyue)).contains(this.parameters.getDiscoveryUniqueOption())) {
                result = true;
            }
        }
        finally {
            ACCESS_LOCK.unlock();
        }
        return result;
    }

    private void addCurrentProcessOfDomain() {
        String keyValyue = this.parameters.getDomainName().toUpperCase();
        ACCESS_LOCK.lock();
        try {
            HashSet<Object> list = null;
            list = processingList.containsKey(keyValyue) ? processingList.get(keyValyue) : new HashSet();
            list.add(this.parameters.getDiscoveryUniqueOption());
            processingList.put(keyValyue, list);
        }
        finally {
            ACCESS_LOCK.unlock();
        }
    }

    private void removeCurrentProcessOfDomain() {
        String keyValyue = this.parameters.getDomainName().toUpperCase();
        ACCESS_LOCK.lock();
        try {
            if (processingList.containsKey(keyValyue)) {
                HashSet<Integer> list = processingList.get(keyValyue);
                list.remove(this.parameters.getDiscoveryUniqueOption());
                if (list.isEmpty()) {
                    processingList.remove(keyValyue);
                }
            }
        }
        finally {
            ACCESS_LOCK.unlock();
        }
    }

    public TempFileWriter createQueuedWriter(String fileName, int maxProcessor, DataBaseSpecificActions defaulltValue) throws IllegalArgumentException, IllegalAccessException, IOException, InterruptedException {
        QueueProcessorParams params = new QueueProcessorParams();
        params.setFileEncoding(defaulltValue.getFileEncoding());
        params.setMaxProcessor(maxProcessor);
        params.setFileProcessorCallBack(this.parameters.getFileProcessor());
        params.setFilerotationNeeded(true);
        params.setFileOverHeadLimit(defaulltValue.getBulkUploadLimit());
        return FileIOHandler.createFileWriter(fileName, params);
    }

    private static String createTempFile(String domainName) throws IOException {
        File dir = new File(TEMPFILE_PATH);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = new StringBuffer(TEMPFILE_PATH).append(domainName).append(".txt").toString();
        return fileName;
    }

    @Override
    public boolean isCompleted() {
        if (this.parameters.getListner() != null) {
            return this.parameters.getListner().isCompleted();
        }
        return false;
    }

    @Override
    public boolean justifyParameters() {
        boolean result = true;
        if (this.parameters.getDomainName() == null) {
            result = false;
        }
        return result;
    }
}

