/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows;

import com.manageengine.ela.server.common.database.DefaultValueProvider;
import com.manageengine.ela.server.common.discovery.listner.ObjectDiscoveryListener;
import com.manageengine.ela.server.common.discovery.windows.WindowsAttributes;
import com.manageengine.ela.server.common.discovery.windows.WindowsDiscoveryUtil;
import com.manageengine.ela.server.common.executors.queue.CommonQueue;
import com.manageengine.ela.server.common.io.file.writer.DefaultFieldProcessor;
import com.manageengine.ela.server.common.io.file.writer.FileFieldsProcessor;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;

public class WindowsDiscoveryListener
implements ObjectDiscoveryListener {
    private CommonQueue<FileFieldsProcessor> queue = null;
    private DefaultValueProvider defaulltValueProvider = null;
    private ArrayList<WindowsAttributes> attributeDetails = null;
    private static final Logger LOGGER = Logger.getLogger(WindowsDiscoveryListener.class.getName());

    public WindowsDiscoveryListener(CommonQueue<FileFieldsProcessor> queue, DefaultValueProvider defaulltValue, ArrayList<WindowsAttributes> attributeDetails) throws IllegalArgumentException {
        if (queue == null || defaulltValue == null || attributeDetails == null) {
            throw new IllegalArgumentException("Invalid Arguments");
        }
        this.attributeDetails = attributeDetails;
        this.queue = queue;
        this.defaulltValueProvider = defaulltValue;
    }

    public void addRow(Properties adProperties) {
        ArrayList<String> resultFields = new ArrayList<String>();
        for (WindowsAttributes attr : this.attributeDetails) {
            String data = WindowsDiscoveryUtil.checkForConversion(attr, adProperties);
            resultFields.add(data);
        }
        DefaultFieldProcessor procss = new DefaultFieldProcessor(resultFields, this.defaulltValueProvider);
        try {
            this.queue.put(procss);
        }
        catch (Exception exp) {
            LOGGER.fine("Got Exception while adding Field " + procss + " ,  Details " + exp.getMessage());
        }
    }

    public boolean isCompleted() {
        return false;
    }
}

