/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows;

import com.manageengine.ela.server.common.data.conversion.DefaultDataTransformer;
import com.manageengine.ela.server.common.discovery.windows.WindowsAttributes;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class WindowsDiscoveryUtil {
    private static final Logger LOGGER = Logger.getLogger(WindowsDiscoveryUtil.class.getName());

    public static String checkForConversion(WindowsAttributes attr, Properties adProperties) {
        String result = null;
        if (attr.getSourceAttribute() != null) {
            String source = attr.getSourceAttribute();
            Object originalValue = adProperties.get(source);
            if (originalValue == null) {
                result = attr.getFieldDefaultValue();
            } else {
                Long transFormer = attr.getTransFormerID();
                if (transFormer != null) {
                    Object afterConversion = null;
                    try {
                        afterConversion = DefaultDataTransformer.getTransformer(transFormer).transform(originalValue, null, null);
                    }
                    catch (BaseStatusCode code) {
                        LOGGER.fine("recived Exception while converting Field " + originalValue + " ,  Details " + code.getMessage());
                    }
                    if (afterConversion != null) {
                        result = afterConversion.toString();
                        adProperties.setProperty(attr.getFieldName(), result);
                    }
                } else {
                    result = originalValue instanceof List ? ((List)originalValue).get(0).toString() : originalValue.toString();
                    adProperties.setProperty(attr.getFieldName(), result);
                }
            }
        }
        return result;
    }
}

