/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows;

import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public class WindowsFieldConverter {
    private static final Logger LOGGER = Logger.getLogger(WindowsFieldConverter.class.getName());

    public Object getDeviceIPAddress(Object original, Map<String, Object> value, Map<Object, Object> additionalArgs) {
        if (!this.canbeProcessed(original)) {
            return original;
        }
        try {
            String process = this.getStringValueToProcess(original);
            return InetAddressHandler.getInetAddress(process).getHostAddress();
        }
        catch (Exception exp) {
            LOGGER.fine("Exception while windows field tranform : " + exp.getMessage());
            return original;
        }
    }

    public Object getOperatingSystemType(Object original, Map<String, Object> value, Map<Object, Object> additionalArgs) {
        if (!this.canbeProcessed(original)) {
            return 2817;
        }
        try {
            String process = this.getStringValueToProcess(original);
            String osName = process.toUpperCase(Locale.ENGLISH);
            if (osName.contains("WINDOWS")) {
                if (osName.contains("SERVER")) {
                    return 2561;
                }
                return 2576;
            }
        }
        catch (Exception exp) {
            LOGGER.fine("Exception while windows field tranform : " + exp.getMessage());
        }
        return 2817;
    }

    public Object getHashCode(Object original, Map<String, Object> value, Map<Object, Object> additionalArgs) {
        try {
            if (!this.canbeProcessed(original)) {
                return 0;
            }
            String process = this.getStringValueToProcess(original);
            return process.hashCode();
        }
        catch (Exception exp) {
            LOGGER.fine("Exception while getting hashcode : " + exp.getMessage());
            return 0;
        }
    }

    public Object getParentDNFromDN(Object original, Map<String, Object> value, Map<Object, Object> additionalArgs) {
        if (!this.canbeProcessed(original)) {
            return original;
        }
        try {
            String process = this.getStringValueToProcess(original);
            if (process.indexOf(",") != -1) {
                return process.substring(process.indexOf(",") + 1);
            }
            return process;
        }
        catch (Exception exp) {
            LOGGER.fine("Exception while windows field tranform : " + exp.getMessage());
            return original;
        }
    }

    private boolean canbeProcessed(Object original) {
        return original != null;
    }

    private String getStringValueToProcess(Object original) {
        if (original instanceof ArrayList) {
            return (String)((ArrayList)original).get(0);
        }
        return original.toString();
    }
}

