/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows.domain;

import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ads.fw.db.util.DBUtil;
import com.manageengine.ads.fw.discovery.ad.ADDiscovery;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.discovery.BaseDiscoveryImpl;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.discovery.windows.domain.DomainDiscoveryTempCache;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class DomainDiscovery
extends BaseDiscoveryImpl {
    private static final AtomicBoolean STATUS = new AtomicBoolean(false);
    private static final Logger LOGGER = Logger.getLogger(DomainDiscovery.class.getName());

    public DomainDiscovery(DiscoveryParameters param) throws IllegalArgumentException {
        super(param);
        if (!this.justifyParameters()) {
            throw new IllegalAccessError(param.toString());
        }
    }

    @Override
    public synchronized void startDiscovery() throws Exception {
        if (STATUS.get()) {
            LOGGER.info("Domain discovery is already in progress");
            return;
        }
        try {
            STATUS.set(true);
            DomainDiscoveryTempCache.set(this.parameters);
            CommonUtil.updateSysConfiguration("DOAMIN_DISCOVERY_STARTUP", Boolean.TRUE, true);
            ADDiscovery.startDomainDiscovery();
        }
        finally {
            DomainDiscovery.finalizeDiscoveryStatus();
            STATUS.set(false);
        }
    }

    private static void finalizeDiscoveryStatus() {
        Object isMigratedVersion = CommonUtil.getSysConfiguration("DOAMIN_DISCOVERY_MIGRATION_FLAG");
        Boolean isMigration = isMigratedVersion != null && Boolean.valueOf(isMigratedVersion.toString()) != false;
        try {
            if (isMigration.booleanValue()) {
                DeviceUtil.startDeviceDomainIDMigration();
            }
            CommonUtil.updateSysConfiguration("DOAMIN_DISCOVERY_MIGRATION_FLAG", null, false);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            if (isMigration.booleanValue() || DBUtil.getCount((String)"ADSDomainConfiguration", null) > 0L) {
                if (!ServerDetailsBean.getInstance().getDoaminDiscoveryStatus()) {
                    ServerDetailsBean.getInstance().setDoaminDiscoveryStatus(true);
                    CommonUtil.updateSysConfiguration("DOAMIN_DISCOVERY_STATUS", Boolean.TRUE, true);
                }
            } else {
                ServerDetailsBean.getInstance().setDoaminDiscoveryStatus(false);
                CommonUtil.updateSysConfiguration("DOAMIN_DISCOVERY_STATUS", Boolean.FALSE, true);
                LOGGER.info("Domains are not discovered");
            }
        }
    }

    public static boolean isDiscoveryStarted() {
        return STATUS.get();
    }

    @Override
    public boolean isCompleted() {
        return false;
    }

    @Override
    public boolean justifyParameters() {
        return true;
    }
}

