/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows.domain;

import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.callback.CallBackArguments;
import com.manageengine.ela.server.common.callback.CommonCallBack;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.discovery.windows.domain.DomainDiscoveryTempCache;
import com.manageengine.ela.server.common.handlers.domain.DomainHandler;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class DomainDiscoveryListner
extends ADSDomainHandler {
    private static final Map<String, List<String>> DCCACHE = new ConcurrentHashMap<String, List<String>>();
    private static final Logger LOGGER = Logger.getLogger(DomainDiscoveryListner.class.getName());

    public void addDetails(Properties prop) {
        String domainName = prop.getProperty("DOMAIN_NAME");
        List<String> domainControllerList = DomainHandler.collectDCListFromNativeProperties(prop, domainName);
        if (DomainHandler.checkISValidDomainFromNative(prop, domainControllerList)) {
            DomainDiscoveryListner.addDCCache(domainName, domainControllerList);
            try {
                ADSDomainHandler.addDomainDetails((Properties)prop, (boolean[])new boolean[]{false});
                this.chekDomainCallback(domainName);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            DomainDiscoveryListner.clearDCCache(domainName);
        } else {
            LOGGER.info("Invalid domain recived from native, domain name : " + domainName);
        }
    }

    private void chekDomainCallback(String domainName) {
        DiscoveryParameters parameters = DomainDiscoveryTempCache.get();
        if (parameters != null && parameters.getCallBackInstance() != null) {
            CommonCallBack instance = parameters.getCallBackInstance();
            CallBackArguments arguments = parameters.getCallBackArgs();
            if (arguments == null) {
                arguments = new CallBackArguments();
            }
            arguments.put("domain_name", domainName);
            instance.callBack(parameters.getCallBackArgs());
        }
    }

    public static void addDCCache(String domain, List<String> dc) {
        DCCACHE.put(domain.toUpperCase(), dc);
    }

    public static List<String> getDCCache(String domain) {
        return DCCACHE.get(domain.toUpperCase());
    }

    public static void clearDCCache(String domain) {
        DCCACHE.remove(domain.toUpperCase());
    }
}

