/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows.domain;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.discovery.DiscoveryHandler;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.discovery.listner.ScheduleObjectDiscoveryListener;
import com.manageengine.ela.server.common.discovery.windows.domain.ScheduledDiscoveryParams;
import com.manageengine.ela.server.common.discovery.windows.ldap.ADQueryBase;
import com.manageengine.ela.server.common.discovery.windows.ldap.BasicLdapQuery;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.config.ELASchedule;
import com.manageengine.ela.server.common.schedule.config.ScheduleUtil;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ScheduledDiscoveryHandler {
    private static final Logger LOGGER = Logger.getLogger(ScheduledDiscoveryHandler.class.getName());

    public static void beginScheduledDiscovery(DataObject scheduleConfig) throws Exception {
        long startTime = System.currentTimeMillis();
        Row scheduleConfigRow = scheduleConfig.getFirstRow("ELADiscoveryScheduleConfig");
        Iterator itr = scheduleConfig.getRows("ELADiscoveryCriteriaConfig");
        Integer categoryID = (Integer)scheduleConfigRow.get("CATEGORY_ID");
        JSONObject domainDetails = ADSDomainHandler.getDomainDetailsFromID((Long)((Long)scheduleConfigRow.get("DOMAIN_ID")));
        DiscoveryParameters params = DiscoveryHandler.getCommonDomainDiscoveryParams(domainDetails, false, categoryID);
        params.setDiscoveryUniqueOption(500);
        params.setConfigureDefaultFileDump(false);
        DataObject historyInfo = ScheduledDiscoveryHandler.createScheduledImportHistory(scheduleConfigRow, startTime);
        Row historyRow = historyInfo.getFirstRow("ELADiscoveryScheduleHistory");
        String listnerclass = (String)scheduleConfigRow.get("LISTNER_CLASS");
        JSONObject additionalInput = null;
        if (scheduleConfigRow.get("ADDITIONAL_INPUT") != null) {
            additionalInput = new JSONObject((String)scheduleConfigRow.get("ADDITIONAL_INPUT"));
        }
        Constructor<?> cons = Class.forName(listnerclass).getConstructor(JSONObject.class, JSONObject.class, Row.class);
        ScheduleObjectDiscoveryListener scheduledDiscoveryListner = (ScheduleObjectDiscoveryListener)cons.newInstance(domainDetails, additionalInput, historyRow);
        params.setListner(scheduledDiscoveryListner);
        scheduledDiscoveryListner.preDiscovery();
        BasicLdapQuery ldapQuery = params.getLdapQuery();
        while (itr.hasNext()) {
            Row criteria = (Row)itr.next();
            String inbuiltCriteria = (String)criteria.get("INBUILT_CRITERIA");
            if (inbuiltCriteria == null) {
                LOGGER.info("All condns cannot be null ");
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
            JSONObject inbuiltCriteriaJSON = new JSONObject(inbuiltCriteria);
            if (inbuiltCriteriaJSON.has("GROUP_DN") && inbuiltCriteriaJSON.getJSONArray("GROUP_DN").length() != 0) {
                JSONArray domainGroups = TechnicianUtil.findScheduledInformation(inbuiltCriteriaJSON.getJSONArray("GROUP_DN"));
                ldapQuery.andQuery(ADQueryBase.getLDAPwithGroupCriteria(domainGroups));
            }
            BasicLdapQuery query = new BasicLdapQuery(ldapQuery.getQueryString());
            if (inbuiltCriteriaJSON.has("ADDITIONAL_CRITERIA")) {
                for (int index = 0; index < inbuiltCriteriaJSON.getJSONArray("ADDITIONAL_CRITERIA").length(); ++index) {
                    BasicLdapQuery childQuery = new BasicLdapQuery(inbuiltCriteriaJSON.getJSONArray("ADDITIONAL_CRITERIA").getString(index));
                    query.andQuery(childQuery);
                }
            }
            if (inbuiltCriteriaJSON.has("BASE_CONTEXT")) {
                JSONArray baseContextList = inbuiltCriteriaJSON.getJSONArray("BASE_CONTEXT");
                for (int index = 0; index < baseContextList.length(); ++index) {
                    query.setBaseContext(baseContextList.getString(index));
                    params.setLdapQuery(query);
                    DiscoveryHandler.startWindowsCustomDiscovery(params, false);
                }
                continue;
            }
            params.setLdapQuery(query);
            DiscoveryHandler.startWindowsCustomDiscovery(params, false);
        }
        scheduledDiscoveryListner.postDiscovery(params.getStatusHolder().getStatusCode() == null);
        historyRow.set("END_TIME", (Object)System.currentTimeMillis());
        historyInfo.updateRow(historyRow);
        PersistenceDBUtil.getPersistence().update(historyInfo);
    }

    private static DataObject createScheduledImportHistory(Row scheduleConfig, long startTime) throws DataAccessException {
        DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
        Row row = new Row("ELADiscoveryScheduleHistory");
        row.set("SCHEDULE_CONFIG_ID", scheduleConfig.get("SCHEDULE_CONFIG_ID"));
        row.set("START_TIME", (Object)startTime);
        dobj.addRow(row);
        return PersistenceDBUtil.getPersistence().add(dobj);
    }

    public static void createScheduledDiscovery(ScheduledDiscoveryParams params) throws DataAccessException, BaseStatusCode {
        ELASchedule scheduleInfo = params.getScheduleInfo();
        DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
        Row row = new Row("ELADiscoveryScheduleConfig");
        row.set("SCHEDULE_ID", scheduleInfo.getScheduleId());
        row.set("DOMAIN_ID", (Object)params.getDomainID());
        row.set("CATEGORY_ID", (Object)101);
        row.set("TYPE_ID", (Object)1);
        row.set("LISTNER_CLASS", (Object)params.getDiscoveryListner());
        row.set("ADDITIONAL_INPUT", (Object)params.getAdditionalInput().toString());
        row.set("STATUS_CODE", (Object)0);
        dobj.addRow(row);
        Row criteriaRow = new Row("ELADiscoveryCriteriaConfig");
        criteriaRow.set("SCHEDULE_CONFIG_ID", row.get("SCHEDULE_CONFIG_ID"));
        criteriaRow.set("INBUILT_CRITERIA", (Object)params.getInbuiltCriteria().toString());
        dobj.addRow(criteriaRow);
        scheduleInfo.addDependentDO(dobj);
        dobj = scheduleInfo.createSchedule();
        if (params.startNow()) {
            ScheduleUtil.startScheduleNow((Long)dobj.getFirstValue("Task_Input", "INSTANCE_ID"));
        }
    }
}

