/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows.ldap;

import com.manageengine.ela.server.common.discovery.windows.ldap.BasicLdapQuery;
import org.json.JSONArray;

public class ADQueryBase {
    public static BasicLdapQuery getAllComputers() {
        BasicLdapQuery basicLdapQuery = new BasicLdapQuery("objectCategory", "computer");
        basicLdapQuery.andQuery(new BasicLdapQuery("objectClass", "computer"));
        return basicLdapQuery;
    }

    public static BasicLdapQuery getWindowsServers() {
        BasicLdapQuery basicLdapQuery = ADQueryBase.getAllComputers();
        basicLdapQuery.andQuery(new BasicLdapQuery("operatingSystem", "Windows*Server*"));
        return basicLdapQuery;
    }

    public static BasicLdapQuery getWorkstations() {
        BasicLdapQuery basicLdapQuery = ADQueryBase.getAllComputers();
        basicLdapQuery.andQuery(new BasicLdapQuery("operatingSystem", "Windows*Server*").notQuery());
        return basicLdapQuery;
    }

    public static BasicLdapQuery getAllUsers() {
        BasicLdapQuery basicLdapQuery = new BasicLdapQuery("objectCategory", "user");
        basicLdapQuery.andQuery(new BasicLdapQuery("objectClass", "user"));
        return basicLdapQuery;
    }

    public static BasicLdapQuery getAllOUs() {
        BasicLdapQuery basicLdapQuery = new BasicLdapQuery("objectCategory", "OrganizationalUnit");
        basicLdapQuery.andQuery(new BasicLdapQuery("objectClass", "organizationalUnit"));
        return basicLdapQuery;
    }

    public static BasicLdapQuery getAllContainers() {
        BasicLdapQuery basicLdapQuery = new BasicLdapQuery("objectCategory", "Container");
        basicLdapQuery.andQuery(new BasicLdapQuery("objectClass", "container"));
        return basicLdapQuery;
    }

    public static BasicLdapQuery getAllOUsAndContainers() {
        BasicLdapQuery allOUs = ADQueryBase.getAllOUs();
        allOUs.orQuery(ADQueryBase.getAllContainers());
        return allOUs;
    }

    public static BasicLdapQuery getAllGroups() {
        BasicLdapQuery basicLdapQuery = new BasicLdapQuery("objectCategory", "group");
        return basicLdapQuery;
    }

    public static BasicLdapQuery getLDAPwithGroupCriteria(JSONArray domainGroups) {
        if (domainGroups != null && domainGroups.length() > 0) {
            try {
                BasicLdapQuery ldapQuery = new BasicLdapQuery();
                for (int index = 0; index < domainGroups.length(); ++index) {
                    BasicLdapQuery subldapQuery = new BasicLdapQuery("memberOf:1.2.840.113556.1.4.1941:", domainGroups.getJSONObject(index).getString("DISTINGUISHEDNAME"));
                    subldapQuery.orQuery(new BasicLdapQuery("primaryGroupID", domainGroups.getJSONObject(index).getString("PRIMARY_GROUP_TOKEN")));
                    if (domainGroups.getJSONObject(index).getString("OPERATION").equals("AND")) {
                        ldapQuery.andQuery(subldapQuery);
                        continue;
                    }
                    ldapQuery.orQuery(subldapQuery);
                }
                return ldapQuery;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }
}

