/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows.ldap;

import java.util.List;
import java.util.ListIterator;

public class BasicLdapQuery {
    private StringBuilder query = null;
    private String baseContext = null;

    public BasicLdapQuery() {
        this(new StringBuilder());
    }

    public BasicLdapQuery(StringBuilder stringBuilder) {
        this.setQuery(stringBuilder);
    }

    public BasicLdapQuery(String queryString) {
        this.query = new StringBuilder(queryString);
    }

    public BasicLdapQuery(String key, String value) {
        this.setQuery(new StringBuilder().append('('));
        this.query.append(key).append('=').append(value).append(')');
    }

    public StringBuilder getQuery() {
        return this.query;
    }

    private void setQuery(StringBuilder queryString) {
        this.query = queryString;
    }

    public String getQueryString() {
        return this.query.toString();
    }

    public BasicLdapQuery andQuery(List<BasicLdapQuery> list) {
        ListIterator<BasicLdapQuery> iter = list.listIterator();
        while (iter.hasNext()) {
            this.andQuery(iter.next());
        }
        return this;
    }

    public BasicLdapQuery orQuery(List<BasicLdapQuery> list) {
        ListIterator<BasicLdapQuery> iter = list.listIterator();
        while (iter.hasNext()) {
            this.orQuery(iter.next());
        }
        return this;
    }

    public BasicLdapQuery andQuery(BasicLdapQuery ldapQuery) {
        if (ldapQuery != null && ldapQuery.getQuery().length() != 0) {
            return this.joinQueries(ldapQuery, '&');
        }
        return this;
    }

    public BasicLdapQuery orQuery(BasicLdapQuery ldapQuery) {
        if (ldapQuery != null && ldapQuery.getQuery().length() != 0) {
            return this.joinQueries(ldapQuery, '|');
        }
        return this;
    }

    public BasicLdapQuery notQuery() {
        this.query.insert(0, '!');
        this.query.insert(0, '(');
        this.query.append(')');
        return this;
    }

    private BasicLdapQuery joinQueries(BasicLdapQuery ldapQuery, char operation) {
        if (this.query.length() == 0) {
            this.query = ldapQuery.getQuery();
            return ldapQuery;
        }
        if (this.query.charAt(1) == operation) {
            this.query.insert(this.query.length() - 1, ldapQuery.getQueryString());
        } else if (ldapQuery.getQuery().charAt(1) == operation) {
            this.setQuery(ldapQuery.getQuery().insert(2, this.getQueryString()));
        } else {
            this.query.insert(0, operation);
            this.query.insert(0, '(');
            this.query.append(ldapQuery.getQueryString());
            this.query.append(')');
        }
        return this;
    }

    public String getBaseContext() {
        return this.baseContext;
    }

    public void setBaseContext(String baseContext) {
        if (baseContext != null) {
            this.baseContext = baseContext;
        }
    }
}

