/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.discovery.windows.workgroup;

import com.manageengine.ela.server.common.discovery.BaseDiscoveryImpl;
import com.manageengine.ela.server.common.discovery.DiscoveryHandler;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.handlers.workgroup.WorkgroupHandler;
import com.manageengine.ela.server.common.jni.windows.ELANativeHandler;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class WorkGroupDiscovery
extends BaseDiscoveryImpl {
    private static final Logger LOGGER = Logger.getLogger(WorkGroupDiscovery.class.getName());
    private static final AtomicBoolean STATUS = new AtomicBoolean(false);

    public WorkGroupDiscovery(DiscoveryParameters param) throws IllegalArgumentException {
        super(param);
        if (!this.justifyParameters()) {
            throw new IllegalAccessError(param.toString());
        }
    }

    @Override
    public void startDiscovery() throws Exception {
        if (STATUS.get()) {
            LOGGER.info("Workgroup discovery is already in progress");
            return;
        }
        try {
            STATUS.set(true);
            long time = System.currentTimeMillis();
            LOGGER.info("Workgroup discovery module started at : " + time);
            ELANativeHandler.discoverWorkGroups();
            LOGGER.info("Workgroup discovery Ends total time taken : " + (System.currentTimeMillis() - time));
            LOGGER.info("Initializing Workgroup discovery callBack at : " + System.currentTimeMillis());
            super.checkCallBack();
            LOGGER.info("Total time taken for workgroup discovery module : " + (System.currentTimeMillis() - time));
        }
        finally {
            STATUS.set(false);
        }
    }

    public static boolean isDiscoveryStarted() {
        return STATUS.get();
    }

    @Override
    public boolean isCompleted() {
        return false;
    }

    public static void addWorkGroup(Properties workgroupDetails) {
        if (workgroupDetails != null && workgroupDetails.containsKey("WORKGROUP_NAME")) {
            LOGGER.info("Workgroup recived from native : " + workgroupDetails.get("WORKGROUP_NAME"));
            if (WorkgroupHandler.checkAndADDWorkgroupDetails(workgroupDetails)) {
                try {
                    LOGGER.info("Started device discovery for workgroup : " + workgroupDetails.get("WORKGROUP_NAME"));
                    DiscoveryHandler.startWindowsObjectDiscovery(workgroupDetails.get("WORKGROUP_NAME").toString(), false, true, 8, 2);
                    LOGGER.info("finished device discovery for workgroup : " + workgroupDetails.get("WORKGROUP_NAME"));
                }
                catch (Exception exp) {
                    LOGGER.info("Problem in device discovery for workgroup : " + workgroupDetails.get("WORKGROUP_NAME") + " , details : " + exp.getMessage());
                }
            }
        } else {
            LOGGER.info("Invalid Workgroup returend from native : " + workgroupDetails);
        }
    }

    @Override
    public boolean justifyParameters() {
        return true;
    }
}

