/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.ember.datasource;

import com.adventnet.customview.CustomViewManager;
import com.adventnet.customview.CustomViewRequest;
import com.adventnet.customview.ViewData;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.logsearch.index.util.LogSearchUtils;
import com.adventnet.model.table.CVTableModel;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.client.datasource.KeyBasedSearchResult;
import com.manageengine.ela.server.common.database.constants.SearchType;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.zoho.za.dae.elastic.LogIndexer;
import com.zoho.za.dae.elastic.Node;
import com.zoho.za.dae.schedule.ArchiveManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultDataSource {
    private static final int MAX_LIMIT = 8000;
    private static CustomViewManager customViewManager;
    private static final Logger LOGGER;

    public static long getTotalCount(QueryBuilder query) {
        Client client = Node.getClient();
        SearchResponse allHits = (SearchResponse)client.prepareSearch(new String[]{"*"}).setQuery(query).execute().actionGet();
        return allHits.getHits().getTotalHits();
    }

    public static LinkedList<HashMap<Column, Object>> getRows(SelectQuery selectQuery, int offset, int limit) throws Exception {
        LinkedList<HashMap<Column, Object>> table = new LinkedList<HashMap<Column, Object>>();
        if (limit == 0) {
            return table;
        }
        if (selectQuery == null) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        if (limit > 8000) {
            limit = 8000;
        }
        selectQuery.setRange(new Range(offset, limit));
        LOGGER.log(Level.FINE, "Table view query : " + RelationalAPI.getInstance().getSelectSQL((Query)selectQuery));
        DefaultDataSource.loadRequestResult(selectQuery, table);
        return table;
    }

    public static KeyBasedSearchResult getKeyBasedSearchResult(Column searchColumn, String condnString, SelectQuery selectQuery, Column conditionColumn, Locale locale, int offset, int limit) throws Exception {
        return DefaultDataSource.getKeyBasedSearchResult(searchColumn, condnString, selectQuery, conditionColumn, locale, offset, limit, SearchType.CONTAINS_IGNORE_CASE);
    }

    public static KeyBasedSearchResult getKeyBasedSearchResult(Column searchColumn, String condnString, SelectQuery selectQuery, Column conditionColumn, Locale locale, int offset, int limit, SearchType searchType) throws Exception {
        SelectQuery modifiedQuery;
        KeyBasedSearchResult initialSearchResult;
        if (limit == 0) {
            return KeyBasedSearchResult.getEmptyResultSet();
        }
        if (selectQuery == null) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        if (limit > 8000) {
            limit = 8000;
        }
        if (selectQuery.getSortColumns().isEmpty()) {
            selectQuery.addSortColumn(new SortColumn(searchColumn, true));
        }
        if ((initialSearchResult = DefaultDataSource.getKeyBasedSearchList(modifiedQuery = (SelectQuery)selectQuery.clone(), searchColumn, condnString, conditionColumn, locale, offset, limit, searchType)).isEmpty()) {
            return KeyBasedSearchResult.getEmptyResultSet();
        }
        Criteria derivedCriteria = new Criteria(searchColumn, (Object)initialSearchResult.getSearchedList().toArray(), 8);
        selectQuery.setRange(new Range(0, limit));
        DefaultDataSource.setCombinedCriteria(selectQuery, derivedCriteria);
        LOGGER.log(Level.FINE, "Table view query : " + RelationalAPI.getInstance().getSelectSQL((Query)selectQuery));
        LinkedList<HashMap<Column, Object>> table = new LinkedList<HashMap<Column, Object>>();
        DefaultDataSource.loadRequestResult(selectQuery, table);
        initialSearchResult.setResultList(table);
        return initialSearchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static KeyBasedSearchResult getKeyBasedSearchList(SelectQuery modifiedQuery, Column searchColumn, String condnString, Column conditionColumn, Locale locale, int offset, int limit, SearchType searchType) {
        ArrayList selectColumns = (ArrayList)modifiedQuery.getSelectColumns();
        for (Column column : selectColumns) {
            modifiedQuery.removeSelectColumn(column);
        }
        modifiedQuery.addSelectColumn(searchColumn);
        modifiedQuery.addSelectColumn(conditionColumn);
        Criteria notnullCriteria = new Criteria(searchColumn, null, 1);
        DefaultDataSource.setCombinedCriteria(modifiedQuery, notnullCriteria);
        ArrayList<String> resultString = new ArrayList<String>();
        Connection connection = null;
        DataSet dataset = null;
        long totalCount = 0L;
        try {
            String derivedString = condnString.toLowerCase();
            RelationalAPI relInstence = RelationalAPI.getInstance();
            ProductBundle prductBInstence = ProductBundle.getInstance();
            connection = relInstence.getConnection();
            dataset = relInstence.executeQuery((Query)modifiedQuery, connection);
            int counter = 1;
            while (dataset.next()) {
                String key = dataset.getValue(1).toString();
                Boolean condition = dataset.getAsBoolean(2);
                String value = condition != false ? prductBInstence.getString(locale, key) : key;
                if (!searchType.applyCondition(value, derivedString)) continue;
                if (offset > counter) {
                    ++counter;
                } else if (resultString.size() <= limit) {
                    resultString.add(key);
                }
                ++totalCount;
            }
        }
        catch (Exception exp) {
            try {
                exp.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetOrDataSet(null, dataset);
                DBUtil.closeStmtAndConnection(null, connection);
                throw throwable;
            }
            DBUtil.closeResultSetOrDataSet(null, dataset);
            DBUtil.closeStmtAndConnection(null, connection);
        }
        DBUtil.closeResultSetOrDataSet(null, dataset);
        DBUtil.closeStmtAndConnection(null, connection);
        return new KeyBasedSearchResult(resultString, totalCount);
    }

    private static void setCombinedCriteria(SelectQuery selectQuery, Criteria derivedCriteria) {
        Criteria existingCriteria = selectQuery.getCriteria();
        if (existingCriteria == null) {
            selectQuery.setCriteria(derivedCriteria);
        } else {
            selectQuery.setCriteria(existingCriteria.and(derivedCriteria));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadArchiveRequestResult(String originalTable, SelectQuery selectQuery, LinkedList<HashMap<Column, Object>> table) throws Exception {
        DataSet dataSet = null;
        Connection connection = null;
        int totalRows = 0;
        try {
            RelationalAPI relapi = RelationalAPI.getInstance();
            connection = relapi.getConnection();
            dataSet = relapi.getArchiveAdapter().getArchiveData(selectQuery, connection);
            while (dataSet.next()) {
                HashMap<Column, Object> singleRow = new HashMap<Column, Object>();
                List columnList = selectQuery.getSelectColumns();
                for (int columnIndex = 0; columnIndex < columnList.size(); ++columnIndex) {
                    Column column = (Column)columnList.get(columnIndex);
                    Column modified = Column.getColumn((String)originalTable, (String)column.getColumnName(), (String)column.getColumnAlias());
                    singleRow.put(modified, dataSet.getValue(column.getColumnAlias()));
                }
                ++totalRows;
                table.add(singleRow);
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSetOrDataSet(null, dataSet);
            DBUtil.closeStmtAndConnection(null, connection);
            throw throwable;
        }
        DBUtil.closeResultSetOrDataSet(null, dataSet);
        DBUtil.closeStmtAndConnection(null, connection);
        return totalRows;
    }

    public static int loadRequestResult(SelectQuery selectQuery, LinkedList<HashMap<Column, Object>> table) throws Exception {
        CustomViewRequest customViewRequest = new CustomViewRequest(selectQuery);
        if (customViewManager == null) {
            customViewManager = PersistenceDBUtil.getCustomViewManager();
        }
        ViewData viewData = customViewManager.getData(customViewRequest);
        CVTableModel model = (CVTableModel)viewData.getModel();
        int rowcount = model.getRowCount();
        for (int rowIndex = 0; rowIndex < rowcount; ++rowIndex) {
            HashMap<Column, Object> singleRow = new HashMap<Column, Object>();
            Column[] columnList = model.getColumns();
            for (int columnIndex = 0; columnIndex < columnList.length; ++columnIndex) {
                singleRow.put(columnList[columnIndex], model.getValueAt(rowIndex, columnIndex));
            }
            table.add(singleRow);
        }
        return rowcount;
    }

    public static LinkedList<HashMap<Column, Object>> getRows(String[] selIndices, QueryBuilder query, int offset, int limit) {
        Client client = Node.getClient();
        SearchResponse allHits = (SearchResponse)client.prepareSearch(selIndices).setQuery(query).addSort("TIME", SortOrder.DESC).setFrom(offset - 1).setSize(limit).execute().actionGet();
        SearchHit[] searchHitses = allHits.getHits().getHits();
        LinkedList<HashMap<Column, Object>> resultList = new LinkedList<HashMap<Column, Object>>();
        for (SearchHit searchHit : searchHitses) {
            Map map = searchHit.getSource();
            HashMap newMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                newMap.put(new Column("FROM_INDEX", (String)entry.getKey()), entry.getValue());
            }
            resultList.add(newMap);
        }
        return resultList;
    }

    public static JSONArray getSortedIndexCount(long fromTime, long toTime, int offset, int limit, boolean isAscending, List<SortColumn> sortColumn, Criteria deviceFilterCriteria, Set<Long> deviceID, String sortOn) throws JSONException, DataAccessException {
        RangeQueryBuilder timeRangeQueryBuilder = QueryBuilders.rangeQuery((String)"TIME").from(fromTime).to(toTime);
        return DefaultDataSource.getSortedIndexCount(timeRangeQueryBuilder, offset, limit, isAscending, sortColumn, deviceFilterCriteria, deviceID, sortOn);
    }

    private static JSONArray getSortedIndexCount(RangeQueryBuilder timeRangeQueryBuilder, int offset, int limit, boolean isAscending, List<SortColumn> sortColumn, Criteria deviceFilterCriteria, Set<Long> deviceIDList, String sortOn) throws JSONException, DataAccessException {
        Map<String, String> allowedDevices = DefaultDataSource.getDeviceListFromFilter(sortColumn, deviceFilterCriteria, deviceIDList);
        Set<String> deviceIDs = allowedDevices.keySet();
        if (sortOn == null) {
            sortOn = "_TOTAL_COUNT";
        } else if (!sortOn.startsWith("_")) {
            sortOn = "_" + sortOn;
        }
        Criteria appExculdeCriteria = new Criteria(Column.getColumn((String)"AppResources", (String)"FGROUP"), (Object)new String[]{"win_archive", "sys_archive", "syslog", "ibm_as400"}, 9);
        DataObject appExcludeDobj = PersistenceDBUtil.getPersistence().get("AppResources", appExculdeCriteria);
        Iterator rows = appExcludeDobj.getRows("AppResources");
        ArrayList<Object> appIdExcludeList = new ArrayList<Object>();
        while (rows.hasNext()) {
            appIdExcludeList.add(((Row)rows.next()).get("APPID"));
        }
        BoolQueryBuilder accessConstrainQuery = QueryBuilders.boolQuery();
        TermsQueryBuilder selAppsBuilder = QueryBuilders.termsQuery((String)"HOSTID", (Object[])deviceIDs.toArray());
        TermsQueryBuilder excludeAppsBuilder = QueryBuilders.termsQuery((String)"APPID", (Object[])appIdExcludeList.toArray());
        accessConstrainQuery.should((QueryBuilder)selAppsBuilder);
        accessConstrainQuery.mustNot((QueryBuilder)excludeAppsBuilder);
        BoolQueryBuilder resultQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)accessConstrainQuery).must((QueryBuilder)timeRangeQueryBuilder);
        BoolQueryBuilder notFIMContrain = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"HOSTTYPE", (Object)"FIM"));
        BoolQueryBuilder notFIREEYEContrain = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"HOSTTYPE", (Object)"FIREEYE"));
        BoolQueryBuilder notVCENTERContrain = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"HOSTTYPE", (Object)"VCENTER"));
        BoolQueryBuilder notSYMANTECContrain = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"HOSTTYPE", (Object)"SYMANTEC"));
        BoolQueryBuilder notSYMANTEC_DLPContrain = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"HOSTTYPE", (Object)"SYMANTEC_DLP"));
        BoolQueryBuilder notVULNERABILITYContrain = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"HOSTTYPE", (Object)"VULNERABILITY"));
        resultQueryBuilder.mustNot((QueryBuilder)notFIMContrain).mustNot((QueryBuilder)notVULNERABILITYContrain).mustNot((QueryBuilder)notSYMANTEC_DLPContrain).mustNot((QueryBuilder)notSYMANTECContrain).mustNot((QueryBuilder)notVCENTERContrain).mustNot((QueryBuilder)notFIREEYEContrain);
        Client client = Node.getClient();
        SearchResponse response = (SearchResponse)client.prepareSearch(new String[0]).setQuery((QueryBuilder)resultQueryBuilder).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)"0").field("HOSTID")).size(10000).order(Terms.Order.count((boolean)isAscending)).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)"1").field("SEVERITY")).size(100))).execute().actionGet();
        JSONArray resultArray = new JSONArray();
        ArrayList<String> countCollectedDevice = new ArrayList<String>();
        int total_index_count = 0;
        if (response != null && response.getAggregations() != null) {
            int i;
            Terms agg = (Terms)response.getAggregations().get("0");
            for (Terms.Bucket buc : agg.getBuckets()) {
                String deviceId = buc.getKeyAsString();
                String hostType = allowedDevices.get(deviceId);
                countCollectedDevice.add(deviceId);
                JSONObject resultObject = new JSONObject();
                resultObject.put("_TOTAL_COUNT", 0);
                resultObject.put("_ERR_COUNT", 0);
                resultObject.put("_WARN_COUNT", 0);
                resultObject.put("_OTHERS_COUNT", 0);
                resultObject.put("_FAIL_COUNT", 0);
                resultObject.put("_TOTAL_COUNT", (Object)String.valueOf(buc.getDocCount()));
                resultObject.put("HOSTID", (Object)deviceId);
                Terms agg1 = (Terms)buc.getAggregations().get("1");
                resultObject.put("HOST_TYPE", (Object)hostType);
                for (Terms.Bucket buc1 : agg1.getBuckets()) {
                    if (!NumberUtils.isNumber((String)buc1.getKeyAsString())) continue;
                    String key = DefaultDataSource.getCountColumnName(hostType, Integer.parseInt(buc1.getKeyAsString()));
                    resultObject.put(key, resultObject.getLong(key) + buc1.getDocCount());
                }
                resultArray.put((Object)resultObject);
            }
            total_index_count = resultArray.length();
            LinkedList<JSONObject> jsonObjects = new LinkedList<JSONObject>();
            for (int index = 0; index < resultArray.length(); ++index) {
                jsonObjects.add(resultArray.getJSONObject(index));
            }
            String finalBasedOn = sortOn;
            Collections.sort(jsonObjects, (o1, o2) -> {
                try {
                    Long val1 = Long.parseLong(o1.getString(finalBasedOn));
                    Long val2 = Long.parseLong(o2.getString(finalBasedOn));
                    if (isAscending) {
                        return val1.compareTo(val2);
                    }
                    return val2.compareTo(val1);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return 0;
                }
            });
            JSONArray sortedArray = new JSONArray();
            if (!isAscending) {
                int startsFrom;
                i = startsFrom = offset - 1 < 0 ? 0 : offset - 1;
                for (int count = 0; i < offset + limit && i < jsonObjects.size() && count < limit; ++i, ++count) {
                    sortedArray.put(jsonObjects.get(i));
                }
            } else {
                for (i = 0; i < jsonObjects.size(); ++i) {
                    sortedArray.put(jsonObjects.get(i));
                }
            }
            resultArray = sortedArray;
        }
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        selectQuery.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
        selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID"));
        deviceIDs.removeAll(countCollectedDevice);
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)deviceIDs.toArray(new String[deviceIDs.size()]), 8));
        if (!isAscending) {
            if (resultArray.length() < limit) {
                int startsFrom = offset - total_index_count < 0 ? 0 : offset - total_index_count;
                selectQuery.setRange(new Range(startsFrom, limit));
                selectQuery.addSortColumn(new SortColumn("Hosts", "HOST_NAME", false));
                DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get((SelectQuery)selectQuery);
                if (!dataObject.isEmpty()) {
                    Iterator iterator = dataObject.getRows("Hosts");
                    while (iterator.hasNext() && resultArray.length() < limit) {
                        Row row = (Row)iterator.next();
                        JSONObject resultObject = new JSONObject();
                        resultObject.put("HOSTID", (Object)row.get("HOST_ID").toString());
                        resultObject.put("_TOTAL_COUNT", 0);
                        resultObject.put("_ERR_COUNT", 0);
                        resultObject.put("_WARN_COUNT", 0);
                        resultObject.put("_OTHERS_COUNT", 0);
                        resultObject.put("_FAIL_COUNT", 0);
                        resultArray.put((Object)resultObject);
                    }
                }
            }
        } else {
            selectQuery.addSortColumn(new SortColumn("Hosts", "HOST_NAME", true));
            long totalcount = DBUtil.getTotalCount((SelectQuery)selectQuery);
            selectQuery.setRange(new Range(offset, limit));
            DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get((SelectQuery)selectQuery);
            JSONArray temp = new JSONArray();
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("Hosts");
                while (iterator.hasNext() && temp.length() < limit) {
                    Row row = (Row)iterator.next();
                    JSONObject resultObject = new JSONObject();
                    resultObject.put("HOSTID", (Object)row.get("HOST_ID").toString());
                    resultObject.put("_TOTAL_COUNT", 0);
                    resultObject.put("_ERR_COUNT", 0);
                    resultObject.put("_WARN_COUNT", 0);
                    resultObject.put("_OTHERS_COUNT", 0);
                    resultObject.put("_FAIL_COUNT", 0);
                    temp.put((Object)resultObject);
                }
            }
            Long i = (long)offset > totalcount ? (long)offset - totalcount - 1L : 0L;
            while (i < (long)resultArray.length() && temp.length() < limit) {
                temp.put(resultArray.get(i.intValue()));
                Long l = i;
                i = i + 1L;
                Long l2 = i;
            }
            resultArray = temp;
        }
        return resultArray;
    }

    private static Map<String, String> getDeviceListFromFilter(List<SortColumn> sortColumn, Criteria deviceFilterCriteria, Set<Long> deviceID) throws DataAccessException {
        HashMap<String, String> deviceDetails = new HashMap<String, String>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"Hosts"));
        query.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID"));
        query.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"TYPE"));
        if (sortColumn != null) {
            query.addSortColumns(sortColumn);
        }
        query.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
        if (deviceFilterCriteria != null) {
            if (deviceID != null) {
                query.setCriteria(deviceFilterCriteria.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceID.toArray(new Long[deviceID.size()]), 8)));
            } else {
                query.setCriteria(deviceFilterCriteria);
            }
        } else if (deviceID != null) {
            query.setCriteria(new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)deviceID.toArray(new Long[deviceID.size()]), 8));
        }
        DataObject dataObject = PersistenceDBUtil.getPersistenceLite().get((SelectQuery)query);
        if (dataObject != null) {
            Iterator iterator = dataObject.getRows("HostDetails");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                deviceDetails.put(row.get("HOST_ID").toString(), row.get("TYPE").toString());
            }
        }
        return deviceDetails;
    }

    public static SearchResponse getAggregateResult(List<AbstractAggregationBuilder> aggregations, QueryBuilder query, Long startTime, Long endTime) {
        Client client = Node.getClient();
        HashSet indices = LogSearchUtils.getIndicesInRange((Set)LogIndexer.getLogIndicesSet(), (long)(startTime / 1000L), (long)(endTime / 1000L));
        ArchiveManager.unArchiveIndices((Client)client, (Long)startTime, (Long)endTime, (boolean)true, (String)"corr_");
        SearchRequestBuilder builder = client.prepareSearch(indices.toArray(new String[indices.size()])).setQuery(query).setSize(0);
        for (AbstractAggregationBuilder aggregation : aggregations) {
            builder = builder.addAggregation(aggregation);
        }
        return (SearchResponse)builder.execute().actionGet();
    }

    public static JSONArray getLogIndexCount(String[] selIndices, HashMap<String, String> deviceMap, long fromTime, long toTime) {
        RangeQueryBuilder timeRangeQueryBuilder = QueryBuilders.rangeQuery((String)"TIME").from(fromTime).to(toTime);
        BoolQueryBuilder resultQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)timeRangeQueryBuilder);
        BoolQueryBuilder accessConstrainQuery = QueryBuilders.boolQuery();
        ArrayList<Object> appIdExcludeList = new ArrayList<Object>();
        try {
            Criteria appExculdeCriteria = new Criteria(Column.getColumn((String)"AppResources", (String)"FGROUP"), (Object)new String[]{"win_archive", "sys_archive", "syslog", "ibm_as400"}, 9);
            DataObject appExcludeDobj = PersistenceDBUtil.getPersistence().get("AppResources", appExculdeCriteria);
            Iterator rows = appExcludeDobj.getRows("AppResources");
            while (rows.hasNext()) {
                appIdExcludeList.add(((Row)rows.next()).get("APPID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TermsQueryBuilder selAppsBuilder = QueryBuilders.termsQuery((String)"HOSTID", (Object[])deviceMap.keySet().toArray());
        TermsQueryBuilder appExcludeBuilder = QueryBuilders.termsQuery((String)"APPID", (Object[])appIdExcludeList.toArray());
        accessConstrainQuery.should((QueryBuilder)selAppsBuilder);
        accessConstrainQuery.mustNot((QueryBuilder)appExcludeBuilder);
        resultQueryBuilder.must((QueryBuilder)accessConstrainQuery);
        BoolQueryBuilder notFIMContrain = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"HOSTTYPE", (Object)"FIM"));
        resultQueryBuilder.mustNot((QueryBuilder)notFIMContrain);
        Client client = Node.getClient();
        SearchResponse response = (SearchResponse)client.prepareSearch(selIndices).setQuery((QueryBuilder)resultQueryBuilder).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)"0").field("HOSTID")).size(10000).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)"1").field("SEVERITY")).size(100))).execute().actionGet();
        JSONArray deviceCountArray = new JSONArray();
        if (response != null && response.getAggregations() != null) {
            Terms agg = (Terms)response.getAggregations().get("0");
            for (Terms.Bucket buc : agg.getBuckets()) {
                try {
                    JSONObject rowJsonObject = new JSONObject();
                    rowJsonObject.put("_TOTAL_COUNT", 0);
                    rowJsonObject.put("_ERR_COUNT", 0);
                    rowJsonObject.put("_WARN_COUNT", 0);
                    rowJsonObject.put("_OTHERS_COUNT", 0);
                    rowJsonObject.put("_FAIL_COUNT", 0);
                    rowJsonObject.put("_TOTAL_COUNT", (Object)String.valueOf(buc.getDocCount()));
                    Terms agg1 = (Terms)buc.getAggregations().get("1");
                    String deviceId = buc.getKeyAsString();
                    rowJsonObject.put("HOSTID", (Object)deviceId);
                    for (Terms.Bucket buc1 : agg1.getBuckets()) {
                        if (!NumberUtils.isNumber((String)buc1.getKeyAsString())) continue;
                        String key = DefaultDataSource.getCountColumnName(deviceMap.get(deviceId), Integer.parseInt(buc1.getKeyAsString()));
                        rowJsonObject.put(key, rowJsonObject.getLong(key) + buc1.getDocCount());
                    }
                    deviceCountArray.put((Object)rowJsonObject);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return deviceCountArray;
    }

    private static String getCountColumnName(String deviceType, Integer bucketKey) {
        if (LogSourceCategoryContainer.DeviceCategory.getCategory(deviceType) == LogSourceCategoryContainer.DeviceCategory.WINDOWS) {
            switch (bucketKey) {
                case 0: {
                    return "_ERR_COUNT";
                }
                case 1: {
                    return "_WARN_COUNT";
                }
                case 2: 
                case 3: {
                    return "_OTHERS_COUNT";
                }
            }
            return "_FAIL_COUNT";
        }
        switch (bucketKey) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "_ERR_COUNT";
            }
            case 4: 
            case 5: {
                return "_WARN_COUNT";
            }
            case 6: 
            case 7: {
                return "_OTHERS_COUNT";
            }
        }
        return "_FAIL_COUNT";
    }

    static {
        LOGGER = Logger.getLogger(DefaultDataSource.class.getName());
    }
}

