/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.ember.transformer.config;

import com.adventnet.ds.query.Column;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.sa.server.nf.NotificationManager;
import com.manageengine.ela.server.common.alerts.util.AlertUtil;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.data.conversion.ConversionConstants;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.common.util.DateFormatUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

public class CommonConfigTransformer {
    public Object getGroupCountForTechnician(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws Exception {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Object userID = row.get(defaultArgs[0]);
        return TechnicianUtil.getGroupCount(userID);
    }

    public Object convertTechnicianStatus(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws Exception {
        String status = null;
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        ResponseBuilder builder = new ResponseBuilder();
        try {
            status = obj.toString();
        }
        catch (Exception e) {
            status = null;
        }
        if ("ACTIVE".equalsIgnoreCase(status)) {
            builder.setStatus(BaseStatusCode.getBaseStatusCode(7952));
            builder.addKeyPair("STATUS_CODE", 0);
        } else {
            builder.setStatus(BaseStatusCode.getBaseStatusCode(7953));
        }
        return builder.resolveStatusMsg(locale).getResponseJson();
    }

    public Object getImportedTechnicianCount(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws Exception {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Object schedulehistoryID = row.get(defaultArgs[0]);
        return TechnicianUtil.getImportedTechnicianCount(schedulehistoryID);
    }

    public Object convertHoursToDays(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws Exception {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Integer days = Integer.parseInt(row.get(defaultArgs[0]).toString()) / 24;
        return days + " " + ProductBundle.getInstance().getString(locale, "ela.discovery.display.unit.days");
    }

    public Object getDomainStatus(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws Exception {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        ResponseBuilder builder = new ResponseBuilder();
        Object statusKey = row.get(defaultArgs[0]);
        if (statusKey == null) {
            builder.addKeyPair("STATUS_CODE", 1);
            return builder;
        }
        if (statusKey != null && (statusKey.equals("ads.domain_confg.native.success") || statusKey.equals("admp.domain_settings.common.statmsg.success"))) {
            builder.addKeyPair("STATUS_CODE", 0);
        } else {
            builder.addKeyPair("STATUS_CODE", 1);
        }
        builder.addKeyPair("STATUS_MSG", ProductBundle.getInstance().getString(locale, statusKey.toString()));
        return builder.getResponseJson();
    }

    public String convertAlertStatus(Object mins, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Object statusId = row.get(defaultArgs[0]);
        ProductBundle i18n = ProductBundle.getInstance();
        switch ((Integer)statusId) {
            case 0: {
                return i18n.getString(locale, "alert.state.closed");
            }
            case 1: {
                return i18n.getString(locale, "alert.state.open");
            }
            case 2: {
                return i18n.getString(locale, "alert.state.progres");
            }
        }
        return i18n.getString(locale, "alert.state.unknown");
    }

    public String getAlertSource(Object source, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        if ((Long)row.get(defaultArgs[0]) == -1002L) {
            Locale locale = (Locale)additionalArgs.get("conversionLocale");
            ProductBundle i18n = ProductBundle.getInstance();
            return i18n.getString(locale, "ela.alert.filter.based_on_correlation_rule");
        }
        return source.toString();
    }

    public String convertAlertType(Object mins, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        ProductBundle i18n = ProductBundle.getInstance();
        String result = "";
        long type = (Long)row.get(defaultArgs[0]);
        Object notifID = row.get(defaultArgs[1]);
        NotificationManager nfManager = NotificationManager.getInstance();
        if (type == -1000L) {
            try {
                result = i18n.getString(locale, "Alerts.DefaultThreat");
            }
            catch (Exception e) {
                result = "Default Threat";
            }
        } else if (type == -1002L) {
            try {
                result = i18n.getString(locale, "Alert.CorrelationThreat");
            }
            catch (Exception e) {
                result = "Correlation Profile";
            }
        } else if (type == 257L) {
            try {
                result = i18n.getString(locale, "Alert.Profile.Predefined");
            }
            catch (Exception e) {
                result = "Predefined";
            }
        } else if (type == 256L) {
            try {
                result = i18n.getString(locale, "Alert.Profile.FIM");
            }
            catch (Exception e) {
                result = "FIM";
            }
        } else if (type == 1L) {
            try {
                result = i18n.getString(locale, "Alert.Profile.Compliance");
            }
            catch (Exception e) {
                result = "Compliance";
            }
        } else if (type == -1L) {
            if (nfManager.isAS400Profile((Long)notifID)) {
                try {
                    result = i18n.getString(locale, "Alert.Profile.AS400");
                }
                catch (Exception e) {
                    result = "AS400";
                }
            } else {
                try {
                    result = i18n.getString(locale, "Alert.Profile.Custom");
                }
                catch (Exception e) {
                    result = "Custom";
                }
            }
        } else {
            try {
                result = i18n.getString(locale, "Alert.Profile.Custom");
            }
            catch (Exception e) {
                result = "Custom";
            }
        }
        return result;
    }

    public String convertAlertDevice(Object mins, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Long profileType;
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        if (row.containsKey(defaultArgs[1]) && (profileType = (Long)row.get(defaultArgs[1])) == -1002L) {
            return ProductBundle.getInstance().getString(locale, "ela.alert.filter.based_on_correlation_rule");
        }
        Object type = AlertUtil.getDeviceList(row.get(defaultArgs[0]));
        return (String)type;
    }

    public String getNotificationType(Object mins, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        String notifType = AlertUtil.getNotificationType(row.get(defaultArgs[0]));
        return notifType;
    }

    public String getNotificationName(Object mins, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        try {
            if (row.containsKey(defaultArgs[1]) && ((Boolean)row.get(defaultArgs[1])).booleanValue()) {
                return ProductBundle.getInstance().getString(locale, row.get(defaultArgs[0]).toString());
            }
        }
        catch (Exception e) {
            return ProductBundle.getInstance().getString(locale, "Alert.ProfileUnavailable");
        }
        return row.get(defaultArgs[0]).toString();
    }

    public String getModifiedReportName(Object mins, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        try {
            return ProductBundle.getInstance().getString(locale, row.get(defaultArgs[0]).toString());
        }
        catch (Exception e) {
            return row.get(defaultArgs[0]).toString();
        }
    }

    public String findLocaleString(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        return ProductBundle.getInstance().getString(locale, row.get(defaultArgs[0]).toString());
    }

    public String findCorrelationLocaleString(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        return row.containsKey(defaultArgs[1]) && (Boolean)row.get(defaultArgs[1]) != false ? this.findLocaleString(obj, row, additionalArgs) : (String)row.get(defaultArgs[0]);
    }

    public Object findRuleTableAction(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException {
        ResponseBuilder builder = new ResponseBuilder();
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Boolean isActionEditable = (Boolean)row.get(defaultArgs[0]) != false && (Boolean)row.get(defaultArgs[2]) == false;
        Long status = (Long)row.get(defaultArgs[1]);
        builder.addKeyPair("EDIT_ENABLED", isActionEditable);
        builder.addKeyPair("DELETE_ENABLED", isActionEditable);
        builder.addKeyPair("RULE_ENABLED", status == 1L);
        return builder.getResponseJson();
    }

    public String convertCustomAlertTimeFormat(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        if (obj == null) {
            return null;
        }
        long dateInMilliSec = 0L;
        try {
            dateInMilliSec = Long.parseLong(obj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getFormatedDate(additionalArgs, dateInMilliSec, 2);
    }

    public String convertScheduleTimeFormat(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        if (obj == null) {
            return ProductBundle.getInstance().getString(locale, "ela.schedule.completed");
        }
        long dateInMilliSec = 0L;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            Date date = dateFormat.parse(obj.toString());
            dateInMilliSec = date.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getFormatedDate(additionalArgs, dateInMilliSec, 2);
    }

    public String findExportFrequency(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Integer exportType = (Integer)row.get(defaultArgs[0]);
        switch (exportType) {
            case 0: {
                return ProductBundle.getInstance().getString(locale, "ela.table.export.onlyonce");
            }
            case 1: {
                return ProductBundle.getInstance().getString(locale, "ela.table.export.everyhour");
            }
            case 2: {
                return ProductBundle.getInstance().getString(locale, "ela.table.export.everyday");
            }
            case 3: {
                return ProductBundle.getInstance().getString(locale, "ela.table.export.everyweek");
            }
            case 4: {
                return ProductBundle.getInstance().getString(locale, "ela.table.export.everymonth");
            }
        }
        return null;
    }

    private String getFormatedDate(Map<Object, Object> additionalArgs, long time, int type) {
        Object clientTimeZone = additionalArgs.get("clienttimezone");
        TimeZone tz = null;
        if (clientTimeZone != null && clientTimeZone instanceof TimeZone) {
            tz = (TimeZone)clientTimeZone;
        }
        if (type == 1) {
            return DateFormatUtil.getFormattedTimeForClient(time, tz);
        }
        return DateFormatUtil.getFormattedTimeForClient_1(time, tz);
    }

    public String findDuration(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long activityStartTime = (Long)row.get(defaultArgs[0]);
        if (row.get(defaultArgs[1]) != null) {
            Long activityEndTime = (Long)row.get(defaultArgs[1]);
            Long millis = activityEndTime - activityStartTime;
            return String.format("%02d hrs : %02d min : %02d sec", TimeUnit.MILLISECONDS.toHours(millis), TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(millis)), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        }
        return "-";
    }
}

