/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.ember.transformer.config;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.QueryConstructionException;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.application.others.ApplicationMgmtUtils;
import com.manageengine.ela.server.application.webserver.iis.IISUtil;
import com.manageengine.ela.server.application.webserver.iis.constants.IISApplicationConstants;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.config.ports.ManageSyslogListenerPort;
import com.manageengine.ela.server.common.data.conversion.ConversionConstants;
import com.manageengine.ela.server.common.device.LogCollectionStatus;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.group.util.DeviceGroupUtil;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.ember.transformer.config.TransformerUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class TransformMethodHandler {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final Logger LOGGER = Logger.getLogger(TransformMethodHandler.class.getName());

    public Object convertToErrorStatusWithLink(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Long statusCode;
        boolean isLiveCollection = false;
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        ResponseBuilder builder = new ResponseBuilder();
        try {
            statusCode = Long.valueOf(obj.toString());
        }
        catch (Exception e) {
            statusCode = 0L;
            LOGGER.log(Level.FINE, "Exception in data conversion");
        }
        LogCollectionStatus logCollectionstatus = this.getLogcollectionStatus(row, defaultArgs[0]);
        LogSourceCategoryContainer.DeviceCategory category = this.getDeviceCategory(row, defaultArgs[2]);
        isLiveCollection = this.isLiveLogcollection(row, defaultArgs[1]);
        try {
            if (category == LogSourceCategoryContainer.DeviceCategory.UNKNOWN) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(9500));
            } else if (logCollectionstatus == LogCollectionStatus.DISABLED) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(4097));
                builder.setCustomStatusMsg("ela.statuscode.displaytext.device.disabled");
            } else if (logCollectionstatus == LogCollectionStatus.SCANNING) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(0));
                builder.setCustomStatusMsg("ela.statuscode.displaytext.devicescanning");
            } else if (logCollectionstatus == LogCollectionStatus.PING) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(0));
                builder.setCustomStatusMsg("ela.statuscode.displaytext.deviceping");
            } else if (statusCode == 0L) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(0));
                if (isLiveCollection) {
                    builder.setCustomStatusMsg("ela.statuscode.displaytext.event.listening");
                } else {
                    builder.setCustomStatusMsg("ela.statuscode.displaytext.event.succcess");
                }
            } else {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(statusCode));
            }
        }
        catch (JSONException exp) {
            LOGGER.log(Level.FINE, "Exception in status update" + (Object)((Object)exp));
        }
        return builder.resolveStatusMsg(locale).getResponseJson();
    }

    public Object findDeviceGroupAction(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException {
        ResponseBuilder builder = new ResponseBuilder();
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        long groupID = Long.parseLong(row.get(defaultArgs[0]).toString());
        if (groupID == DeviceGroupUtil.getDefaultGroupID()) {
            builder.addKeyPair("EDIT_ENABLED", Boolean.FALSE);
            builder.addKeyPair("DELETE_ENABLED", Boolean.FALSE);
            builder.addKeyPair("NAME_ENABLED", Boolean.FALSE);
        } else if (groupID == DeviceGroupUtil.getWindowsGroupID() || groupID == DeviceGroupUtil.getUnixGroupID()) {
            builder.addKeyPair("EDIT_ENABLED", Boolean.TRUE);
            builder.addKeyPair("DELETE_ENABLED", Boolean.FALSE);
            builder.addKeyPair("NAME_ENABLED", Boolean.FALSE);
        } else {
            builder.addKeyPair("EDIT_ENABLED", Boolean.TRUE);
            builder.addKeyPair("NAME_ENABLED", Boolean.TRUE);
            builder.addKeyPair("DELETE_ENABLED", Boolean.TRUE);
        }
        return builder.getResponseJson();
    }

    public Object getDeviceCountFromGroup(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Object groupID = row.get(defaultArgs[0]);
        return DeviceGroupUtil.getDeviceCount(groupID);
    }

    public Object getMSFromGroup(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long groupID = (Long)row.get(defaultArgs[0]);
        Long managedServerID = groupID / 1000000000L * 1000000000L;
        Criteria criteria = new Criteria(Column.getColumn((String)"Collectors", (String)"START_ID"), (Object)managedServerID, 0);
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get("Collectors", criteria);
            Row msRow = dobj.getFirstRow("Collectors");
            LOGGER.log(Level.FINER, "getMSFromGroup device group id=" + groupID + " ms=" + msRow.get("HOSTNAME"));
            return msRow.get("HOSTNAME");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while finding managed server of device group id=" + groupID);
            e.printStackTrace();
            return null;
        }
    }

    public Object convertDeviceType(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        if (obj == null) {
            return null;
        }
        LogSourceCategoryContainer.DeviceCategory category = LogSourceCategoryContainer.DeviceCategory.getCategory(obj.toString());
        if (category == LogSourceCategoryContainer.DeviceCategory.UNKNOWN) {
            return LogSourceCategoryContainer.DeviceCategory.UNKNOWNCATEGORY.getCategoryName();
        }
        return category.getCategoryName();
    }

    public String convertToDate(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        if (obj == null) {
            return null;
        }
        long dateInMilliSec = 0L;
        try {
            dateInMilliSec = Long.parseLong(obj.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Exception in convertToDate" + e);
        }
        return TransformerUtil.getDateFromMilliSec(dateInMilliSec, additionalArgs);
    }

    public String convertToCustomDate(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        if (obj == null) {
            return null;
        }
        long dateInMilliSec = 0L;
        try {
            dateInMilliSec = Long.parseLong(obj.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Exception in convertToDate" + e);
        }
        return TransformerUtil.getDateFromMilliSec(dateInMilliSec, additionalArgs, "MMM dd yyyy HH:mm:ss");
    }

    @Deprecated
    public boolean isDeviceActive(Object object, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        return !object.toString().equals("0");
    }

    public boolean isAgent(Object slid, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Long sysEvtcolid = ServerDetailsBean.getInstance().getSysEvtColID();
        return sysEvtcolid != null && !slid.toString().equals(sysEvtcolid.toString());
    }

    public String getMonitorInterval(Object mins, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        String result = null;
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        boolean isLiveCollection = this.isLiveLogcollection(row, defaultArgs[0]);
        LogSourceCategoryContainer.DeviceCategory category = this.getDeviceCategory(row, defaultArgs[1]);
        try {
            result = category == LogSourceCategoryContainer.DeviceCategory.UNKNOWN ? ProductBundle.getInstance().getString("ela.statuscode.displaytext.device.unknown.monitorinterval") : (!isLiveCollection ? String.valueOf(mins) + " " + ProductBundle.getInstance().getString("ela.discovery.display.unit.mins") : ProductBundle.getInstance().getString("ela.statuscode.displaytext.event.realtime"));
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Exception in getMonitorInterval" + e);
        }
        return result;
    }

    public Object getNextScanTime(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        ResponseBuilder builder = new ResponseBuilder();
        Object collectorID = row.get(defaultArgs[2]);
        boolean isLiveCollection = this.isLiveLogcollection(row, defaultArgs[3]);
        LogSourceCategoryContainer.DeviceCategory category = this.getDeviceCategory(row, defaultArgs[5]);
        LogCollectionStatus logCollectionstatus = this.getLogcollectionStatus(row, defaultArgs[4]);
        if (category == LogSourceCategoryContainer.DeviceCategory.UNKNOWN) {
            builder.setCustomStatusMsg("ela.statuscode.displaytext.device.unknown.getnextscantime");
        } else if (logCollectionstatus == LogCollectionStatus.DISABLED) {
            builder.setCustomStatusMsg("ela.statuscode.displaytext.device.disabled.nextscan");
        } else if (isLiveCollection) {
            builder.addKeyPair("PINGNOW", "true");
            builder.setCustomStatusMsg("ela.statuscode.displaytext.device.live.nextscan");
        } else {
            if (collectorID != null && collectorID.toString().equals(String.valueOf(ServerDetailsBean.getInstance().getSysEvtColID()))) {
                builder.addKeyPair("SCANNOW", "true");
            }
            Calendar resultDate = TransformerUtil.getCalender(additionalArgs);
            SimpleDateFormat dateFormat = TransformerUtil.getDateFormat(additionalArgs);
            try {
                long dateInMilliSec = Long.parseLong(row.get(defaultArgs[0]).toString());
                resultDate.setTimeInMillis(dateInMilliSec);
            }
            catch (NumberFormatException e) {
                try {
                    resultDate.setTime(dateFormat.parse(row.get(defaultArgs[0]).toString()));
                }
                catch (ParseException e1) {
                    LOGGER.log(Level.FINE, "Exception while calculating next scan time");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception while calculating next scan time interval");
            }
            resultDate.add(12, Integer.parseInt(row.get(defaultArgs[1]).toString()));
            try {
                if (resultDate.getTimeInMillis() <= System.currentTimeMillis()) {
                    builder.setCustomStatusMsg("ela.statuscode.displaytext.devicenextscanstatus");
                } else {
                    dateFormat.setCalendar(resultDate);
                    builder.setCustomStatusMsg(dateFormat.format(resultDate.getTime()));
                }
            }
            catch (Exception exp) {
                LOGGER.log(Level.FINE, "Exception while calculating next scan time status update");
            }
        }
        return builder.resolveStatusMsg(locale).getResponseJson();
    }

    public String getNameFromDN(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        String distndName = obj.toString();
        try {
            return distndName.substring(distndName.indexOf("=") + 1, distndName.indexOf(","));
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Exception in DN 2 Name conversion");
            return distndName;
        }
    }

    private boolean isLiveLogcollection(Map<Column, Object> row, Column key) {
        try {
            Object status = row.get(key);
            return status != null && NumberUtils.isNumber((String)status.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Exception in parameter convertion");
            return false;
        }
    }

    private LogSourceCategoryContainer.DeviceCategory getDeviceCategory(Map<Column, Object> row, Column key) {
        return DeviceUtil.getDeviceCategory(row.get(key));
    }

    private LogCollectionStatus getLogcollectionStatus(Map<Column, Object> row, Column key) {
        return DeviceUtil.getLogCollectionStatus(row.get(key));
    }

    public Object findPortAction(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException {
        ResponseBuilder builder = new ResponseBuilder();
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        long groupID = Long.parseLong(row.get(defaultArgs[0]).toString());
        if (ManageSyslogListenerPort.isDefaultPort(groupID)) {
            builder.addKeyPair("DELETE_ENABLED", Boolean.FALSE);
        } else {
            builder.addKeyPair("DELETE_ENABLED", Boolean.TRUE);
        }
        return builder.getResponseJson();
    }

    public Object getPortStatus(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException {
        Locale locale = (Locale)additionalArgs.get("conversionLocale");
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        boolean enabled = (Boolean)row.get(defaultArgs[0]);
        long status = (Long)obj;
        ResponseBuilder builder = new ResponseBuilder();
        if (enabled) {
            if (status == 0L) {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(0));
                builder.setCustomStatusMsg("ela.statuscode.displaytext.event.listening");
            } else {
                builder.setStatus(BaseStatusCode.getBaseStatusCode(status));
            }
        } else {
            builder.setStatus(BaseStatusCode.getBaseStatusCode(4097));
            builder.setCustomStatusMsg("ela.statuscode.displaytext.device.disabled");
        }
        return builder.resolveStatusMsg(locale).getResponseJson();
    }

    public Object findWindowsDeviceAction(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) throws JSONException {
        ResponseBuilder builder = new ResponseBuilder();
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        try {
            if (ServerDetailsBean.getInstance().isWindows()) {
                builder.addKeyPair("EVTFILE_SHOW", Boolean.TRUE);
                if (DeviceUtil.isConfigurable((Long)row.get(defaultArgs[0]))) {
                    builder.addKeyPair("EVTFILE_ENABLED", Boolean.TRUE);
                } else {
                    builder.addKeyPair("EVTFILE_ENABLED", Boolean.FALSE);
                }
            } else {
                builder.addKeyPair("EVTFILE_SHOW", Boolean.FALSE);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return builder.getResponseJson();
    }

    public Object applicationViewReport(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        return "View Report";
    }

    public Object getNumberOfSites(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long numberOfSites = (Long)row.get(defaultArgs[0]);
        return numberOfSites + " " + TransformMethodHandler.resolveI18N("ela.application.sites");
    }

    public static String resolveI18N(String key) {
        return ProductBundle.getInstance().getString(key);
    }

    public Object getNextScheduleTime(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Object scheduleTime = row.get(defaultArgs[1]);
        if (scheduleTime != null) {
            try {
                SimpleDateFormat formatSrc = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                return TransformerUtil.getDateFromMilliSec(formatSrc.parse(scheduleTime.toString()).getTime(), additionalArgs);
            }
            catch (Exception e) {
                return scheduleTime;
            }
        }
        return null;
    }

    public Object getLogFileDirectory(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long siteId = (Long)row.get(defaultArgs[0]);
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"IISLogFIleInfo", (String)"SITE_ID"), (Object)siteId, 0);
            DataObject dataObject = PERSISTENCELITE.get("IISLogFIleInfo", criteria);
            Row fielsRow = dataObject.getRow("IISLogFIleInfo");
            return fielsRow.get("DIRECTORY");
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getWebServerStatus(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        try {
            Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
            Long webServerId = (Long)row.get(defaultArgs[0]);
            Long serverStatus = IISUtil.getStatus((Long)row.get(defaultArgs[1]));
            JSONObject retJson = new JSONObject();
            if (serverStatus.equals(IISApplicationConstants.ENABLED)) {
                Long appId = IISUtil.addAndGetIISUniqueId(webServerId);
                Criteria criteria = new Criteria(Column.getColumn((String)"IISConfiguredSites", (String)"APPID"), (Object)appId, 0);
                DataObject dataObject = PERSISTENCELITE.get("IISConfiguredSites", criteria);
                Iterator configuredRowsIterator = dataObject.getRows("IISConfiguredSites");
                ArrayList<Long> siteIdList = new ArrayList<Long>();
                while (configuredRowsIterator.hasNext()) {
                    Row configuredSitesRow = (Row)configuredRowsIterator.next();
                    siteIdList.add((Long)configuredSitesRow.get("SITE_ID"));
                }
                Long[] list = siteIdList.toArray(new Long[siteIdList.size()]);
                Criteria criteria2 = new Criteria(Column.getColumn((String)"IISLogFIleInfo", (String)"SITE_ID"), (Object)list, 8);
                DataObject dataObject2 = PERSISTENCELITE.get("IISLogFIleInfo", criteria2);
                configuredRowsIterator = dataObject2.getRows("IISLogFIleInfo");
                ArrayList<Long> fileIdList = new ArrayList<Long>();
                while (configuredRowsIterator.hasNext()) {
                    Row configuredFilesRow = (Row)configuredRowsIterator.next();
                    fileIdList.add((Long)configuredFilesRow.get("FILE_ID"));
                }
                Long[] list1 = fileIdList.toArray(new Long[fileIdList.size()]);
                Criteria criteria1 = new Criteria(Column.getColumn((String)"IISLogAuditDetails", (String)"FILE_ID"), (Object)list1, 8);
                DataObject dataObject1 = PERSISTENCELITE.get("IISLogAuditDetails", criteria1);
                Iterator auditRowIterator = dataObject1.getRows("IISLogAuditDetails");
                int i = 0;
                int j = 0;
                while (auditRowIterator.hasNext()) {
                    Row auditRow = (Row)auditRowIterator.next();
                    Long status = (Long)auditRow.get("STATUS");
                    if (status == null) {
                        ++i;
                    } else if (status == 12196L) {
                        ++i;
                    } else if (status == 12145L || status == 12195L || status == 12194L) {
                        retJson.put("STATUS_CODE", (Object)IISApplicationConstants.STATUS_SCANNING);
                        retJson.put("STATUS_MESSAGE", (Object)"ember_scanning");
                        return retJson;
                    }
                    ++j;
                }
                if (j == 0) {
                    return null;
                }
                if (i == j) {
                    retJson.put("STATUS_CODE", (Object)IISApplicationConstants.STATUS_SUCCESS);
                    retJson.put("STATUS_MESSAGE", (Object)"ember_success");
                    return retJson;
                }
                if (i == 0) {
                    retJson.put("STATUS_CODE", (Object)IISApplicationConstants.STATUS_FAILED);
                    retJson.put("STATUS_MESSAGE", (Object)"ember_failed");
                    return retJson;
                }
                retJson.put("STATUS_CODE", (Object)IISApplicationConstants.STATUS_FAILED);
                retJson.put("STATUS_MESSAGE", (Object)"ember_failed");
                retJson.put("FAILED_SITES", j - i);
                return retJson;
            }
            retJson.put("STATUS_CODE", (Object)IISApplicationConstants.STATUS_DISABLED);
            retJson.put("STATUS_MESSAGE", (Object)"ember_disabled");
            return retJson;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Undefined";
        }
    }

    public Object getMonitorIntervalInMins(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long monInt = (Long)row.get(defaultArgs[0]);
        Long numberOfSites = (Long)row.get(defaultArgs[1]);
        if (numberOfSites > 0L) {
            return monInt + " " + TransformMethodHandler.resolveI18N("ela.discovery.display.unit.mins");
        }
        return null;
    }

    public Object getSiteStatus(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long status = (Long)row.get(defaultArgs[0]);
        try {
            if (status == null) {
                return new JSONObject().put("STATUS_MSG", (Object)TransformMethodHandler.resolveI18N("ela.application.iis.site.status.success")).put("STATUS", true);
            }
            if (status == 12196L) {
                return new JSONObject().put("STATUS_MSG", (Object)TransformMethodHandler.resolveI18N("ela.application.iis.site.status.success")).put("STATUS", true);
            }
            if (status == 12197L || status == 12033L) {
                return new JSONObject().put("STATUS_MSG", (Object)TransformMethodHandler.resolveI18N("ela.application.iis.site.status.failed")).put("STATUS", false);
            }
            return new JSONObject().put("STATUS_MSG", (Object)TransformMethodHandler.resolveI18N("ela.application.iis.site.status.scanning")).put("STATUS", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getAppStartTime(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        return null;
    }

    public Object getAppImportedTime(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        return null;
    }

    public Object getAppEndTime(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAppCount(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long appId = (Long)row.get(defaultArgs[0]);
        int type = (Integer)row.get(defaultArgs[1]);
        Long totalCount = 0L;
        RelationalAPI relAPI = null;
        Connection conn = null;
        DataSet ds = null;
        try {
            if (type == 2) {
                Object var11_11 = null;
                return var11_11;
            }
            String trendTable = TransformMethodHandler.getTrendTableName(appId);
            String countKey = "TOTAL_CNT";
            if (trendTable == null) {
                trendTable = "ela_import_app_hr_trend_sa";
            }
            if (trendTable.equalsIgnoreCase("PrinterLogs_Hr_Trend")) {
                countKey = "JOBS";
            }
            relAPI = RelationalAPI.getInstance();
            conn = relAPI.getConnection();
            ds = relAPI.executeQuery("SELECT SUM(" + countKey + ") FROM " + trendTable + " WHERE APPID=" + appId, conn);
            if (ds.next()) {
                Long l = totalCount = Long.valueOf(totalCount + ds.getAsLong(1));
                return l;
            }
        }
        catch (QueryConstructionException | DataAccessException | SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                if (ds != null) {
                    ds.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return null;
    }

    public static String getTrendTableName(Long appId) throws DataAccessException {
        return ApplicationMgmtUtils.getTrendTableName(appId);
    }

    public JSONObject getAppParameter(Long appId, Map<Object, Object> additionalArgs) {
        Criteria criteria = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)appId, 0);
        ArrayList<Long> startTimeList = new ArrayList<Long>();
        ArrayList<Long> importedTimeList = new ArrayList<Long>();
        ArrayList<Long> endTimeList = new ArrayList<Long>();
        Object clientTimeZone = additionalArgs.get("clienttimezone");
        try {
            SimpleDateFormat formatDest = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
            formatDest.setTimeZone((TimeZone)clientTimeZone);
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AppResources"));
            DataObject dataObject = PERSISTENCELITE.get(Arrays.asList("AppResources", "ELAImportSourceConfigurations", "ELAImportLogAudit"), criteria);
            Iterator iterator = dataObject.getRows("ELAImportLogAudit");
            if (iterator.hasNext()) {
                do {
                    Row importAuditRow;
                    if ((importAuditRow = (Row)iterator.next()).get("LOG_START_TIME") != null) {
                        startTimeList.add((Long)importAuditRow.get("LOG_START_TIME"));
                    }
                    if (importAuditRow.get("START_TIME") != null) {
                        importedTimeList.add((Long)importAuditRow.get("START_TIME"));
                    }
                    if (importAuditRow.get("LOG_END_TIME") == null) continue;
                    endTimeList.add((Long)importAuditRow.get("LOG_END_TIME"));
                } while (iterator.hasNext());
                String startTime = formatDest.format(new Date((Long)Collections.min(startTimeList)));
                String importedTime = formatDest.format(new Date((Long)Collections.max(importedTimeList)));
                String endTime = formatDest.format(new Date((Long)Collections.max(endTimeList)));
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("START_TIME", (Object)startTime);
                jsonObject.put("IMPORTED_TIME", (Object)importedTime);
                jsonObject.put("END_TIME", (Object)endTime);
                return jsonObject;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object getIISLastScanTime(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long numberOfSites = (Long)row.get(defaultArgs[0]);
        if (numberOfSites > 0L) {
            return this.convertToDate(obj, null, additionalArgs);
        }
        return null;
    }

    public Object viewOtherAppReports(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Long appId = (Long)row.get(defaultArgs[0]);
        String formatDesc = (String)row.get(defaultArgs[1]);
        String url = FormatIdentifier.getReportUrl(formatDesc);
        Long formatId = (Long)row.get(defaultArgs[2]);
        String hostName = (String)row.get(defaultArgs[3]);
        Long hostId = (Long)row.get(defaultArgs[4]);
        SimpleDateFormat originalFormat = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
        SimpleDateFormat targetFormat = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
        JSONObject jsonObject = this.getAppParameter(appId, additionalArgs);
        try {
            Long startTimeStr = null;
            Long endTimeStr = null;
            if (jsonObject != null) {
                startTimeStr = originalFormat.parse(jsonObject.getString("START_TIME")).getTime() - 3600000L;
                endTimeStr = originalFormat.parse(jsonObject.getString("END_TIME")).getTime() + 3600000L;
            }
            ResponseBuilder responseBuilder = new ResponseBuilder();
            JSONObject reportParam = new JSONObject().put("FORMAT_ID", (Object)formatId).put("FORMAT_DESC", (Object)formatDesc).put("FORMAT_NAME", (Object)FormatIdentifier.getReportName(formatId)).put("APP_ID", (Object)appId).put("DEVICE_NAME", (Object)hostName).put("DEVICE_ID", (Object)hostId).put("START_TIME", (Object)startTimeStr).put("END_TIME", (Object)endTimeStr).put("AUDIT_DETAILS", (Object)jsonObject).put("URL", (Object)url);
            responseBuilder.setResponse(reportParam);
            return responseBuilder.getResponseJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object tableCountForDatabase(Object obj, Map<Column, Object> row, Map<Object, Object> additionalArgs) {
        Column[] defaultArgs = (Column[])additionalArgs.get(ConversionConstants.DEFAULT_ARGS);
        Object databaseID = row.get(defaultArgs[0]);
        Criteria crit1 = new Criteria(Column.getColumn((String)"SQLServerTables", (String)"DATABASE_ID"), databaseID, 0);
        long totalCount = DBUtil.getCountLong("SQLServerTables", crit1);
        return Long.toString(totalCount);
    }
}

