/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.executors.processor;

import com.manageengine.ela.server.common.executors.processor.QueueProcessor;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public abstract class CommonQueueProcessor<E>
implements QueueProcessor<E> {
    private final long defaultDelay = 1000L;
    protected static final AtomicInteger TOTAL_RUNNING_THREADS = new AtomicInteger();
    protected ConcurrentQueue<E> queue = null;
    protected volatile boolean isCompleted = false;
    protected AtomicBoolean stop = new AtomicBoolean(false);
    protected AtomicBoolean stopQueueIfempty = new AtomicBoolean(false);
    protected boolean stopIfIntruppted = false;
    private static final Logger LOGGER = Logger.getLogger(CommonQueueProcessor.class.getName());

    public CommonQueueProcessor(ConcurrentQueue<E> queue) throws IllegalArgumentException {
        if (queue == null) {
            throw new IllegalArgumentException("Queue Instance cannot be null");
        }
        this.queue = queue;
    }

    protected E getData() throws InterruptedException {
        return this.queue.get(1000L);
    }

    @Override
    public void run() {
        this.preInvoke();
        while (this.processStatus()) {
            try {
                E data = this.getData();
                if (data == null) continue;
                this.process(data);
            }
            catch (InterruptedException exp) {
                LOGGER.fine("Processor interrupted");
                if (!this.stopIfIntruppted) continue;
                LOGGER.info("Dispatcher is trying to stop processor");
                break;
            }
            catch (Exception exp) {
                LOGGER.info("Exception received from process data, details " + exp.getMessage());
            }
        }
        this.postInvoke();
    }

    @Override
    public boolean processStatus() {
        if (this.stop.get()) {
            return false;
        }
        return !this.stopQueueIfempty.get() || this.queue.size() != 0;
    }

    @Override
    public void preInvoke() {
        LOGGER.info("Total Processors running ,at new start: " + TOTAL_RUNNING_THREADS.incrementAndGet());
    }

    @Override
    public int getCurrentRunningThreads() {
        return TOTAL_RUNNING_THREADS.get();
    }

    @Override
    public void postInvoke() {
        LOGGER.info("Total Processors running ,at end : " + TOTAL_RUNNING_THREADS.decrementAndGet());
        this.isCompleted = true;
    }

    @Override
    public abstract void process(E var1) throws Exception;

    @Override
    public Thread start() {
        Thread thred = new Thread(this);
        thred.start();
        return thred;
    }

    @Override
    public void waitForCompletion() throws InterruptedException {
    }

    @Override
    public boolean isCompleted() {
        return this.isCompleted;
    }

    @Override
    public void stop() {
        this.stop.set(true);
    }

    @Override
    public void stopIfQueueIsEmpty() {
        this.stopQueueIfempty.set(true);
    }
}

